 /*
  * Khoros: $Id: dfilter.h,v 1.2 1992/03/20 23:31:08 dkhoros Exp $
  */

 /*
  * $Log: dfilter.h,v $
 * Revision 1.2  1992/03/20  23:31:08  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfilter.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Thu Mar  5 09:39:23 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dfilter_h_
#define _dfilter_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dfilter Argument Structure
*
****************************************************************/

typedef struct _dfilter  {

/*
 *  input signal file (xviff file) (Required infile)
 */
char	*i1_file;	/* input signal file (xviff file) FILENAME */
int	 i1_flag;	/* input signal file (xviff file) FLAG */

/*
 *  input filter file (polynomial file) (Required infile)
 */
char	*i2_file;	/* input filter file (polynomial file) FILENAME */
int	 i2_flag;	/* input filter file (polynomial file) FLAG */

/*
 *  resulting filtered signal file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting filtered signal file (xviff file) FILENAME */
int	 o_flag;	/* resulting filtered signal file (xviff file) FLAG */

/*
 *  scalar processing (0) or vector processing (1) (Optional logical)
 */
int	 j_logic;	/* scalar processing (0) or vector processing (1) LOGIC */
int	 j_flag;  	/* scalar processing (0) or vector processing (1) FLAG */

/*
 *  data processing direction (0 = down vectors, 1 = across bands) (Optional logical)
 */
int	 d_logic;	/* data processing direction (0 = down vectors, 1 = across bands) LOGIC */
int	 d_flag;  	/* data processing direction (0 = down vectors, 1 = across bands) FLAG */

}  dfilter_struct;

dfilter_struct *dfilter;

/* -include_additions */
#include "vpoly.h"
/* -include_additions_end */

/* -include_macros */
#define MAXPOLYS 1
#define MAXTERMS 600
#define MAXSTAGES 200
#define STRMAX 100

#define READIMAGE(image) \
image = readimage(dfilter->i1_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "dfilter: Can not read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"%s: data storage type must be float or complex.", \
                  program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);

/* -include_macros_end */

#endif
