 /*
  * Khoros: $Id: dltapp.h,v 1.2 1992/03/20 23:30:10 dkhoros Exp $
  */

 /*
  * $Log: dltapp.h,v $
 * Revision 1.2  1992/03/20  23:30:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dltapp.h
 >>>>            Author: Ramiro Jordan
 >>>> Date Last Updated: Sat Feb 15 16:27:06 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dltapp_h_
#define _dltapp_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dltapp Argument Structure
*
****************************************************************/

typedef struct _dltapp  {

/*
 *  input file (xviff file) (Required infile)
 */
char	*i_file;	/* input file (xviff file) FILENAME */
int	 i_flag;	/* input file (xviff file) FLAG */

/*
 *  resulting output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting output file (xviff file) FILENAME */
int	 o_flag;	/* resulting output file (xviff file) FLAG */

/*
 *  number of weights for the filter  (Optional integer)
 */
int	 s_int; 	/* number of weights for the filter  INT */
int	 s_flag;	/* number of weights for the filter  FLAG */

/*
 *  time delay parameter (Optional integer)
 */
int	 t_int; 	/* time delay parameter INT */
int	 t_flag;	/* time delay parameter FLAG */

/*
 *  specify the convergence parameter (Optional float)
 */
float	 c_float;	/* specify the convergence parameter FLOAT */
int	 c_flag;   	/* specify the convergence parameter FLAG */

/*
 *  scalar processing (0) or vector processing (1) (Optional logical)
 */
int	 j_logic;	/* scalar processing (0) or vector processing (1) LOGIC */
int	 j_flag;  	/* scalar processing (0) or vector processing (1) FLAG */

/*
 *  down vectors(0) or across bands(1) (Optional logical)
 */
int	 d_logic;	/* down vectors(0) or across bands(1) LOGIC */
int	 d_flag;  	/* down vectors(0) or across bands(1) FLAG */

/*
 * type of output file to be created (Optional integer toggle - )
 */
int	 g_toggle;		/* type of output file to be created INT TOGGLE */
int	 g_flag;		/* type of output file to be created FLAG */

}  dltapp_struct;

dltapp_struct *dltapp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
image = readimage(dltapp->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "%s: Can not read input image \n",program);  \
   exit(1);  /* Quit if bad image */ \
}

#define CHECKTYPE(program, image) \
    if( ! (propertype(program,image,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) ) { \
          fprintf(stderr,"%s: data storage type must be float or complex.", \
                  program); \
          exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);

/* -include_macros_end */

#endif
