 /*
  * Khoros: $Id: dmusic.c,v 1.2 1992/03/20 23:14:48 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dmusic.c,v 1.2 1992/03/20 23:14:48 dkhoros Exp $";
#endif

 /*
  * $Log: dmusic.c,v $
 * Revision 1.2  1992/03/20  23:14:48  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dmusic.c
 >>>>
 >>>>      Program Name: dmusic
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D MUSIC Spectral Estimation
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Ramiro Jordan, Glen Abousleman
 >>>>
 >>>> Date Last Updated: Fri Mar  6 09:13:58 1992
 >>>>
 >>>>          Routines: main- the main program for dmusic
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dmusic.h"


/****************************************************************
 *
 * Routine Name:  main program for dmusic
 *
 *       Input:  
 *        -i  input file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-s] model order (same as number of eigenvectors)  (value > 0)
 *        [-f] specify number of spectral values desired  (value > 0)
 *        [-p] do not center the psd estimate (0) or center the psd estimate (1)
 *        [-j] scalar processing (0) or vector processing (1)
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-g] type of autocorrelation file to be used
 *		0 (choose biased autocorrelation estimate),
 *		1 (choose unbiased autocorrelation estimate),
 *		or 2 (choose FFT based autocorrelation estimate)
 *		   [default = 0] 
 *
 *        [-c  Use AIC (0) or MDL(1) criterion   -OR-
 *         -k  dimension of noise subspace sequence    (value >= 0)) ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int     order, freq, kdim, auto_type, arith_type, psd_type, proc_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image);
CHECKTYPE(program,image);
CHECKTYPE(program,image);

arith_type = dmusic->j_logic;
psd_type = dmusic->p_logic;
auto_type = dmusic->g_toggle;

if(dmusic->k_flag==1){
   kdim = dmusic->k_int;
}else if(dmusic->c_flag==1){
   if(dmusic->c_logic==0){
      kdim = AIC_CRIT;
   }else{
      kdim = MDL_CRIT;
   }
}
      
freq = dmusic->f_int;
order = dmusic->s_int; 
proc_dir = dmusic->d_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
if(!ldmusic(image,order,freq,kdim,auto_type,arith_type,psd_type,proc_dir))
        {
            (void) fprintf(stderr, "%s: ldmusic failed\n",program);
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dmusic->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dmusic 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dmusic :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D MUSIC Spectral Estimation\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"\nwhere \"g\" type of autocorrelation to be used:\n");
(void) fprintf(stderr,"\t\"g=0\" biased estimate\n");
(void) fprintf(stderr,"\t\"g=1\" unbiased estimate\n");
(void) fprintf(stderr,"\t\"g=2\" FFT based estimate\n\n");
(void) fprintf(stderr,"where \"j\" type of arithmetic to be used:\n");
(void) fprintf(stderr,"\t\"j=0\" scalar arithmetic \n");
(void) fprintf(stderr,"\t\"j=1\" vector arithmetic \n\n");
(void) fprintf(stderr,"where \"d\" direction of processing:\n");
(void) fprintf(stderr,"\t\"d=0\" down vectors \n");
(void) fprintf(stderr,"\t\"d=1\" across bands \n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  model order (same as number of eigenvectors) (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-f]  specify number of spectral values desired (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-p]  do not center the psd estimate (0) or center the psd estimate (1) (boolean) [false]\n");
	fprintf(stderr,"\t[-j]  scalar processing (0) or vector processing (1) (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-g]  type of autocorrelation file to be used\n");
	fprintf(stderr, "\t\t0  (choose biased autocorrelation estimate),\n");
	fprintf(stderr, "\t\t1  (choose unbiased autocorrelation estimate),\n");
	fprintf(stderr, "\t\tor 2  (choose FFT based autocorrelation estimate)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-c  Use AIC (0) or MDL(1) criterion  (boolean) -OR- \n");
	fprintf(stderr,"\t  -k  dimension of noise subspace sequence  (integer, >= 0) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dmusic\n");
	fprintf(stderr, "\t[-U] Gives the usage for dmusic\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dmusic.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dmusic.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dmusic
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) model order (same as number of eigenvectors) \n        {integer, > 0 [1] }: "; 
char	*f_pstr = 
	"\nEnter: (f) specify number of spectral values desired \n        {integer, > 0 [1] }: "; 
char	*p_pstr = 
	"\nEnter: (p) do not center the psd estimate (0) or center the psd estimate (1) \n        {boolean, (y/n)  [no] }: "; 
char	*j_pstr = 
	"\nEnter: (j) scalar processing (0) or vector processing (1) \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*g_pstr = "\nEnter: (g) type of autocorrelation file to be used -- \n      \t\t0 (choose biased autocorrelation estimate)\n\t\t1 (choose unbiased autocorrelation estimate)\n\t\tor 2 (choose FFT based autocorrelation estimate)\n  [0]:  "; 
char	*c_pstr = 
	"\nEnter: (c) Use AIC (0) or MDL(1) criterion \n        {boolean, (y/n)  [no] }: "; 
char	*k_pstr = 
	"\nEnter: (k) dimension of noise subspace sequence \n        {integer, >= 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dmusic", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dmusic.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dmusic: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dmusic.ans");
		}

	     }

	}

	/*
	 * allocate the dmusic structure
	 */
	dmusic = (dmusic_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dmusic_struct));

	/*
	 * get required arguments for dmusic
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dmusic->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dmusic->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmusic->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dmusic->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dmusic->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dmusic->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dmusic->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dmusic->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dmusic->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dmusic->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dmusic
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dmusic->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dmusic->s_int),
	1, 2, 2);

	dmusic->f_flag = vget_int(fid, prompt_flag,
	"-f", f_pstr, &(dmusic->f_int),
	1, 2, 2);

	dmusic->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(dmusic->p_logic), 0);

	dmusic->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dmusic->j_logic), 1);

	dmusic->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dmusic->d_logic), 1);


	/*
	 * get optional toggles for dmusic
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dmusic->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dmusic->g_toggle),
		0, 0, 0);

		if ((dmusic->g_toggle == 0 ) || 
		    (dmusic->g_toggle == 1 ) || 
		    (dmusic->g_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dmusic->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dmusic->g_toggle),
		0, 0, 0);

		if ((dmusic->g_toggle != 0 ) && 
		    (dmusic->g_toggle != 1 ) && 
		    (dmusic->g_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional mutually exclusive groups for dmusic
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		dmusic->c_flag = vget_logic(fid, prompt_flag,
		    "-c", c_pstr, &(dmusic->c_logic), 0);

    		if(!( (dmusic->c_flag)))
		    dmusic->k_flag = vget_int(fid, prompt_flag,
		    "-k", k_pstr, &(dmusic->k_int),
		    1, 1, 1);

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(dmusic->c_flag = vget_logic(fid, prompt_flag,
		    "-c", c_pstr, &(dmusic->c_logic), 0))
		    count++;

		if(dmusic->k_flag = vget_int(fid, prompt_flag,
		    "-k", k_pstr, &(dmusic->k_int),
		    1, 1, 1))
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -c  -k \n");
		    gw_usage();
		    exit(1);
		}

	}


}



