 /*
  * Khoros: $Id: dem2viff.c,v 1.1 1991/05/10 15:52:38 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dem2viff.c,v 1.1 1991/05/10 15:52:38 khoros Exp $";
#endif

 /*
  * $Log: dem2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:38  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dem2viff.c
 >>>>
 >>>>      Program Name: dem2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert DEM format data to VIFF format.
 >>>>	
 >>>>	
 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Tue Apr  9 12:30:32 1991
 >>>>
 >>>>          Routines: main- the main program for dem2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dem2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for dem2viff
 *
 *       Input:  
 *          -i  Input DEM File 
 *          -o  Output VIFF File 
 *
 *
 *          [-s] subsampling factor  (value > 0)
 *          [-l] Location Options
 *		0 (No Location Data),
 *		or 1 (Explicit Location Data)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *xv_img;
struct demimage *dem_img, *readdem();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    
    dem_img = readdem(dem2viff->i_file);
    if (dem_img == NULL) {
        fprintf (stderr,"error in dem2viff: could not read DEM file: %s\n",
                 dem2viff->i_file);
        exit (0);
    }
/* -main_before_lib_call_end */

/* -main_library_call */
    if (!ldem2viff (&xv_img, dem_img, dem2viff->l_toggle, dem2viff->s_int)) {
        fprintf(stderr, "error in dem2viff: call to dem2viff failed\n");
        exit(0);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    if (!writeimage(dem2viff->o_file, xv_img)) {
        fprintf (stderr, "error in dem2viff: could not write elevation image ");
        fprintf (stderr, "to: %s\n", dem2viff->o_file);
        exit (1);
    }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dem2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dem2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert DEM format data to VIFF format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  Input DEM File  (infile)\n");
	fprintf(stderr,"\t-o  Output VIFF File  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  subsampling factor (integer, > 0) [1]\n");
	fprintf(stderr, "\t[-l]  Location Options\n");
	fprintf(stderr, "\t\t0  (No Location Data),\n");
	fprintf(stderr, "\t\tor 1  (Explicit Location Data)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dem2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for dem2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dem2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dem2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dem2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Input DEM File \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) Output VIFF File \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) subsampling factor \n        {integer, > 0 [1] }: "; 
char	*l_pstr = "\nEnter: (l) Location Options -- \n      \t\t0 (No Location Data)\n\t\tor 1 (Explicit Location Data)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dem2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dem2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dem2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dem2viff.ans");
		}

	     }

	}

	/*
	 * allocate the dem2viff structure
	 */
	dem2viff = (dem2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dem2viff_struct));

	/*
	 * get required arguments for dem2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dem2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dem2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dem2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dem2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dem2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dem2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dem2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dem2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dem2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dem2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dem2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dem2viff->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dem2viff->s_int),
	1, 2, 2);


	/*
	 * get optional toggles for dem2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dem2viff->l_flag = vget_int(fid, prompt_flag,
		"-l", l_pstr, &(dem2viff->l_toggle),
		0, 0, 0);

		if ((dem2viff->l_toggle == 0 ) || 
		    (dem2viff->l_toggle == 1 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dem2viff->l_flag = vget_int(fid, prompt_flag,
		"-l", l_pstr, &(dem2viff->l_toggle),
		0, 0, 0);

		if ((dem2viff->l_toggle != 0 ) && 
		    (dem2viff->l_toggle != 1 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



