 /*
  * Khoros: $Id: tiff2viff.c,v 1.1 1991/05/10 15:53:04 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: tiff2viff.c,v 1.1 1991/05/10 15:53:04 khoros Exp $";
#endif

 /*
  * $Log: tiff2viff.c,v $
 * Revision 1.1  1991/05/10  15:53:04  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: tiff2viff.c
 >>>>
 >>>>      Program Name: tiff2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a TIFF image to a Khoros VIFF image
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Sun Mar 10 21:09:23 1991
 >>>>
 >>>>          Routines: main- the main program for tiff2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "tiff2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for tiff2viff
 *
 *       Input:  
 *           -i  input TIFF image 
 *           -o  resulting VIFF image 
 *
 *
 *           [-v] verbose mode
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

        TIFF *tif;
        struct xvimage *viff;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        tif = TIFFOpen(tiff2viff->i_file, "r");
        if (tif == NULL)
        {
          fprintf(stderr,"%s: unable to read the TIFF image '%s'\n",
                program, tiff2viff->i_file);
          exit(1);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (! ltiff2viff(tif, &viff, tiff2viff->v_logic, tiff2viff->i_file))
        {
           fprintf(stderr, "%s: ltiff2viff failed\n", program);
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(tiff2viff->o_file, viff);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for tiff2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "tiff2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a TIFF image to a Khoros VIFF image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input TIFF image  (infile)\n");
	fprintf(stderr,"\t-o  resulting VIFF image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-v]  verbose mode (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for tiff2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for tiff2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called tiff2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses tiff2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for tiff2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input TIFF image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting VIFF image \n        {outfile}: "; 
char	*v_pstr = 
	"\nEnter: (v) verbose mode \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "tiff2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "tiff2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "tiff2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "tiff2viff.ans");
		}

	     }

	}

	/*
	 * allocate the tiff2viff structure
	 */
	tiff2viff = (tiff2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (tiff2viff_struct));

	/*
	 * get required arguments for tiff2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(tiff2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(tiff2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(tiff2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    tiff2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(tiff2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(tiff2viff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(tiff2viff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(tiff2viff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    tiff2viff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(tiff2viff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for tiff2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	tiff2viff->v_flag = vget_logic(fid, prompt_flag,
	"-v", v_pstr, &(tiff2viff->v_logic), 0);


}



