 /*
  * Khoros: $Id: mmult.c,v 1.2 1992/03/20 23:44:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mmult.c,v 1.2 1992/03/20 23:44:57 dkhoros Exp $";
#endif

 /*
  * $Log: mmult.c,v $
 * Revision 1.2  1992/03/20  23:44:57  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mmult.c
 >>>>
 >>>>      Program Name: mmult
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	mmult - Multiplies two matricies
 >>>>	
 >>>>	

 >>>>            Author: Matthew Lawrence, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:53:07 1992
 >>>>
 >>>>          Routines: main- the main program for mmult
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "mmult.h"


/****************************************************************
 *
 * Routine Name:  main program for mmult
 *
 *       Input:  
 *       -i1  first input matrix 
 *       -i2  second input matrix 
 *       -o  resulting output matrix 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *image1,*image2,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image1 = readimage(mmult->i1_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image1,1,TRUE);

  if((image2 = readimage(mmult->i2_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image2,1,TRUE);

  (void)match_num_bands(program,image1,image2,TRUE);
/* -main_before_lib_call_end */

/* -main_library_call */
   if(!lmmult(image1,image2))
      {
      (void)fprintf(stderr,"%s, failed call to lmult\n",program);
      exit(1);
      }
/* -main_library_call_end */

/* -main_after_lib_call */
     if(!(writeimage(mmult->o_file,image1))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for mmult 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "mmult :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tmmult - Multiplies two matricies\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  first input matrix  (infile)\n");
	fprintf(stderr,"\t-i2  second input matrix  (infile)\n");
	fprintf(stderr,"\t-o  resulting output matrix  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for mmult\n");
	fprintf(stderr, "\t[-U] Gives the usage for mmult\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called mmult.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses mmult.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for mmult
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) first input matrix \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) second input matrix \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output matrix \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "mmult", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "mmult.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "mmult: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "mmult.ans");
		}

	     }

	}

	/*
	 * allocate the mmult structure
	 */
	mmult = (mmult_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (mmult_struct));

	/*
	 * get required arguments for mmult
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(mmult->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(mmult->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mmult->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    mmult->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(mmult->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mmult->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(mmult->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mmult->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    mmult->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(mmult->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(mmult->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(mmult->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(mmult->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    mmult->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(mmult->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



