 /*
  * Khoros: $Id: vwarp.c,v 1.1 1991/05/10 15:52:18 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vwarp.c,v 1.1 1991/05/10 15:52:18 khoros Exp $";
#endif

 /*
  * $Log: vwarp.c,v $
 * Revision 1.1  1991/05/10  15:52:18  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwarp.c
 >>>>
 >>>>      Program Name: vwarp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform polynomial geometric transformation (warp)
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:21:14 1991
 >>>>
 >>>>          Routines: main- the main program for vwarp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vwarp.h"


/****************************************************************
 *
 * Routine Name:  main program for vwarp
 *
 *       Input:  
 *       -i1  input image 
 *       -i2  X polynomial coefficients image 
 *       -i3  Y polynomial coefficients image 
 *       -o  output image 
 *
 *
 *       [-x] x coordinate of center-of-action 
 *       [-y] y coordinate of center-of-action 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*xcoeffs,*ycoeffs,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vwarp->i1_file);
        if (image == NULL) exit(1);                 /* Quit if bad image */
        xcoeffs = readimage(vwarp->i2_file);
        if (xcoeffs == NULL) exit(1);               /* Quit if bad image */
        ycoeffs = readimage(vwarp->i3_file);
        if (ycoeffs == NULL) exit(1);               /* Quit if bad image */

        CHECKINPUT(program,image,xcoeffs,ycoeffs); /* Verify input images */
/* -main_before_lib_call_end */

/* -main_library_call */
            if(!lvwarp(image,xcoeffs,ycoeffs,vwarp->x_float,vwarp->y_float))
              {
                (void) fprintf(stderr, "lvwarp Failed\n");
                exit(1);
              }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vwarp->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vwarp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vwarp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform polynomial geometric transformation (warp)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  X polynomial coefficients image  (infile)\n");
	fprintf(stderr,"\t-i3  Y polynomial coefficients image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  x coordinate of center-of-action (float) [0]\n");
	fprintf(stderr,"\t[-y]  y coordinate of center-of-action (float) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vwarp\n");
	fprintf(stderr, "\t[-U] Gives the usage for vwarp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vwarp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vwarp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vwarp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) X polynomial coefficients image \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) Y polynomial coefficients image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x coordinate of center-of-action \n        {float [0.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y coordinate of center-of-action \n        {float [0.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vwarp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vwarp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vwarp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vwarp.ans");
		}

	     }

	}

	/*
	 * allocate the vwarp structure
	 */
	vwarp = (vwarp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vwarp_struct));

	/*
	 * get required arguments for vwarp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vwarp->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vwarp->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwarp->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vwarp->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vwarp->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwarp->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vwarp->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwarp->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vwarp->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vwarp->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwarp->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(vwarp->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwarp->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    vwarp->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(vwarp->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vwarp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vwarp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vwarp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vwarp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vwarp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vwarp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vwarp->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vwarp->x_float),
	0.000000, 0.000000, 0.000000);

	vwarp->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vwarp->y_float),
	0.000000, 0.000000, 0.000000);


}



