 /*
  * Khoros: $Id: imkmf.h,v 1.3 1992/03/20 22:36:30 dkhoros Exp $
  */

 /*
  * $Log: imkmf.h,v $
 * Revision 1.3  1992/03/20  22:36:30  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: imkmf.h
 >>>>            Author: Tait Cyrus 
 >>>> Date Last Updated: Wed Sep 25 22:10:55 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _imkmf_h_
#define _imkmf_h_

#include "vinclude.h"


/* -include_includes */
#include "vsignal.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    imkmf Argument Structure
*
****************************************************************/

typedef struct _imkmf  {

/*
 *  name of object (Optional string)
 */
char	*name_string;	/* name of object STRING */
int	 name_flag;   	/* name of object FLAG */

/*
 *  Toolbox name (Optional string)
 */
char	*toolbox_string;	/* Toolbox name STRING */
int	 toolbox_flag;   	/* Toolbox name FLAG */

/*
 *  Imakefile to be output (Optional outfile)
 */
char	*o_file;	/* Imakefile to be output FILENAME */
int	 o_flag;	/* Imakefile to be output FLAG */

/*
 * Imakefile type (Optional string toggle - )
 */
char	*type_toggle;		/* Imakefile type STRING TOGGLE */
int	 type_flag;		/* Imakefile type FLAG */

}  imkmf_struct;

imkmf_struct *imkmf;

/* -include_additions */

#define Myerror( string ) fprintf( stderr, "%s: Error; %s\n", program, string )
#define MAGIC   0x89

#define MAXLINE (1024*16)
#define IMAKEFILE       "Imakefile"
#define IMAKEFILE_BAK   "Imakefile.bak"
#define TOOLBOX         "Toolbox"

#define TEMPLATES               "repos/config/imake_tmpls"
#define LIBRARY_TEMPLATE        "Imakefile.l"
#define DIRECTORY_TEMPLATE      "Imakefile.d"
#define PROGRAM_TEMPLATE        "Imakefile.p"
#define FOR_PROGRAM_TEMPLATE    "Imakefile.pf"
#define XPROGRAM_TEMPLATE       "Imakefile.x"
#define FOR_XPROGRAM_TEMPLATE   "Imakefile.xf"
#define SCRIPT_TEMPLATE         "Imakefile.s"

#define DIRS    "SUBDIRS"
#define SRCS    "SRCS"
#define OBJS    "OBJS"
#define FSRCS   "FSRCS"
#define FOBJS   "FOBJS"
#define HEADER  "HEADERS"
#define LIBS    "LIBRARY"
#define YSRCS   "YSRCS"
#define LSRCS   "LSRCS"
#define LINT    "LINTLIBS"
#define SCRIPT  "SCRIPTS"
#define SPECIAL ""
#define SPECIALLOC 3
#define TBALLOC 4

#define YES     1
#define NO      0

struct files {
   char         *name;
   struct files *next;
   } *filesalloc();

struct stuff {
   char         *suffix;        /* Type of file.                        */
   char         *category;      /* What category file falls in          */
   int          count;          /* Count of the number of 'type' seen.  */
   struct files *files;         /* Linked list of files to deal with.   */
   int          (*function)();  /* Function to add name to list.        */
   };

/* functions */

vsignal hardfinish();
char *myalloc();
int get_line();
int get_token();
FILE *myfopen();
int need_replace();
char *getenv();

/* global variables */

FILE *infile;
FILE *outfile;
int moved;               /* If IMAKEFILE  moved to IMAKEFILE_TMP */
struct stuff map[15];
char *khoros_home;

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
