#! /bin/csh -f

# 
#  Khoros: $Id: krmprog_csh.csh,v 1.3 1991/12/18 08:54:10 dkhoros Exp $
#

#
# $Log: krmprog_csh.csh,v $
# Revision 1.3  1991/12/18  08:54:10  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	file name: krmprog_csh                                <<<<
#  >>>>                                                       <<<<
#  >>>> description: utility for removing routines from the
#  >>>>              Khoros environment.
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

#
# ROUTINE NAME:	krmprog_csh
# 
# AUTHORS:	Charlie Gage, Tom Sauer
# 
# DATE:		3/19/91
# 
# DESCRIPTION:	used to remove programs from the Khoros environment 
# 
# MODIFICATIONS: Added toolbox and single source support
#		 Tom Sauer -  Mon Sep 23 16:00:03 MDT 1991
#
#		

set noclobber
onintr cleanup
umask 002


#  Input Argument Checking
#------------------------------------------------------------
if ($#argv != 14) then
  echo ""
  echo "Invalid number of arguments detected."
  echo "Please invoke this script from the driver routine." 
  echo ""
  exit 0
endif

# Get the arguments from the driver program
#------------------------------------------------------------
set PROGRAM = $1
set PROGPATH = $2
set CPATH = $3
set HPATH = $4
set LPATH = $5
set LIBHPATH = $6
set MAN1PATH = $7
set MAN3PATH = $8 
set PANEPATH = $9
set HELPPATH = $10
set SUBHELPPATH = $11
set MACH = $12
set TOPSRC = $13
set TOOLBOX = $14

# Summary of variables used in this script:
#------------------------------------------------------------
# Program requires the use of a reserved keyword - "_NULL_"
#  to represent any NULL or empty arguments passed in.
#
# Input Variables to krmprog
#  PROGRAM    -  specifies the name of the program to install
#  PROGPATH   -  specifies the path to the src subdirectory
#  CPATH      -  specifies the path to the C driver file
#  HPATH      -  specifies the path to the include file
#  LPATH      -  specifies the path for the library file (optional)
#  LIBHPATH   -  specifies the path to the library include file (optional)
#  MAN1PATH   -  specifies the path for the man1 file
#  MAN3PATH   -  specifies the path for the man3 file (optional)
#  PANEPATH   -  specifies the path for the .pane file
#  HELPPATH   -  specifies the path to the cantata online manpages
#  SUBHELPPATH -  specifies the path to the Overview.doc file
#  MACH       -  specifies the path to the mach file
#  TOPSRC     -  specifies the top of src as indicated in the *.conf file
#  TOOLBOX     -  specifies the name of the Toolbox
#
# Variables used in the script:
#  KHOROS_HOME - environment variable
#  KHOROS_MAIL - users mail environment variable
#
# Optional variables will have "_NULL_" passed in to them if no
#  path is specified.

set TEMPDIR = /tmp

# Set up environment variables
#----------------------------------------------------
if (! $?KHOROS_HOME) then
   echo ""
   echo "krmprog: Error, need KHOROS_HOME "
   echo "          environment variable set to proceed."
   echo ""
   exit 0
endif

if (! $?KHOROS_MAIL ) then
   echo ""
   echo "krmprog: Error KHOROS_MAIL environment variable is not set"
   echo "Please use 'setenv KHOROS_MAIL username' to set the"
   echo "KHOROS_MAIL environment variable."
   echo ""
   exit 0
endif

if (! $?KHOROS_TOOLBOX ) then
   set KHOROS_TOOLBOX = $KHOROS_HOME/repos/Toolboxes
endif

# Set the PATH for the user
set path = ( . $KHOROS_HOME/bin $path /usr/local/bin /usr/ucb \
             /usr/bin /bin /usr/local/etc/ /usr/etc /etc )

# Get the path to the top of the Toolbox or set the TOOLBOX_TOP 
# to KHOROS_HOME if a toolbox was not specified.
#---------------------------------------------------------------
if ($TOOLBOX == "_NULL_") then
   set USE_TOOLBOX = 0
   set TOOLBOX_TOP = $KHOROS_HOME
else
   set USE_TOOLBOX = 1
   set TOOLBOX_TOP = `grep -i $TOOLBOX $KHOROS_TOOLBOX | awk -F: '{ printf "%s", $2 }' `
endif

set FULLHOST = `hostname`

#  Get the proper mach file
#---------------------------------------------------------------
if ($MACH == "_NULL_") then
    if (-f $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}) then
       set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach.{$FULLHOST}
    else if (-f $KHOROS_HOME/repos/config/src_conf/default_mach) then
	set MACH = $KHOROS_HOME/repos/config/src_conf/default_mach
    else
        echo ""
        echo "kinstall: The mach_def file does not exist"
        echo " Please either specify a mach_def file or create one"
        echo " in $KHOROS_HOME/repos/config/src_conf/default_mach"
        echo " For more information please Khoros Manual Vol 1, Ch. 9"
        echo ""
        exit 1
    endif
else if (-f $MACH.{$FULLHOST} ) then
        set MACH = $MACH.{$FULLHOST}
    else if (! -f $MACH ) then
           echo ""
           echo "krmprog: Error, the mach file:"
	   echo "$MACH"
	   echo "for the toolbox specified was not found."
	   echo "Please create a mach file"
           echo "in $MACH:h"
           echo ""
           exit 1
    endif
endif

# source the mach file determined in the chaos above
source $MACH

# Determine the relative path to src from the TOPSRC parameter
#  from the *.conf file.  Also check read/write permissions.
#--------------------------------------------------------------
@ count = 1
set iflag = 0

foreach i ( $PROGPATH $CPATH $HPATH $LPATH )
  if ($TOPSRC == "_NULL_") then
     if (-e $LOCAL_SRC_TOP/$i) then
        if (! -r $LOCAL_SRC_TOP/$i || ! -w $LOCAL_SRC_TOP/$i) then
	  echo "Cannot access $LOCAL_SRC_TOP/$i for reading/writing! Exiting..."
	  goto finishup
	endif
        set iflag = 1
     else
        # Try to get a relative path.
        #  This only works if i has the initial part of the path
        #  in common with LOCAL_SRC_TOP
        set RELPATH = `echo $i | sed -e "s|$LOCAL_SRC_TOP/||"`
        if (-e $LOCAL_SRC_TOP/$RELPATH) then
           if (! -r $LOCAL_SRC_TOP/$RELPATH || ! -w $LOCAL_SRC_TOP/$RELPATH) then
	       echo "Cannot access $LOCAL_SRC_TOP/$RELPATH for reading/writing! Exiting..."
	       goto finishup
           endif
           if ($count == 1) then
              set REL_PROGPATH = $RELPATH
           endif
        else
           echo ""
           echo "Invalid path detected in config file."
           echo "The following path was constructed from the LOCAL_SRC_TOP"
           echo " parameter and the relative path between topsrc and the src"
           echo " paths specified in the config file."
           echo " Path:  $LOCAL_SRC_TOP/$RELPATH "
           echo ""
           echo "A complete, valid path must be supplied."
           echo " An example of a configuration file can be found in,"
           echo " $KHOROS_HOME/repos/config/src_conf/TEMPLATE.conf"
           echo ""
           echo "Please check config file."
           echo ""
           goto finishup
        endif
     endif
 else
     if ( -e $LOCAL_SRC_TOP/$i ) then
        if (! -r $LOCAL_SRC_TOP/$i || ! -w $LOCAL_SRC_TOP/$i) then
          echo "Cannot access $LOCAL_SRC_TOP/$i for reading/writing! Exiting..."
          goto finishup
	endif
        set iflag = 1
     else
        if (! -d $TOPSRC) then
           echo ""
           echo "Invalid or incomplete path specified for"
           echo " topsrc parameter in config file."
           echo " Path: $TOPSRC"
           echo ""
           goto finishup
        endif
        if ($i == $TOPSRC) then
           set RELPATH = ""
        else
           set RELPATH = `echo $i | sed -e "s|$TOPSRC/||"`
        endif
        if (-e $LOCAL_SRC_TOP/$RELPATH) then
          if (! -r $LOCAL_SRC_TOP/$RELPATH || ! -w $LOCAL_SRC_TOP/$RELPATH) then
	      echo "Cannot access $LOCAL_SRC_TOP/$RELPATH for reading/writing! Exiting..."
	      goto finishup
	  endif
          if ($count == 1) then
             set REL_PROGPATH = $RELPATH
          endif
        else
          echo ""
          echo "Invalid path detected in config file."
          echo "The following path was constructed from the LOCAL_SRC_TOP"
          echo " parameter and the relative path between topsrc and the src"
          echo " paths specified in the config file."
          echo " Path:  $LOCAL_SRC_TOP/$RELPATH"
          echo ""
          echo "A complete, valid path must be supplied."
          echo " An example of a configuration file can be found in,"
          echo " $KHOROS_HOME/repos/config/src_conf/TEMPLATE.conf"
          echo ""
          echo "Please check config file."
          echo ""
          goto finishup
        endif
     endif
  endif
@ count++
end

if ($iflag) then
   set PROGPATH = $LOCAL_SRC_TOP/$PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$LPATH
else
   set PROGPATH = $LOCAL_SRC_TOP/$REL_PROGPATH
   set LPATH = $LOCAL_SRC_TOP/$RELPATH
endif

set CATEGORY = $PROGPATH:h

# check parameters in config file, and make sure they 
#  are valid paths and are writable directories.
#--------------------------------------------------------------
  foreach i ( $PROGPATH $MAN1PATH $MAN3PATH $PANEPATH $HELPPATH $SUBHELPPATH )
     if (-e $i && -d $i ) then
        if (! -r $i || ! -w $i) then
           echo "Cannot access $i for reading/writing! Exiting..."
           goto finishup
        endif
     endif
  end


# Print out the paths where the source will be placed and ask user to
# continue with the install
#    

   if (! -e $LPATH) then
      echo "krmprog:"
      echo -n "krmprog: ERROR; krmprog cannot access"
      echo " the directory: $LPATH"
      echo ""
      goto finishup
   endif

   if (! -e $PROGPATH) then
      echo "krmprog:"
      echo -n "krmprog: ERROR; krmprog cannot access"
      echo " the directory: $PROGPATH"
      echo ""
      echo "You must have specified somthing wrong on the command line or"
      echo " the directory $PROGPATH does not exist"
      echo ""
      goto finishup
   endif

    echo ""
    echo -n  "You are about to remove a program from Khoros."
    echo ""
    echo "You will be prompted to remove the files."
    echo ""
    echo "Library source location: $LPATH"
    echo "Driver source location : $PROGPATH"
    echo ""
    echo -n "krmprog: Do you wish to continue (y/n)? "
    set continue_flg = $<
    echo ""

    if ($continue_flg != 'y') goto finishup


# Check to see if anyone else is installing
#----------------------------------------------
    if ( -e  $TEMPDIR/.krmprog.lock ) then
       echo ""
       echo ""
       echo "krmprog: Someone else is removing a routine right now."
       echo "          Please try again in a few minutes"
       echo ""
       echo "          We can not allow more than one person to remove"
       echo "          program at the same time because of possible conflicts..."
       echo ""
       goto finishup
    else
       touch $KHOROS_HOME/.krmprog.lock
    endif

# Check to see that KHOROS_USER was sourced from mach file
#-----------------------------------------------------
if ($KHOROS_USER == "") then
   echo ""
   echo "krmprog: KHOROS_USER environment variable not set."
   echo " Please check your mach file for this variable."
   echo ""
   goto cleanup
endif

#  Read the default_mach file and get appropriate info
#-------------------------------------------------

set NUM_MACHINES = $#KHOROS_MACHINES
set NUM_DIR = $#KHOROS_MACH_DIR
set NUM_SRC = $#KHOROS_SRC_TOP

if ( $NUM_DIR < 1) then
  set SINGLE_SRC = 1
else
  set SINGLE_SRC = 0
  if ( ($NUM_MACHINES != $NUM_DIR) && ($NUM_MACHINES != $NUM_SRC) || $NUM_DIR < 1) then
     echo ""
     echo "krmprog: Error, incorrect number of entries in the mach file:"
     echo "$MACH."
     echo " Please check that the number of entries in the fields:"
     echo " KHOROS_MACHINES, KHOROS_MACH_DIR, and KHOROS_SRC_TOP"
     echo " are the same (ie. number of entires must correspond)."
     echo ""
     goto cleanup
  endif
endif

if (! -d $LOCAL_SRC_TOP) then
   echo ""
   echo "krmprog: Error, the LOCAL_SRC_TOP field is not set."
   echo "Please set this field in the file:"
   echo "$MACH"
   echo ""
   goto cleanup
endif

# Check to see if .rhosts file exists, if not then
# copy over the .rhosts.bk to .rhosts for the rsh to work
#-----------------------------------------------------
if (! $SINGLE_SRC) then
   if ( ! -e ~$KHOROS_USER/.rhosts && $NUM_MACHINES > 0) then
     if ( ! -e ~$KHOROS_USER/.rhosts.bk) then
        echo "Please set up a .rhost file in ~$KHOROS_USER"
        goto cleanup
     else
      echo ""
      echo "Copying ~$KHOROS_USER/.rhosts.bk to ~$KHOROS_USER/.rhosts"
      echo ""
      \cp ~$KHOROS_USER/.rhosts.bk ~$KHOROS_USER/.rhosts
    endif
   endif
endif


# remove library header file and copy into /tmp
#-----------------------------------------------------
if ($LIBHPATH != "_NULL_") then
    echo ""
    echo "Removing library header from $LIBHPATH
    echo ""
    echo -n "Do you want to remove the library header files? (y/n) [y]: "
    set continue_flg = $<
         if ($continue_flg == 'n') goto trynextfile
    echo ""
    echo ""

    pushd $LIBHPATH >& /dev/null
    if ( -e l$PROGRAM.h ) then
       echo "Removing library header l$PROGRAM.h"
       echo ""
       echo "move l$PROGRAM.h /tmp "
       \mv l$PROGRAM.h /tmp
    endif

    # remove links in srcmach directories
    if (! $SINGLE_SRC) then
        ksrcconf_csh $LIBHPATH $MACH                     # ksrcconf
    endif

    echo ""
    echo "Updating the Makefile in directory $LIBHPATH" | \
 	tee -a /tmp/krmprog.$$
    echo ""

    imkmf
    make Makefile

    if (! $SINGLE_SRC) then
      if ($USE_TOOLBOX) then
         kmakeall -toolbox $TOOLBOX Makefile                    # kmakeall
      else
         kmakeall Makefile
      endif
      echo "I must wait about one minute to allow the Makefiles to update"
      sleep 60
    endif

    popd >& /dev/null
endif

trynextfile:
# remove library source files and copy into /tmp
#----------------------------------------------------------------
    echo ""
    echo "Removing library source from $LPATH"
    echo ""
    echo -n "Do you want to remove the library source files? (y/n) [y]: "
    set continue_flg = $<
         if ($continue_flg == 'n') goto nextfile
    echo ""
    echo ""

    if ($LPATH != $LOCAL_SRC_TOP) then
       set RELPATH = `echo $LPATH | sed -e "s|$LOCAL_SRC_TOP/||"`
    else
       set RELPATH
    endif

    if (! -d $LOCAL_SRC_TOP/$RELPATH) then
       echo ""
       echo "krmprog:  The path "
       echo "  $LOCAL_SRC_TOP/$RELPATH"
       echo " is invalid.  Please ensure that the correct path for"
       echo " the library source is correct."
       echo ""
       goto cleanup
    endif

# Remove links for library srcmach directories
#---------------------------------------------


    if (! $SINGLE_SRC) then
      @ i = 1
      foreach machine ($KHOROS_MACHINES)
         set DESTDIR = $KHOROS_MACH_DIR[$i]/$RELPATH
         echo ""
         echo "krmprog: Removing links for $KHOROS_MACH_DIR[$i]"
         echo ""
         rsh $machine -l $KHOROS_USER \
             "umask 002; \
             touch /tmp/make.$$; \
             if (-d $DESTDIR) then \
                \rm -f $DESTDIR/l$PROGRAM.* >>& /tmp/make.$$; \
                echo "in $DESTDIR" >>& /tmp/make.$$; \
                echo "Removing l$PROGRAM.c on $machine" >>& /tmp/make.$$; \
             else \
                echo "$DESTDIR does not exist." >>& /tmp/make.$$; \
             endif \
             \rm -f /tmp/make.$$" &
         echo "done"
         @ i++
      end
    endif

    pushd $LPATH >& /dev/null

    foreach i ( l$PROGRAM.* )
      if (-e $i) then
         echo "Removing library source file: $i"
         echo ""
         \mv $i /tmp
      endif
    end

    echo ""
    echo "Updating the Makefile in directory $LPATH" | \
          tee -a /tmp/krmprog.$$
    echo ""

    imkmf
    make Makefile
    if (! $SINGLE_SRC) then
      if ($USE_TOOLBOX) then
         kmakeall -toolbox $TOOLBOX Makefile                    # kmakeall
      else
         kmakeall Makefile
      endif
      echo "I must wait about one minute to allow the Makefiles to update"
      sleep 60
    endif

    echo ""
    echo "The following files make a reference to the library routine"
    echo "that you just removed. Please check these references"
    echo ""
    grep l$PROGRAM $LPATH/*.c $LPATH/*.h $LPATH/*.f
    echo ""
    echo "You have removed the source from a Library."
    echo "The Library should be recompiled to reflect that the"
    echo "routine l$PROGRAM has been removed."
    echo -n "Do you want to recompile? (y/n) [y]: "
    set continue_flg = $<
         if ($continue_flg == 'n') goto nextfile


      echo ""
      echo "Recompiling the Library" | tee -a /tmp/krmprog.$$
      echo ""

    if (! $SINGLE_SRC) then
      echo ""
      echo "Calling kmakeall in directory $LPATH" | \
	   tee -a /tmp/krmprog.$$
      echo ""
      if ($USE_TOOLBOX) then
         kmakeall -toolbox $TOOLBOX install                    # kmakeall
      else
         kmakeall install
      endif
      echo "I must wait about one minute to allow the Library to build"
      sleep 60
    else
       make install
    endif

    popd >& /dev/null


nextfile:

# remove man pages from man1 and man3 directories
#------------------------------------------------------
    if (-e $MAN1PATH/$PROGRAM.1) then
       echo ""
       echo "Removing man(1) page from:"
       echo "   $MAN1PATH"
       echo ""
       \mv $MAN1PATH/$PROGRAM.1 /tmp
    endif
    if (-e $MAN3PATH/l$PROGRAM.3) then
       echo ""
       echo "Removing man(3) page from:"
       echo "   $MAN3PATH"
       echo ""
       \mv $MAN3PATH/l$PROGRAM.3 /tmp
    endif

# remove man pages from cat1 and cat3 if they exist
#-----------------------------------------------------
    pushd $MAN1PATH >& /dev/null
    cd ../cat1 >& /dev/null

    if (-e $PROGRAM.1 ) then
       /bin/rm -f $PROGRAM.1
    endif
    cd ../cat3 >& /dev/null
    if (-e l$PROGRAM.3 ) then
       /bin/rm -f l$PROGRAM.3
    endif
 
    popd >& /dev/null


# update the $MAN1PATH/../whatis file
#-----------------------------------------------------
    echo ""
    echo "Updating the $MAN1PATH/../whatis file" | \
          tee -a /tmp/krmprog.$$
    echo ""
      
    if ($USE_TOOLBOX) then
       vmanwhatis -toolbox $TOOLBOX        # for a Toolbox
    else
       vmanwhatis                          # for KHOROS_HOME
    endif

# remove cantata pane files
#-----------------------------------------------------
    if (-e $PANEPATH/$PROGRAM.pane) then
       echo ""
       echo "removing cantata pane from $PANEPATH"
       echo ""
       \mv $PANEPATH/$PROGRAM.pane /tmp
    endif


# edit the cantata.form file and remove the -p line
#-----------------------------------------------------
    echo ""
    echo "Update the cantata.form UI spec" | \
          tee -a /tmp/krmprog.$$
    echo ""
    echo " "
    echo "Remove the -p line for $PROGRAM in the subform file."
    echo "I will put you into your editor to edit the file,"
    echo "then I will update the UI specification"
    echo " "
    if ( $?EDITOR ) then
       echo -n "Return to enter $EDITOR...."
       set resp = $<
       pushd $PANEPATH >& /dev/null
       foreach file ( *.sub )
          $EDITOR $file
       end
       popd >& /dev/null
    else   
       echo -n "Return to enter vi...."
       set resp = $<
       pushd $PANEPATH >& /dev/null
       foreach file ( *.sub )
          vi $file
       end
       popd >& /dev/null
    endif


# edit the cantata doc Overview file and remove description
#-----------------------------------------------------------
    echo ""
    echo "Update the cantata subform Overview documentation file" | \
        tee -a /tmp/krmprog.$$
    echo ""
    echo " "
    echo "Remove the name of the program and the short description of the"
    echo "program in the Subform Overview help page for Cantata."
    echo ""
    echo "I will put you into your editor to edit the file,"
    echo "then I will update the UI specification"
    echo " "
    if ( $?EDITOR ) then
       echo -n "Return to enter $EDITOR...."
       set resp = $<
       pushd $SUBHELPPATH >& /dev/null
         $EDITOR Overview.doc
       formatdoc -type help -i Overview                  # formatdoc
       popd >& /dev/null
    else
       echo -n "Return to enter vi...."
       set resp = $<
       pushd $SUBHELPPATH >& /dev/null
         vi Overview.doc
       formatdoc -type help -i Overview                  # formatdoc
       popd >& /dev/null
    endif


# Remove the executable files from srcmach
#------------------------------------------------------
    echo ""
    echo "Remove the executable from bin"
    echo ""
    echo -n "Do you want to remove the executable, $PROGRAM? (y/n) [y]: "
    set continue_flg = $<
         if ($continue_flg == 'n') goto nodelete
    echo ""

    if (! $SINGLE_SRC) then
	if (-e $TOOLBOX_TOP/binmach) then
            pushd $TOOLBOX_TOP/binmach >& /dev/null
            foreach machdir (`\ls`)
               if (-e $TOOLBOX_TOP/binmach/$machdir/$PROGRAM ) then
                  /bin/rm -f $TOOLBOX_TOP/binmach/$machdir/$PROGRAM
               endif
            end
            popd >& /dev/null
        else
          if (-e $TOOLBOX_TOP/bin/$PROGRAM ) then
                \rm -f $TOOLBOX_TOP/bin/$PROGRAM
          endif
        endif
    else
         if (-e $TOOLBOX_TOP/bin/$PROGRAM ) then
              \rm -f $TOOLBOX_TOP/bin/$PROGRAM
          endif
    endif


nodelete:

# Remove the driver source files from src
#------------------------------------------------------
    echo ""
    echo "Remove the source files from src"
    echo ""
    echo -n "Do you want to remove the source files for $PROGRAM? (y/n) [y]: "
    set continue_flg = $<
         if ($continue_flg == 'n') goto nodeletesrc
    echo ""

    set FULLPATH = $PROGPATH

    if ($FULLPATH != $LOCAL_SRC_TOP) then
       set RELPATH = `echo $FULLPATH | sed -e "s|$LOCAL_SRC_TOP/||"`
    else
       set RELPATH
    endif


    if (! -d $LOCAL_SRC_TOP/$RELPATH) then
       echo ""
       echo "krmprog:  The path "
       echo "  $LOCAL_SRC_TOP/$RELPATH"
       echo " is invalid.  Please ensure that the correct path for"
       echo " the library source is correct."
       echo ""
       goto cleanup
    endif

# Remove all links in srcmach directories
#---------------------------------------------
    if (! $SINGLE_SRC) then
       @ i = 1
       foreach machine ($KHOROS_MACHINES)
          set DESTDIR = $KHOROS_MACH_DIR[$i]/$RELPATH
          echo ""
          echo "krmprog: Removing links and directory for $KHOROS_MACH_DIR[$i]"
          echo ""
          rsh $machine -l $KHOROS_USER \
              "umask 002; \
              touch /tmp/make.$$; \
              if (-d $DESTDIR) then \
                 \rm -rf $DESTDIR >>& /tmp/make.$$; \
                 echo "in $DESTDIR" >>& /tmp/make.$$; \
                 echo "Removing directory $PROGRAM on $machine" >>& /tmp/make.$$; \
              else \
                 echo "$DESTDIR does not exist." >>& /tmp/make.$$; \
              endif \
              \rm -f /tmp/make.$$" &
          echo "done"
          @ i++
       end
    endif
   
    pushd $CATEGORY >& /dev/null

    if (-d $PROGPATH) then
         \mv $PROGPATH/* /tmp
         \rm -rf $PROGPATH
    else
         echo ""
         echo "ERROR; $PROGPATH is NOT a valid directory"
         echo ""
         goto cleanup
    endif
	
# Do a ksrcconf in the directory above where the src was removed.
#----------------------------------------------------------------

    echo ""
    echo "Updating the Makefile in directory $CATEGORY" | \
	tee -a /tmp/krmprog.$$
    echo ""

    imkmf
    make Makefile

    if (! $SINGLE_SRC) then
        ksrcconf_csh $CATEGORY $MACH                     # ksrcconf
        echo "I must wait about one minute to allow the Makefiles to update"
        sleep 60
    endif


    popd >& /dev/null

nodeletesrc:

    echo ""
    echo ""
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo "Removal of $PROGRAM completed."
    echo ""
    echo "Please read mail to make sure that the"
    echo " directories were removed correctly."
    echo ""
    echo "<<<<<<<<<<<<<<<<<<<   >>>>>>>>>>>>>>>>>>>"
    echo ""
    echo ""

# mail to $KHOROS_HOME about new routine
#-----------------------------------------------------
    mail -s "krmprog $PROGRAM" $KHOROS_MAIL < /tmp/krmprog.$$

    \rm -f - /tmp/krmprog.$$


cleanup:
# cleanup by removing .kinstall.lock file and unsetting variables.
#------------------------------------------------------------------
    if ( -e $TEMPDIR/.krmprog.lock ) then
          /bin/rm -f $TEMPDIR/.krmprog.lock
    endif
    if (! $SINGLE_SRC) then
       if (-e ~$KHOROS_USER/.rhosts) then
          \mv ~$KHOROS_USER/.rhosts ~$KHOROS_USER/.rhosts.bk
       endif
    endif

finishup:
   unset KHOROS_USER
   unset KHOROS_MACHINES
   unset KHOROS_MACH_DIR
   unset KHOROS_SRC_TOP
   unset LOCAL_SRC_TOP

exit 0        # normal exit
