 /*
  * Khoros: $Id: lband2vect.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lband2vect.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lband2vect.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lband2vect.c
 >>>>
 >>>>      Program Name: band2vect
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:22:37 1991 
 >>>>
 >>>>          Routines: lband2vect - the library call for band2vect
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lband2vect - library call for band2vect
*
* Purpose:
*    
*    reformats data stored in image format to a  single-row  file
*    where each column represents a separate vector in the output
*    file.
*    
*    
* Input:
*    
*    *image         pointer to the input/output xvimage structure
*    
*    
* Output:
*    
*    *image         pointer to the input/output (struct xvimage)
*    
*    
*
* Written By: Charlie Gage
*    
*    
****************************************************************/


/* -library_def */
int 
lband2vect (image)
struct xvimage  *image;
/* -library_def_end */

/* -library_code */
{
  int
         i,              /* loop control variables */
         num_rows,       /* number of ROWS in output image */
         num_cols,       /* number of COLS in output image */
         num_bands,      /* number of BANDS in output image */
         subrows,        /* subrow size for output image */
         num_vects,      /* number of vectors returned by dload_vector */
         dimension,      /* dimension of each vector returned by dload_vector */
         border,         /* set border to 0, when calling unload_vector */
         process_dir;    /* 0 = IMG_VECTOR, 1 = IMG_BAND */

  char   **vectors;     /* vector array returned by dload_vector */

  char   **dload_vector(),
         *unload_vector();

  char *program = "lband2vect";


  border = 0;
  process_dir = 1;       /* set process_dir to IMG_BAND */

 /*-------------------------------------------------------------------*/
 /*  Check for valid data_storage_type                                */
 /*-------------------------------------------------------------------*/
  if (image->data_storage_type == VFF_TYP_BIT)
  {
    (void)fprintf(stderr,"lband2vect: Incorrect data storage type.\n");
    (void)fprintf(stderr,"Data can be any type except BIT.\n");
    return(0);
  }

 /*-------------------------------------------------------------------*/
 /* Input image can only have one image                               */
 /*-------------------------------------------------------------------*/
if (! (proper_num_images(program, image, 1, FALSE))) {
   (void) fprintf (stderr,"%s: ERROR All inputs must contain only one image\n", program);
   return(0);
 }

 /*-------------------------------------------------------------------*/
 /* Check for valid map_scheme and map_enable combinations            */
 /*-------------------------------------------------------------------*/
if ((image->num_data_bands > 1) && (image->map_scheme == VFF_MS_ONEPERBAND) && ((image->map_enable == VFF_MAP_OPTIONAL) || (image->map_enable == VFF_MAP_FORCE) ))
{
  fprintf(stderr,"%s: MUST remove map or map data through the map before using this routine.\n", program);
  return(0);
}

if ((image->map_scheme == VFF_MS_CYCLE) || (image->map_scheme == VFF_MS_GROUP))
{
  fprintf(stderr,"%s: will not work with map_scheme of MS_CYCLE or MS_GROUP\n", program);
  return(0);
}

 /*-------------------------------------------------------------------*/
 /* Determine size and geometry of resulting output image.            */
 /*   ---------------------------------------------------             */
 /*   number of rows:  MUST be ONE                                    */
 /*   number of cols:  each column represents a pixel, the number     */
 /*                     of columns is equal to the number of bands    */
 /*                     in the input image.                           */
 /*   number of bands: the number of bands is equal to the number of  */
 /*                     pixels in each band (num_rows * num_cols) of  */
 /*                     the input image.                              */
 /*   subrows: this is equal to the number of rows in the input image */
 /*-------------------------------------------------------------------*/
  num_rows = 1;
  num_cols = image->num_data_bands;
  num_bands = image->row_size * image->col_size;
  subrows = image->col_size;

 /*-------------------------------------------------------------------*/
 /*  Call dload_vector to get data into vector format.                */
 /*    This returns a 2-D array of data                               */
 /*-------------------------------------------------------------------*/
 if ( (vectors = (char **)dload_vector(image, &num_vects, &dimension, process_dir)) == NULL)
  {
    (void) fprintf(stderr,"lband2vect: dload_vector failed\n");
    return(0);
  }

 /*-------------------------------------------------------------------*/
 /* Call unload_vector to stack each vector as a pixel.               */
 /*   This stacks each row of the 2-D array as a pixel.               */
 /*-------------------------------------------------------------------*/
  free(image->imagedata);
  if ((image->imagedata = unload_vector((char **)vectors, border, image->data_storage_type, num_vects, dimension, num_rows, num_cols)) == NULL)
  {
    (void) fprintf(stderr,"lband2vect: unload_vector failed\n");
    return(0);
  }

 /*-------------------------------------------------------------------*/
 /* Adjust Header information in resulting output image.              */
 /*-------------------------------------------------------------------*/
  image->col_size = num_rows;                  /* num rows */
  image->row_size = num_cols;                  /* num cols */
  image->num_data_bands = num_bands;           /* num_data_bands */
  image->color_space_model = VFF_CM_NONE;
  if (image->map_scheme != VFF_MS_NONE)       /* Since it is now a multiband */
      image->map_scheme = VFF_MS_SHARED;      /*  image, MUST set map_scheme */ 
                                              /*  to SHARED */

 /* Set subrow size of resulting image */
  image->subrow_size = subrows;

 /*-------------------------------------------------------------------*/
 /* Release memory for "vector" array                                 */
 /*-------------------------------------------------------------------*/
  for (i = 0; i < num_vects; i++)
       free((char *) vectors[i]);

  free((char **) vectors);
  return(1);

}
/* -library_code_end */
