 /*
  * Khoros: $Id: lvsdef.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvsdef.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvsdef.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvsdef.c
 >>>>
 >>>>      Program Name: vsdef
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:29:57 1991 
 >>>>
 >>>>          Routines: lvsdef - the library call for vsdef
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvsdef - library call for vsdef
*
* Purpose:
*    
*    Second Derivative Operator for Symmetric Exponential Filter.
*    
*    
* Input:
*    
*    image          xvimage structure, must be of  data  storage  type
*                   Byte, single band without map.
*    
*    t1             defines the first Hysteresis Threshold.
*    
*    t2             defines the second Hysteresis Threshold.
*    
*    Length         defines the minimum number of pixels for a segment
*                   to be valided.
*    
*    a0             defines   the   Exponential   Filter   Coefficient
*                   (default value = 0.45)
*    
*    
* Output:
*    
*    image          Holds the result.
*    
*    
*
* Written By: Pascal ADAM
*    
*    Created by Pascal ADAM from source given by Pr  CASTAN  IRIT
*    TOULOUSE on Mon Jul  2 16:50:07 MDT 1990.
*    
*    
****************************************************************/


/* -library_def */
int 
lvsdef(image,a0,t1,t2,l)

struct xvimage *image;
int t1, t2, l;
float a0;
/* -library_def_end */

/* -library_code */
{
int mx,my,dim;
unsigned char *ima;
unsigned char *tt,*ti,*ti1,*dx,*ddx,*dy,*ddy;
float s3;
void expfilter(),gradadp(),threshold();

   ima = (unsigned char *) image -> imagedata;
   dim = (int)image -> col_size * (int)image -> row_size;
   mx  = (int)image -> row_size;
   my  = (int)image -> col_size; 
 
   a0=1-a0; 

   s3 = 1.3;  /* fixed value, determines the direction of the gradient */

   /* Dynamic alloc for *t1, *t2 and *t3.                  */
   dx  = (unsigned char*)malloc(dim*sizeof(unsigned char));
   ddx = (unsigned char*)malloc(dim*sizeof(unsigned char));
   dy  = (unsigned char*)malloc(dim*sizeof(unsigned char));
   ddy = (unsigned char*)malloc(dim*sizeof(unsigned char));
   tt  = (unsigned char*)malloc(dim*sizeof(unsigned char));

   if ((dx == NULL) || (ddx == NULL) || (dy == NULL) || (ddy == NULL) || (tt == NULL))
   {
      (void) fprintf(stderr,"lvsdef: insufficient memory available\n");
      return(0);
    }



   ti1=ima;
   for (ti=tt; ti<tt+dim; ti++) *ti= *ti1++; 

   /* calculate 1st derivative and zero-crossing of 2nd derivative         */
   /*  by the differential operators of the exponential filter.            */
   sdeff(tt,dx,dy,ddx,ddy,mx,my,dim,a0);

   /* delete the noise in the 2nd derivative image.                        */
   for (ti1 = ddx+mx; ti1 < ddx+dim-mx; ti1 += mx)
      for (ti = ti1; ti < ti1+mx; ti++)
         if ((*(ti-1) > 1) && (*(ti+1) > 1)) *ti= *(ti-1);


   for (ti1 = ddx+mx; ti1 < ddx+dim-mx; ti1 += mx)
      for (ti = ti1; ti < ti1+mx; ti++)
         if ((*(ti-1) < 2) && (*(ti+1) < 2)) *ti = *(ti-1);


   for (ti1 = ddy+mx; ti1 < ddy+dim-mx; ti1 += mx)
      for (ti=ti1; ti<ti1+mx; ti++)
         if ((*(ti-mx) > 1) && (*(ti+mx) > 1)) *ti = *(ti-mx);


   for (ti1 = ddy+mx; ti1 < ddy+dim-mx; ti1 += mx)
      for (ti = ti1; ti < ti1+mx; ti++)
         if ((*(ti-mx) < 2) && (*(ti+mx) < 2)) *ti = *(ti-mx);

   /* the edges detection by combination of zero-crossing of 2nd derivative*/
   /* and the sign correspondence between 1st and 2nd derivatives.         */
   sdefextr(dx,dy,ddx,ddy,tt,mx,my,s3);


   /* image segmentation by the hysteretic threshold.      */
   threshold(tt,dx,mx,my,dim,t1,t2,l);

   free(image -> imagedata);
   image -> imagedata = (char *)dx;

   free(tt);
   free(ddx);
   free(dy);
   free(ddy);

   return(1);
      }
/* -library_code_end */
