 /*
  * Khoros: $Id: vrmatch.c,v 1.2 1991/12/18 09:30:19 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vrmatch.c,v 1.2 1991/12/18 09:30:19 dkhoros Exp $";
#endif

 /*
  * $Log: vrmatch.c,v $
 * Revision 1.2  1991/12/18  09:30:19  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrmatch.c
 >>>>
 >>>>      Program Name: vrmatch
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Matching of regions in 2 images
 >>>>	
 >>>>	

 >>>>            Author: Pascal Adam
 >>>>
 >>>> Date Last Updated: Sat Dec 14 18:10:59 1991
 >>>>
 >>>>          Routines: main- the main program for vrmatch
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vrmatch.h"


/****************************************************************
 *
 * Routine Name:  main program for vrmatch
 *
 *       Input:  
 *         -i1  input image 
 *         -i2  Input image 
 *         -o  output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
   struct xvimage *image1, 
                  *image2, 
                  *image, 
                  *readimage();
   char *dummy = '\0';
 
   int nc1,nc2,
       nr1,nr2,
       i,j,
       *im, *im1, *im2;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);

   READINPUT(image1,image2) ;
   CHECKINPUT(program,image1,image2) ;

   nc1 = image1->row_size;
   nr1 = image1->col_size;

   nc2 = image2->row_size;
   nr2 = image2->col_size;

   if ( (nc1 != nc2) || (nr1 != nr2)) 
   {
      (void) fprintf(stderr,
             "vrmatch: image1 and image2 must have the same size!\n\n");
      exit(1);
   }

/* -main_before_lib_call_end */

/* -main_library_call */
   if (! lvrmatch(image1,
                  image2,
                  &image))
   {
        (void) fprintf(stderr, "lvrmatch Failed\n");
        exit(1);
   }

/* -main_library_call_end */

/* -main_after_lib_call */
   writeimage(vrmatch->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vrmatch 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vrmatch :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tMatching of regions in 2 images\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  Input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vrmatch\n");
	fprintf(stderr, "\t[-U] Gives the usage for vrmatch\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vrmatch.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vrmatch.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vrmatch
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vrmatch", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vrmatch.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vrmatch: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vrmatch.ans");
		}

	     }

	}

	/*
	 * allocate the vrmatch structure
	 */
	vrmatch = (vrmatch_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vrmatch_struct));

	/*
	 * get required arguments for vrmatch
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vrmatch->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vrmatch->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrmatch->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vrmatch->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vrmatch->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vrmatch->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vrmatch->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrmatch->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vrmatch->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vrmatch->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vrmatch->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vrmatch->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrmatch->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vrmatch->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vrmatch->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



