 /*
  * Khoros: $Id: vdiff.c,v 1.1 1991/05/10 15:48:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vdiff.c,v 1.1 1991/05/10 15:48:06 khoros Exp $";
#endif

 /*
  * $Log: vdiff.c,v $
 * Revision 1.1  1991/05/10  15:48:06  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdiff.c
 >>>>
 >>>>      Program Name: vdiff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Performs image differentiation by  running  2  NxN  weighted
 >>>>	operators on an image.
 >>>>	
 >>>>	
 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:28:46 1991
 >>>>
 >>>>          Routines: main- the main program for vdiff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vdiff.h"


/****************************************************************
 *
 * Routine Name:  main program for vdiff
 *
 *       Input:  
 *       -i1  input image filename 
 *       -i2  input kernel (operator) in X 
 *       -i3  input kernel (operator) in Y 
 *       -o  output image filename 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *kern1, *kern2, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vdiff->i1_file);
    if(image == NULL){
        (void) fprintf(stderr,"vdiff: Image could not be read\n");
        exit(1);
    }

    kern1 = readimage(vdiff->i2_file);
    if(kern1 == NULL){
        (void) fprintf(stderr,"vdiff: Kernel (operator) could not be read\n");
        exit(1);
    }

    kern2 = readimage(vdiff->i3_file);
    if(kern2 == NULL){
        (void) fprintf(stderr,"vdiff: Kernel (operator) could not be read\n");
        exit(1);
    }

    CHECKINPUT(program,image,kern1,kern2);      /* Verify input images */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvdiff(image,kern1,kern2))
    {
        (void) fprintf(stderr, "lvdiff Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vdiff->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vdiff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vdiff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerforms image differentiation by  running  2  NxN  weighted\n");
	fprintf(stderr, "\toperators on an image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image filename  (infile)\n");
	fprintf(stderr,"\t-i2  input kernel (operator) in X  (infile)\n");
	fprintf(stderr,"\t-i3  input kernel (operator) in Y  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vdiff\n");
	fprintf(stderr, "\t[-U] Gives the usage for vdiff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vdiff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vdiff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vdiff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image filename \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input kernel (operator) in X \n        {infile}: "; 
char	*i3_pstr = 
	"\nEnter: (i3) input kernel (operator) in Y \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vdiff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vdiff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vdiff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vdiff.ans");
		}

	     }

	}

	/*
	 * allocate the vdiff structure
	 */
	vdiff = (vdiff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vdiff_struct));

	/*
	 * get required arguments for vdiff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vdiff->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vdiff->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiff->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vdiff->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vdiff->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdiff->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vdiff->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiff->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vdiff->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vdiff->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdiff->i3_flag = vget_infile(fid, prompt_flag,
			"-i3", i3_pstr, &(vdiff->i3_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiff->i3_flag))
		{
		    fprintf(stderr, "\t\ti3 is required, please re-enter: \n");
		    vdiff->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(vdiff->i3_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdiff->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vdiff->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiff->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vdiff->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vdiff->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



