 /*
  * Khoros: $Id: vtranslat.h,v 1.1 1991/05/10 15:49:15 khoros Exp $
  */

 /*
  * $Log: vtranslat.h,v $
 * Revision 1.1  1991/05/10  15:49:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vtranslat.h
 >>>>            Author: Pascal ADAM
 >>>> Date Last Updated: Sun Mar 31 13:56:24 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vtranslat_h_
#define _vtranslat_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vtranslat Argument Structure
*
****************************************************************/

typedef struct _vtranslat  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  Translation along x axe (Required integer)
 */
int	 x_int; 	/* Translation along x axe INT */
int	 x_flag;	/* Translation along x axe FLAG */

/*
 *  Translation along y axe (Required integer)
 */
int	 y_int; 	/* Translation along y axe INT */
int	 y_flag;	/* Translation along y axe FLAG */

/*
 *  if true, wraps the image around, if false pads with a padding value (Optional logical)
 */
int	 w_logic;	/* if true, wraps the image around, if false pads with a padding value LOGIC */
int	 w_flag;  	/* if true, wraps the image around, if false pads with a padding value FLAG */

/*
 *  paddingvalue (Optional float)
 */
float	 p_float;	/* paddingvalue FLOAT */
int	 p_flag;   	/* paddingvalue FLAG */

}  vtranslat_struct;

vtranslat_struct *vtranslat;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(vtranslat->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr, "vtranslat: Can not read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
    \
    (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
