 /*
  * Khoros: $Id: vgauss.c,v 1.2 1991/12/18 09:41:38 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgauss.c,v 1.2 1991/12/18 09:41:38 dkhoros Exp $";
#endif

 /*
  * $Log: vgauss.c,v $
 * Revision 1.2  1991/12/18  09:41:38  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgauss.c
 >>>>
 >>>>      Program Name: vgauss
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create an image containing one or more Gaussians
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Dec  9 23:22:23 1991
 >>>>
 >>>>          Routines: main- the main program for vgauss
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgauss.h"


/****************************************************************
 *
 * Routine Name:  main program for vgauss
 *
 *       Input:  
 *        -o  output image 
 *
 *
 *        [-trigger] trigger input
 *        [-c] Number of Columns  (value > 0)
 *        [-r] Number of rows  (value > 0)
 *        [-x] X peak location  (value >= 0.0)
 *        [-y] Y peak location  (value >= 0.0)
 *        [-vx] X variance  (value >= 0.0)
 *        [-vy] Y variance  (value >= 0.0)
 *        [-ra] Rotation angle  (-90.000 < value < 90.000)
 *        [-amp] Peak Amplitude 
 *        [-p] Parameters input image
 *        [-n] Normalize Gaussian(s)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *params,*image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if(check_args())exit(1);

    /* Read the input images (really the tie point coordinates) */
    params = NULL;
    if (vgauss->p_flag)
      {
        params = readimage(vgauss->p_file);
        if (params == NULL)
          {
            fprintf(stderr,"vgauss: Unable to read parameters image\n");
            exit(1);
          }
        if (params->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vgauss: parameter image must be of type FLOAT\n");
            exit(1);
          }
        if (params->num_data_bands != 6)
          {
            fprintf(stderr,"vgauss: parameter image must have 6 bands!\n");
            exit(1);
          }
        if (params->map_scheme != VFF_MS_NONE)
          {
            fprintf(stderr,"vgauss: parameter image must not be mapped!\n");
            exit(1);
          }
        if (params->row_size*params->col_size == 0)
          {
            fprintf(stderr,"vgauss: parameter image has no parameters!\n");
            exit(1);
          }
      }
/* -main_before_lib_call_end */

/* -main_library_call */
if (!lvgauss(&image,vgauss->r_int,vgauss->c_int,
                    vgauss->x_float,vgauss->y_float,
                    vgauss->vx_float,vgauss->vy_float,
                    vgauss->ra_float,vgauss->amp_float,
                    vgauss->n_logic,params))
  {
    (void)fprintf(stderr,"lvgauss failed\n");
    exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgauss->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgauss 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgauss :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate an image containing one or more Gaussians\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-c]  Number of Columns (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-r]  Number of rows (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-x]  X peak location (float, >= 0.0) [256]\n");
	fprintf(stderr,"\t[-y]  Y peak location (float, >= 0.0) [256]\n");
	fprintf(stderr,"\t[-vx]  X variance (float, >= 0.0) [30]\n");
	fprintf(stderr,"\t[-vy]  Y variance (float, >= 0.0) [30]\n");
	fprintf(stderr,"\t[-ra]  Rotation angle (float,  -90.000 to 90.000) [0]\n");
	fprintf(stderr,"\t[-amp]  Peak Amplitude (float) [1]\n");
	fprintf(stderr,"\t[-p]  Parameters input image (infile) [null]\n");
	fprintf(stderr,"\t[-n]  Normalize Gaussian(s) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgauss\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgauss\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgauss.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgauss.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgauss
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*c_pstr = 
	"\nEnter: (c) Number of Columns \n        {integer, > 0 [512] }: "; 
char	*r_pstr = 
	"\nEnter: (r) Number of rows \n        {integer, > 0 [512] }: "; 
char	*x_pstr = 
	"\nEnter: (x) X peak location \n        {float, >= 0.0 [256.000000] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y peak location \n        {float, >= 0.0 [256.000000] }: "; 
char	*vx_pstr = 
	"\nEnter: (vx) X variance \n        {float, >= 0.0 [30.000000] }: "; 
char	*vy_pstr = 
	"\nEnter: (vy) Y variance \n        {float, >= 0.0 [30.000000] }: "; 
char	*ra_pstr = 
	"\nEnter: (ra) Rotation angle \n        {float,  -90.000 to 90.000 [0.000000] }: "; 
char	*amp_pstr = 
	"\nEnter: (amp) Peak Amplitude \n        {float [1.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) Parameters input image \n        {infile}: "; 
char	*n_pstr = 
	"\nEnter: (n) Normalize Gaussian(s) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgauss", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgauss.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgauss: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgauss.ans");
		}

	     }

	}

	/*
	 * allocate the vgauss structure
	 */
	vgauss = (vgauss_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgauss_struct));

	/*
	 * get required arguments for vgauss
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgauss->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgauss->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgauss->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgauss->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgauss->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgauss
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgauss->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgauss->trigger_file))
;

	vgauss->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgauss->c_int),
	512, 2, 2);

	vgauss->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgauss->r_int),
	512, 2, 2);

	vgauss->x_flag = vget_float(fid, prompt_flag,
	"-x", x_pstr, &(vgauss->x_float),
	256.000000, 1.000000, 1.000000);

	vgauss->y_flag = vget_float(fid, prompt_flag,
	"-y", y_pstr, &(vgauss->y_float),
	256.000000, 1.000000, 1.000000);

	vgauss->vx_flag = vget_float(fid, prompt_flag,
	"-vx", vx_pstr, &(vgauss->vx_float),
	30.000000, 1.000000, 1.000000);

	vgauss->vy_flag = vget_float(fid, prompt_flag,
	"-vy", vy_pstr, &(vgauss->vy_float),
	30.000000, 1.000000, 1.000000);

	vgauss->ra_flag = vget_float(fid, prompt_flag,
	"-ra", ra_pstr, &(vgauss->ra_float),
	0.000000, -90.000000, 90.000000);

	vgauss->amp_flag = vget_float(fid, prompt_flag,
	"-amp", amp_pstr, &(vgauss->amp_float),
	1.000000, 0.000000, 0.000000);

	vgauss->p_flag = vget_infile(fid, prompt_flag,
	"-p", p_pstr, &(vgauss->p_file))
;

	vgauss->n_flag = vget_logic(fid, prompt_flag,
	"-n", n_pstr, &(vgauss->n_logic), 0);


}



