 /*
  * Khoros: $Id: vgfractal.h,v 1.2 1991/12/18 09:40:55 dkhoros Exp $
  */

 /*
  * $Log: vgfractal.h,v $
 * Revision 1.2  1991/12/18  09:40:55  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgfractal.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Mon Dec  9 23:26:41 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgfractal_h_
#define _vgfractal_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgfractal Argument Structure
*
****************************************************************/

typedef struct _vgfractal  {

/*
 *  Output image filename (Required outfile)
 */
char	*o_file;	/* Output image filename FILENAME */
int	 o_flag;	/* Output image filename FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  Number of recursions (Optional integer)
 */
int	 r_int; 	/* Number of recursions INT */
int	 r_flag;	/* Number of recursions FLAG */

/*
 *  Hurst coefficient (Optional float)
 */
float	 h_float;	/* Hurst coefficient FLOAT */
int	 h_flag;   	/* Hurst coefficient FLAG */

/*
 *  Standard deviation (Optional float)
 */
float	 d_float;	/* Standard deviation FLOAT */
int	 d_flag;   	/* Standard deviation FLAG */

/*
 *  Seed (Optional integer)
 */
int	 s_int; 	/* Seed INT */
int	 s_flag;	/* Seed FLAG */

/*
 *  Coastlines (Optional logical)
 */
int	 c_logic;	/* Coastlines LOGIC */
int	 c_flag;  	/* Coastlines FLAG */

/*
 *  Random additions (Optional logical)
 */
int	 m_logic;	/* Random additions LOGIC */
int	 m_flag;  	/* Random additions FLAG */

}  vgfractal_struct;

vgfractal_struct *vgfractal;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
