 /*
  * Khoros: $Id: cantata.c,v 1.1 1991/05/10 15:57:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cantata.c,v 1.1 1991/05/10 15:57:48 khoros Exp $";
#endif

 /*
  * $Log: cantata.c,v $
 * Revision 1.1  1991/05/10  15:57:48  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: cantata.c
 >>>>
 >>>>      Program Name: cantata
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	visual programming environment for accessing the Khoros  li-
 >>>>	brary of routines
 >>>>	
 >>>>	
 >>>>            Author: Stephanie Hallett, Mark Young, & Carla Williams
 >>>>
 >>>> Date Last Updated: Fri Apr 26 14:36:17 1991
 >>>>
 >>>>          Routines: main- the main program for cantata
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "cantata.h"


/****************************************************************
 *
 * Routine Name:  main program for cantata
 *
 *       Input:  
 *
 *
 *         [-form] file for ipl and cantata form definition
 *         [-restore] file for restoring cantata workspace
 *         [-log] log file: where each khoros command is logged
 *         [-dir] directory for I/O files
 *         [-verbose] verbose mode: prints out any option not used
 *         [-echo] echos the command line for each routine executed
 *         [-grid] displays grid in the workspace for placing glyphs
 *         [-display] host:display.screen
 *         [-x] x value of upper-left corner of workspace  (0 < value < 9999)
 *         [-y] y value of upper-left corner of workspace  (0 < value < 9999)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        (void) consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */

        /*
         * go run cantata
         */
        if (lcantata(ac, av) == False)
        {
           fprintf(stderr,"lcantata failed\n");
           exit(1);
        }

/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for cantata 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "cantata :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tvisual programming environment for accessing the Khoros  li-\n");
	fprintf(stderr, "\tbrary of routines\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-form]  file for ipl and cantata form definition (infile) [null]\n");
	fprintf(stderr,"\t[-restore]  file for restoring cantata workspace (infile) [null]\n");
	fprintf(stderr,"\t[-log]  log file: where each khoros command is logged (string) [null]\n");
	fprintf(stderr,"\t[-dir]  directory for I/O files (string) [null]\n");
	fprintf(stderr,"\t[-verbose]  verbose mode: prints out any option not used (boolean) [false]\n");
	fprintf(stderr,"\t[-echo]  echos the command line for each routine executed (boolean) [true]\n");
	fprintf(stderr,"\t[-grid]  displays grid in the workspace for placing glyphs (boolean) [true]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr,"\t[-x]  x value of upper-left corner of workspace (integer, 0 to 9999) [0]\n");
	fprintf(stderr,"\t[-y]  y value of upper-left corner of workspace (integer, 0 to 9999) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for cantata\n");
	fprintf(stderr, "\t[-V] Gives the version for cantata\n");
	fprintf(stderr, "\t[-U] Gives the usage for cantata\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called cantata.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses cantata.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for cantata
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*form_pstr = 
	"\nEnter: (form) file for ipl and cantata form definition \n        {infile}: "; 
char	*restore_pstr = 
	"\nEnter: (restore) file for restoring cantata workspace \n        {infile}: "; 
char	*log_pstr = 
	"\nEnter: (log) log file: where each khoros command is logged \n        {string}: "; 
char	*log_def = NULL;
char	*dir_pstr = 
	"\nEnter: (dir) directory for I/O files \n        {string}: "; 
char	*dir_def = NULL;
char	*verbose_pstr = 
	"\nEnter: (verbose) verbose mode: prints out any option not used \n        {boolean, (y/n)  [no] }: "; 
char	*echo_pstr = 
	"\nEnter: (echo) echos the command line for each routine executed \n        {boolean, (y/n)  [yes] }: "; 
char	*grid_pstr = 
	"\nEnter: (grid) displays grid in the workspace for placing glyphs \n        {boolean, (y/n)  [yes] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*x_pstr = 
	"\nEnter: (x) x value of upper-left corner of workspace \n        {integer, 0 to 9999 [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y value of upper-left corner of workspace \n        {integer, 0 to 9999 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "cantata", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "cantata.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "cantata: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "cantata.ans");
		}

	     }

	}

	/*
	 * allocate the cantata structure
	 */
	cantata = (cantata_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (cantata_struct));

	/*
	 * get optional arguments for cantata
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	cantata->form_flag = vget_infile(fid, prompt_flag,
	"-form", form_pstr, &(cantata->form))
;

	cantata->restore_flag = vget_infile(fid, prompt_flag,
	"-restore", restore_pstr, &(cantata->restore))
;

	cantata->log_flag = vget_string(fid, prompt_flag,
	"-log", log_pstr, &(cantata->log),
	log_def);

	if (prompt_flag == FALSE)
	{
	    if ((cantata->log_flag == 1)&&(cantata->log == NULL))
    	{
		fprintf(stderr, "cantata:\n");
		fprintf(stderr, "you must specify a name following '-log'\n");
		gw_usage();
		exit(1);
		}
	}
	cantata->dir_flag = vget_string(fid, prompt_flag,
	"-dir", dir_pstr, &(cantata->dir),
	dir_def);

	if (prompt_flag == FALSE)
	{
	    if ((cantata->dir_flag == 1)&&(cantata->dir == NULL))
    	{
		fprintf(stderr, "cantata:\n");
		fprintf(stderr, "you must specify a name following '-dir'\n");
		gw_usage();
		exit(1);
		}
	}
	cantata->verbose_flag = vget_logic(fid, prompt_flag,
	"-verbose", verbose_pstr, &(cantata->verbose), 0);

	cantata->echo_flag = vget_logic(fid, prompt_flag,
	"-echo", echo_pstr, &(cantata->echo), 1);

	cantata->grid_flag = vget_logic(fid, prompt_flag,
	"-grid", grid_pstr, &(cantata->grid), 1);

	cantata->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(cantata->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((cantata->display_flag == 1)&&(cantata->display == NULL))
    	{
		fprintf(stderr, "cantata:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	cantata->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(cantata->x),
	0, 0, 9999);

	cantata->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(cantata->y),
	0, 0, 9999);


}



