 /*
  * Khoros: $Id: environment.c,v 1.3 1992/03/20 22:42:54 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: environment.c,v 1.3 1992/03/20 22:42:54 dkhoros Exp $";
#endif

 /*
  * $Log: environment.c,v $
 * Revision 1.3  1992/03/20  22:42:54  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  environment.c                         <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_set_environment()                 <<<<
   >>>>                 xvl_set_environ_pane()                <<<<
   >>>>                 xvl_set_workspace_pane()              <<<<
   >>>>                 xvl_set_direct_pane()                 <<<<
   >>>>                 xvl_init_environment()                <<<<
   >>>>                 xvl_init_environ_pane()               <<<<
   >>>>                 xvl_init_workspace_pane()             <<<<
   >>>>                 xvl_init_direct_pane()                <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_set_environment
*
*      Purpose:  This routine is used to process the user requests
*		 from the environment subform.
*
*        Input: workspace - the workspace being processed.
*		form      - the form being processed
*		subform   - the subform of that form
*
*
*   Written By: Mark Young & Carla Williams
*
*************************************************************/


xvl_set_environment(workspace, form, subform)

Workspace	*workspace;
xvf_form	*form;
xvf_sub_form	*subform;
{
	xvf_guide_button *guide;
	Line_Info        lineinfo;


	if (form == NULL)
	   return;
	if (subform == NULL)
	   return;

	xvf_clear_line_info(&lineinfo);
	guide = subform->guide_button;
	if (guide == NULL)
	   return;

	/*  Trap SubformAction Button QUIT  */
	while (guide->next_button != NULL)
	{
	   if (guide->type == QuitForm)
	   {
	      xvl_parse_line(form->db, guide->index, &lineinfo);
              if (lineinfo.selected == True)
	      {
		 guide->selected = false;
		 return;
	      }
	   }
	   guide = guide->next_button;
	}


	guide = xvf_search_sel_guide(subform);
	if (guide == NULL)
	   return;

	if (guide->pane == NULL)
	   return;

	/*  Determine which Pane Button was selected  */
	if (strcmp(subform->subform_name,"environment") == 0)
	{
	   if (strcmp(guide->button_name,"environ_guide_button") == 0)
	      xvl_set_attributes_pane(workspace, form, guide, lineinfo);

	   else if (strcmp(guide->button_name, "workspace_guide_button") == 0 ||
		    strcmp(guide->button_name, "direct_guide_button") == 0)
	      xvl_set_directory_pane(workspace, form, guide, lineinfo);
	}
	else if (strcmp(subform->subform_name,"attributes") == 0)
	{
	   xvl_set_attributes_pane(workspace, form, guide, lineinfo);
	}
	else if (strcmp(subform->subform_name,"directory") == 0)
	{
	   xvl_set_directory_pane(workspace, form, guide, lineinfo);
	}
}



/************************************************************
*
* Routine Name:  xvl_set_attributes_pane
*
*      Purpose:  This routine is used to process the user requests
*		 from the environment pane.
*
*        Input:  workspace -  the workspace from where the request
*			      came from.
*		 form       - the form being processed
*		 guide	    - the guide pointer of that form
*		 lineinfo   - the line info srtucture.
*
*
*   Written By: Mark Young & Carla Williams
*
*************************************************************/


xvl_set_attributes_pane(workspace, form, guide, lineinfo)

Workspace	 *workspace;
xvf_form	 *form;
xvf_guide_button *guide;
Line_Info	 lineinfo;
{
	int	        type;
	xvf_selection   *selection, *temp_ptr;


	selection = guide->pane->sel_list;
	while (selection != NULL)
	{
	   xvl_parse_line(form->db, selection->index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
	      if (strcmp(lineinfo.variable,"inherit") == 0)
	      {
		 if (workspace->inherit_attributes != lineinfo.logical_val)
		 {
		    workspace->inherit_attributes = lineinfo.logical_val;
		    xvl_set_attributes(workspace);

		    temp_ptr = guide->pane->sel_list;
		    while (temp_ptr != NULL)
		    {
		       type = xvf_get_line_type(form->db[temp_ptr->index]);
		       if (temp_ptr != selection && type != HelpSel &&
				type != QuitForm)
		       {
			  if (workspace->inherit_attributes)
			     xvf_change_input(form, temp_ptr->index,
				   xvf_activation_chng, "0", 0);
			  else
			     xvf_change_input(form, temp_ptr->index,
				   xvf_activation_chng, "1", 0);
		       }
		       temp_ptr = temp_ptr->next;
		    }
		 }
		 break;
	      }
	   }
	   selection = selection->next;
	}

	selection = guide->pane->sel_list;
	while (selection != NULL)
	{
	   xvl_parse_line(form->db, selection->index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
	      if (strcmp(lineinfo.variable,"grid") == 0)
	      {
		 if (workspace->show_grid != lineinfo.logical_val)
		 {
		    workspace->show_grid = lineinfo.logical_val;
		    xvl_set_grid(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"parallel_exec") == 0)
	      {
		 if (lineinfo.logical_val != workspace->parallel)
		 {
		    workspace->parallel = lineinfo.logical_val;
		 }
	      }
	      else if (strcmp(lineinfo.variable,"demand_driven") == 0)
	      {
		 if (lineinfo.logical_val != workspace->demand_driven)
		 {
		    workspace->demand_driven = lineinfo.logical_val;
		 }
	      }
	      else if (strcmp(lineinfo.variable,"leave_glyph") == 0)
	      {
		 if (lineinfo.logical_val != workspace->leave_glyph)
		 {
		    workspace->leave_glyph = lineinfo.logical_val;
		    xvl_set_mapping(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"global_variables") == 0)
	      {
		 if (lineinfo.logical_val != workspace->global_variables)
		 {
		    workspace->global_variables = lineinfo.logical_val;
		    xvl_set_variables(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"show_dav") == 0)
	      {
		 if (lineinfo.logical_val != workspace->show_dav)
		 {
		    workspace->show_dav = lineinfo.logical_val;
		    xvl_set_dav(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"show_modified") == 0)
	      {
		 if (lineinfo.logical_val != workspace->show_modified)
		 {
		    workspace->show_modified = lineinfo.logical_val;
		    xvl_set_modified(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"show_clipboard") == 0)
	      {
		 if (lineinfo.logical_val != workspace->show_clipboard)
		 {
		    workspace->show_clipboard = lineinfo.logical_val;
		    xvl_set_clipboard(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"rubberband") == 0)
	      {
		 if (lineinfo.logical_val != workspace->rubberband)
		 {
		    workspace->rubberband = lineinfo.logical_val;
		 }
	      }
	      else if (strcmp(lineinfo.variable,"grid_size") == 0)
	      {
		 if (lineinfo.int_val != workspace->grid_size)
		 {
		    workspace->grid_size = lineinfo.int_val;
		    xvl_set_gridsize(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"glyph_size") == 0)
	      {
		 /*
		  *  The user has changed the widget size.  This means that
		  *  all the widgets must destroyed and recreated with the
		  *  small or normal size widgets.
		  */
		 if (workspace->small_glyphs != lineinfo.logical_val)
		 {
		    workspace->small_glyphs = lineinfo.logical_val;
		    xvl_set_glyphsize(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"echo") == 0)
	      {
		 if (workspace->echo_exec != lineinfo.logical_val)
		 {
		    workspace->echo_exec = lineinfo.logical_val;
		 }
	      }
	      else if (strcmp(lineinfo.variable,"glyph_placement") == 0)
	      {
		 if (workspace->glyph_placement != lineinfo.logical_val)
		 {
		    workspace->glyph_placement = lineinfo.logical_val;
		 }
	      }
	      else if (strcmp(lineinfo.variable,"remote_execution") == 0)
	      {
		 if (lineinfo.logical_val != workspace->remote_execution)
		 {
		    workspace->remote_execution = lineinfo.logical_val;
		    xvl_set_distributed(workspace);
		 }
	      }
	      else if (strcmp(lineinfo.variable,"stream_execution") == 0)
	      {
		 if (lineinfo.logical_val != workspace->stream_execution)
		 {
		    workspace->stream_execution = lineinfo.logical_val;
		    xvl_set_negotiator(workspace);
		 }
	      }
	   }
	   selection = selection->next;
	}
}



/************************************************************
*
* Routine Name:  xvl_set_directory_pane
*
*      Purpose:  This routine is used to process the user requests
*		 from the directory pane
*
*        Input:  workspace -  the workspace from where the request
*			      came from.
*		 form       - the form being processed
*		 guide  - the guide pointer of that form
*		 lineinfo   - the line info srtucture.
*
*
*   Written By: Mark Young
*
*************************************************************/


xvl_set_directory_pane(workspace, form, guide, lineinfo)

Workspace	 *workspace;
xvf_form	 *form;
xvf_guide_button *guide;
Line_Info	 lineinfo;
{
	xvf_selection    *selection;
	int              status;
	char		 temp[512], *file, *dir, *getenv();


	selection = guide->pane->sel_list;
	while(selection != NULL)
	{
	   xvl_parse_line(form->db, selection->index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
              if ((lineinfo.selected == True) &&
		  (strcmp(lineinfo.variable,"save_workspace") == 0))
	      {
	         status = xvf_exit_wait("Do you also wish to SAVE the temporary\
 image files associated with this workspace?", "SAVE All Files?", "YES", "NO",
				     "Cancel SAVE");

	         if (status != -1)                /*  YES or NO  */
	         {
		    file = vfullpath(lineinfo.filename, XVF_FILE_DIR, NULL);
	            if (xvl_save_workspace(workspace, workspace->glyphs, file,
				status))
		    {
		       sprintf(temp,"Workspace saved in '%s'\n", file);
		       xvf_error_wait(temp, "cantata", NULL);
		       workspace->modified = False;
		    }
		    else
		    {
		       sprintf(temp,"Error! Unable to save workspace.  File\
'%s' was not created.", file);
		       xvf_error_wait(temp, "cantata", NULL);
		    }
		    free(file);
	         }
	      }
              else if ((lineinfo.selected == True) &&
		       (strcmp(lineinfo.variable,"restore_workspace") == 0))
	      {
		 file = vfullpath(lineinfo.filename, XVF_FILE_DIR, NULL);
	         if (xvl_restore_workspace(workspace, file, True))
		 {
		    sprintf(temp,"Workspace restored from '%s'\n", file);
		    xvf_error_wait(temp, "cantata", NULL);
		 }
		 else
		 {
		    sprintf(temp,"Error! Unable to restore workspace.  No \
workspace was restored from file '%s'.", file);
		    xvf_error_wait(temp, "cantata", NULL);
		 }
		 free(file);
	      }
	      else if (strcmp(lineinfo.variable,"compress") == 0)
	      {
	         workspace->compress = lineinfo.logical_val;
	      }
	      else if ((lineinfo.selected == True) &&
		       (strcmp(lineinfo.variable,"read_uis") == 0))
	      {
		 if ((lineinfo.opt_sel == True) && (lineinfo.filename != NULL))
		    xvl_read_glyph(workspace, lineinfo.filename);
		 else
		    xvf_error_wait("Error!  No filename specified. Can't read \
in a glyph without the specified filename.", "cantata", NULL);
	      }
	      else if (strcmp(lineinfo.variable,"dir") == 0)
	      {
		 if ((lineinfo.selected == True) && (lineinfo.string_val!=NULL))
		 {
		    if (access(lineinfo.string_val, F_OK) == -1)
		    {
		       if (XVF_FILE_DIR == NULL)
			  dir = "./";
		       else
		          dir = XVF_FILE_DIR;

		       (void) sprintf(temp,"'%s' is not a valid directory.  \
Please input a valid input/output directory from which cantata can create and \
retrieve files.  The current directory is set to '%s'",
				      lineinfo.string_val, dir);
		       xvf_error_wait(temp,"xvl_set_direct_pane",NULL);
		    }
		    else
		    {
		       XVF_FILE_DIR = xvf_strcpy(lineinfo.string_val);
		    }
		 }
		 else
		    XVF_FILE_DIR = NULL;
	      }
	      else if (strcmp(lineinfo.variable,"tmpdir") == 0)
	      {
	         if ((lineinfo.selected == True)&&(lineinfo.string_val != NULL))
		 {
		    if (access(lineinfo.string_val, F_OK | W_OK) == -1)
		    {
		       dir = getenv("TMPDIR");
		       if (!dir) dir = "./";

		       (void) sprintf(temp,"'%s' is not a valid directory.  \
Please input a valid TMPDIR in which cantata can create temporary files.  The \
current directory is set to '%s'", lineinfo.string_val, dir);
		       xvf_error_wait(temp,"xvl_set_direct_pane",NULL);
		    }
		    else
		    {
		       (void) sprintf(temp,"TMPDIR=%s", lineinfo.string_val);
		       vputenv(xvf_strcpy(temp));
		    }
		 }
	      }
	      else if ((lineinfo.selected == True) && 
	             (strcmp(lineinfo.variable,"clear") == 0))
	      {
	         if (xvf_warn_wait("Warning, this option will delete all current information from the workspace.\n\nSelect CLEAR if you wish to continue.\n\nSelect CANCEL if you wish to return to the current workspace.",
	          "CLEAR Workspace - Warning", "CLEAR", "CANCEL") == 1)
	         {
	            xvl_clear_workspace(workspace);
	         }
	      }
              else if ((lineinfo.selected == True) && (strcmp(lineinfo.variable,
		   "savefiles") == 0))
	      {
		 (void) xvl_save_temp_files(workspace);
	      }
	   }
	   selection = selection->next;
	}
}



/************************************************************
*
* Routine Name:  xvl_init_environment
*
*      Purpose:  This routine is used to process the initialize from
*		 the workspace/procedure environment subform from the
*		 command line arguments.
*
*        Input:  workspace  - the workspace to be registered.
*		 form       - the form being initialized
*		 cantata      - the cantata command line structure.
*
*
*   Written By: Mark Young & Carla Williams
*
*************************************************************/


xvl_init_environment(workspace, form, cantata)

Workspace	*workspace;
xvf_form	*form;
cantata_struct	*cantata;
{
	xvf_sub_form	 *subform;
	Line_Info     	 lineinfo;
	xvf_guide_button *guide;


	xvf_clear_line_info(&lineinfo);

	/* search form for environment subform */
	subform = form->subform;
	while (subform != NULL)
	{
	   if (subform->type == SubFormButton)
	   {
	      guide = subform->guide_button;
	      if (subform->subform_name != NULL)
	      {
		 if (strcmp(subform->subform_name,"attributes") == 0)
		 {
		    xvl_init_attributes_pane(workspace, form, cantata, lineinfo,
				subform->guide_button);
		 }
		 else if (strcmp(subform->subform_name,"directory") == 0)
		 {
		    xvl_init_directory_pane(workspace, form, cantata, lineinfo,
				subform->guide_button);
		 }
		 else if (strcmp(subform->subform_name,"environment") == 0)
		 {
		    while (guide != NULL)
		    {
		       if (guide->type == GuideButton)
		       {
		          xvl_parse_line(form->db,guide->pane->index,&lineinfo);
		          if (lineinfo.variable != NULL)
		          {
			     if (strcmp(lineinfo.variable,"environ") == 0)
			     {
			        xvl_init_attributes_pane(workspace, form,
					cantata, lineinfo, guide);
			     }
			     else if (strcmp(lineinfo.variable,"workspace")
				== 0 || strcmp(lineinfo.variable,"direct"))
			     {
			        xvl_init_directory_pane(workspace, form,
					cantata, lineinfo, guide);
			     }
			  }
		       }
		       guide = guide->next_button;
		    }
		 }
	      }
	   }
	   subform = subform->next_subform;
	}
}



/************************************************************
*
* Routine Name:  xvl_init_attributes_pane
*
*      Purpose:  This routine is used to process the initialize from
*		 the workspace/procedure attributes subform from the
*		 command line arguments.
*
*        Input:  workspace  - the workspace to be registered.
*		 form       - the form being initialized
*		 cantata    - the cantata command line structure.
*		 guide	    - the guide button
*
*
*   Written By: Mark Young
*
*************************************************************/


xvl_init_attributes_pane(workspace, form, cantata, lineinfo, guide)

Workspace	*workspace;
xvf_form	*form;
cantata_struct	*cantata;
Line_Info	lineinfo;
xvf_guide_button *guide;
{
	char	        temp[25];
	int		index, type;
	xvf_selection   *selection, *temp_ptr = NULL;


	/* set defaults from database */
	selection = guide->pane->sel_list;
	while (selection != NULL)
	{
	   index = selection->index;
	   xvl_parse_line(form->db, index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
	      if (strcmp(lineinfo.variable,"grid") == 0)
	      {
	         if (cantata->grid_flag == true)
		    workspace->show_grid = cantata->grid;

		 if (workspace->show_grid)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"inherit") == 0)
	      {
		 if (workspace == main_workspace)
		 {
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	            xvf_change_input(form, index, xvf_activation_chng, "0", 0);
		 }
		 else if (workspace->inherit_attributes)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);

		 temp_ptr = selection;
	      }
	      else if (strcmp(lineinfo.variable,"parallel_exec") == 0)
	      {
		 if (workspace->parallel)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"demand_driven") == 0)
	      {
		 if (workspace->demand_driven)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"leave_glyph") == 0)
	      {
		 if (workspace->leave_glyph)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"global_variables") == 0)
	      {
		 if (workspace->global_variables)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng,
					"0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"show_dav") == 0)
	      {
		 if (workspace->show_dav)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"show_modified") == 0)
	      {
		 if (workspace->show_modified)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"show_clipboard") == 0)
	      {
		 if (workspace->show_clipboard)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"grid_size") == 0)
	      {
		 sprintf(temp, "%d", workspace->grid_size);
		 xvf_change_input(form, index, xvf_intval_chng, temp, 0);
	      }
	      else if (strcmp(lineinfo.variable,"glyph_size") == 0)
	      {
		 if (workspace->small_glyphs)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"rubberband") == 0)
	      {
		 if (workspace->rubberband)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"glyph_placement") == 0)
	      {
		 if (workspace->glyph_placement)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng, "0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"echo") == 0)
	      {
	         /* do command line */
	         if (cantata->echo_flag == true)
	            workspace->echo_exec = cantata->echo;

	         if (workspace->echo_exec)
		    xvf_change_input(form, index, xvf_logicalval_chng,"1",0);
	         else
		    xvf_change_input(form, index, xvf_logicalval_chng,"0",0);
	      }
	      else if (strcmp(lineinfo.variable,"remote_execution") == 0)
	      {
		 if (workspace->remote_execution)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng,
					"0", 0);
	      }
	      else if (strcmp(lineinfo.variable,"stream_execution") == 0)
	      {
		 if (workspace->stream_execution)
		    xvf_change_input(form, index, xvf_logicalval_chng, "1", 0);
		 else
		    xvf_change_input(form, index, xvf_logicalval_chng,
					"0", 0);
	      }
	   }
	   selection = selection->next;
	}

	/* set defaults from database */
	selection = guide->pane->sel_list;
	while (selection != NULL)
	{
	   index = selection->index;
	   type = xvf_get_line_type(form->db[index]);
	   if (selection != temp_ptr && type != HelpSel && type != QuitForm)
	   {
	      if (workspace->inherit_attributes)
	         xvf_change_input(form, index, xvf_activation_chng, "0", 0);
	      else
	         xvf_change_input(form, index, xvf_activation_chng, "1", 0);
	   }
	   selection = selection->next;
	}
}



/************************************************************
*
* Routine Name:  xvl_init_directory_pane
*
*      Purpose:  This routine is used to process the initialize from
*		 the workspace/procedure environment subform from the
*		 command line arguments.
*
*        Input:  workspace  - the workspace to be registered.
*		 form       - the form being initialized
*		 cantata      - the cantata command line structure.
*
*
*   Written By: Mark Young & Carla Williams
*
*************************************************************/


xvl_init_directory_pane(workspace, form, cantata, lineinfo, guide)

Workspace	*workspace;
xvf_form	*form;
cantata_struct	*cantata;
Line_Info	lineinfo;
xvf_guide_button *guide;
{
	int	      index;
	xvf_selection *selection;
	char	      *tmpdir, *getenv();


	/* set defaults from database */
	selection = guide->pane->sel_list;
	while (selection != NULL)
	{
	   index = selection->index;
	   xvl_parse_line(form->db, index, &lineinfo);
	   if (lineinfo.variable != NULL)
	   {
	      if (strcmp(lineinfo.variable, "compress") == 0)
	      {
		 workspace->compress = lineinfo.logical_def;
	      }

	      /*  Input files Directory  */
	      else if (strcmp(lineinfo.variable,"dir") == 0)
	      {
		 /* set default files directory from database */
		 if (lineinfo.string_val != NULL)
		    XVF_FILE_DIR = xvf_strcpy(lineinfo.string_val);
		 else
		    XVF_FILE_DIR = NULL;

		 /* override with command line */
		 if ((cantata->dir_flag == true) &&
		     (cantata->dir != NULL))
		    XVF_FILE_DIR = xvf_strcpy(cantata->dir);

		 if (XVF_FILE_DIR != NULL)
		 {
		    xvf_change_input(form, index, xvf_stringval_chng,
				     XVF_FILE_DIR, 0);
		 }
	      }

	      /*  temporary file Directory  */
	      else if (strcmp(lineinfo.variable,"tmpdir") == 0)
	      {
		 /* set default directory from environment TMPDIR */
		 if ((tmpdir = getenv("TMPDIR")) != NULL)
		 {
		    xvf_change_input(form, index, xvf_stringval_chng, tmpdir,0);
		 }
	      }

	   }
	   selection = selection->next;
	}
}
