 /*
  * Khoros: $Id: conductor.c,v 1.2 1991/10/02 00:13:16 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: conductor.c,v 1.2 1991/10/02 00:13:16 khoros Exp $";
#endif

 /*
  * $Log: conductor.c,v $
 * Revision 1.2  1991/10/02  00:13:16  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: conductor.c
 >>>>
 >>>>      Program Name: conductor
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	This program automatically generates code to initialize  and
 >>>>	extract information from the Graphical User Interface (GUI).
 >>>>	It is for use by all application programmers who  intend  to
 >>>>	write an _x_v_r_o_u_t_i_n_e.
 >>>>	
 >>>>	
 >>>>            Author: Danielle Argiro
 >>>>
 >>>> Date Last Updated: Tue Apr  2 15:11:11 1991
 >>>>
 >>>>          Routines: main- the main program for conductor
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "conductor.h"


/****************************************************************
 *
 * Routine Name:  main program for conductor
 *
 *       Input:  
 *           -i  UIS file 
 *           -l  Level of Extraction   (1 < value < 3)
 *
 *
 *           [-b] generate program driver?
 *           [-f] force output?
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
	int dummy;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
	if (dummy != dummy) XtToolkitInitialize();
        consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lconductor(conductor->i, conductor->l, conductor->b))
        {
           (void) fprintf(stderr, "conductor: Could not create files\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for conductor 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "conductor :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tThis program automatically generates code to initialize  and\n");
	fprintf(stderr, "\textract information from the Graphical User Interface (GUI).\n");
	fprintf(stderr, "\tIt is for use by all application programmers who  intend  to\n");
	fprintf(stderr, "\twrite an _x_v_r_o_u_t_i_n_e.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  UIS file  (infile)\n");
	fprintf(stderr,"\t-l  Level of Extraction  (integer, 1 to 3)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]  generate program driver? (boolean) [false]\n");
	fprintf(stderr,"\t[-f]  force output? (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for conductor\n");
	fprintf(stderr, "\t[-U] Gives the usage for conductor\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called conductor.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses conductor.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for conductor
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) UIS file \n        {infile}: "; 
char	*l_pstr = 
	"\nEnter: (l) Level of Extraction \n        {integer, 1 to 3}: "; 
char	*b_pstr = 
	"\nEnter: (b) generate program driver? \n        {boolean, (y/n)  [no] }: "; 
char	*f_pstr = 
	"\nEnter: (f) force output? \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "conductor", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "conductor.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "conductor: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "conductor.ans");
		}

	     }

	}

	/*
	 * allocate the conductor structure
	 */
	conductor = (conductor_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (conductor_struct));

	/*
	 * get required arguments for conductor
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(conductor->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(conductor->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(conductor->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    conductor->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(conductor->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(conductor->l_flag = vget_int(fid, prompt_flag,
			"-l", l_pstr, &(conductor->l),
			1, 1, 3)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(conductor->l_flag))
		{
		    fprintf(stderr, "\t\tl is required, please re-enter: \n");
		    conductor->l_flag = vget_int(fid, prompt_flag,
		    "-l", l_pstr, &(conductor->l),
		    1, 1, 3);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-l' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for conductor
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	conductor->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(conductor->b), 0);

	conductor->f_flag = vget_logic(fid, prompt_flag,
	"-f", f_pstr, &(conductor->f), 0);


}



