 /*
  * Khoros: $Id: editimage.h,v 1.5 1992/03/20 22:40:06 dkhoros Exp $
  */

 /*
  * $Log: editimage.h,v $
 * Revision 1.5  1992/03/20  22:40:06  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: editimage.h
 >>>>            Author: Mark Young, Stephanie Hallett, Danielle Argiro
 >>>> Date Last Updated: Fri Mar  6 10:39:14 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _editimage_h_
#define _editimage_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
#include "xvdisplay.h"
#include "xvgraphics.h"
#include "form_info.h"
#include "structs.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    editimage Argument Structure
*
****************************************************************/

typedef struct _editimage  {

/*
 *  input image filename (Optional infile)
 */
char	*i;     	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  overlay image filename (Optional infile)
 */
char	*ov;     	/* overlay image filename FILENAME */
int	 ov_flag;	/* overlay image filename FLAG */

/*
 *  input shape mask filename (Optional infile)
 */
char	*s;     	/* input shape mask filename FILENAME */
int	 s_flag;	/* input shape mask filename FLAG */

/*
 *  input clip mask filename (Optional infile)
 */
char	*c;     	/* input clip mask filename FILENAME */
int	 c_flag;	/* input clip mask filename FLAG */

/*
 *  output ROI filename (Optional outfile)
 */
char	*roi_out     ;	/* output ROI filename FILENAME */
int	 roi_out_flag;	/* output ROI filename FLAG */

/*
 *  x value of upper-left corner of editimage user interface (Optional integer)
 */
int	 x;    	/* x value of upper-left corner of editimage user interface INT */
int	 x_flag;	/* x value of upper-left corner of editimage user interface FLAG */

/*
 *  y value of upper-left corner of editimage user interface (Optional integer)
 */
int	 y;    	/* y value of upper-left corner of editimage user interface INT */
int	 y_flag;	/* y value of upper-left corner of editimage user interface FLAG */

/*
 *  initial zoom factor (Optional float)
 */
float	 zoom;      	/* initial zoom factor FLOAT */
int	 zoom_flag;   	/* initial zoom factor FLAG */

/*
 *  initial update time (Optional float)
 */
float	 update;      	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

/*
 *  host:display.screen (Optional string)
 */
char	*display;       	/* host:display.screen STRING */
int	 display_flag;   	/* host:display.screen FLAG */

/*
 *  editimage form (Optional string)
 */
char	*form;       	/* editimage form STRING */
int	 form_flag;   	/* editimage form FLAG */

/*
 *  image with alternate colormap filename (Optional infile)
 */
char	*cmap_image;     	/* image with alternate colormap filename FILENAME */
int	 cmap_image_flag;	/* image with alternate colormap filename FLAG */

/*
 *  use colormap? (Optional logical)
 */
int	 use_cmap;      	/* use colormap? LOGIC */
int	 use_cmap_flag;  	/* use colormap? FLAG */

}  editimage_struct;

editimage_struct *editimage;

/* -include_additions */

/*
 *  declarations for Xlib variables
 */
GC     gc, gc_xor, gc_invert, gc_set, gc_zoom;
Pixel  white, black, red, green, blue, grey, cyan, magenta, yellow;

XObject   *obj_list;

/*
 *  Colorspace encoding schemes used by Pseudo, Pixels, & Lut
 */
#define RGB     1
#define CMY     2
#define HSV     3
#define HLS     4
#define YIQ     5
#define XYZ     6
#define UVW     7
#define GREY    8

/*
 *   global input & output directories
 */
char *global_indir;
char *global_outdir;

/*
 *  defines for zoom & pixel modes
 */
#define   Continuous_Mode  0
#define   ButtonPress_Mode 1

/*
 *  xvf_form struct
 *  and edit struct
 */     
Display   *display;
xvf_form  *form;
edit edit_info;


/*
 *  Cursors for Zoom
 */
#define NoCursor    0
#define Cross       1
#define Box         2
#define Dot         3

/*
 *  structure holding information about the threshold display
 */
#define Windowing    1
#define Thresholding 2

/*
 *  Types for histogram
 */
#define Continuous 0
#define Filled     1
#define Discrete   2

#define MaxArg 25

int    *ovactive;
int    num_ovbands, num_bands;
struct xvimage *overlays, **ovband;
struct xvimage *images, **band;

DisplayStructure *xvdisplay;
ZoomStructure    *zoom;
PixelStructure   *pixels;
PseudoStructure  *pseudo;
LutStructure     *lut;
ThresStructure   *thres;

void update_zoom();
void redisplay_zoom();

void update_pixels();
void redisplay_pixels();

void update_palette();
void update_pseudo_cont(), update_pseudo_incr();
void update_thres_cont(), update_thres_incr();

void update_lut();
void update_canvas();
void redisplay_lut();


int      index1, index2;
int      lut_width, lut_height, lut_xpos, lut_ypos;
Boolean  active[MAX_PIXELS];

Widget image_workspace;  /* workspace widget for imagedisplay , 
                            defined by (-w) line in editimage.form */

int   update_id;
float update_time;
int   update_file();

Widget create_pseudo_back(), create_color_palette();

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
