(*
This file builds the parser generator. It assumes the standard Isabelle
environment.
*)


use"lib.ML";
use"xgram.ML";
use"syntax_def.ML";
use"lexicon.ML";
use"parse_tree.ML";
use"earley0A.ML";
use"pure_ext.ML";
use"printer.ML";
use"syntax.ML";

structure XGram = XGRAM_FUN(Symtab);
structure Syntax_Def = SYNTAX_DEF_FUN(XGram);
structure Lexicon = LEXICON_FUN(Syntax_Def);
structure Parse_Tree = PARSE_TREE_FUN(Lexicon);
structure Earley0 = EARLY_FUN(structure XGram=XGram and Parse_Tree=Parse_Tree);
structure Pure_Ext = Pure_Ext_Fun(Syntax_Def);
structure Printer = PRINTER_FUN(structure Lexicon=Lexicon and Pretty=Pretty
			and Pure_Ext=Pure_Ext and XGram=XGram);
structure Syntax = SYNTAX_FUN(structure Syntax_Def=Syntax_Def and
	Pure_Ext=Pure_Ext and Parser=Earley0 and Printer=Printer);
