functor MLdependsFun
  (structure Names :NAMES
   structure ErrorMsg :ERRORMSG
   structure MLdependsParser :ARG_PARSER
     sharing type ErrorMsg.pos2complainer = MLdependsParser.arg
     sharing type MLdependsParser.result = Names.names
   structure LexStuff :LEXSTUFF
     sharing LexStuff.ErrorMsg = ErrorMsg
     sharing type LexStuff.pos = ErrorMsg.pos = MLdependsParser.pos = int
     sharing type LexStuff.lexarg = MLdependsParser.lexarg) :MLDEPENDS = struct

structure Names = Names

fun parse (filename :string) :Names.names =
  let val source'stream = open_in filename
      val (complain, parseerror) = ErrorMsg.initialErr filename source'stream
      val lexarg = LexStuff.make'lexarg complain
      val lexer = MLdependsParser.makeLexer (inputc source'stream) lexarg
      val lookahead = 30
      val (names, rest) =
            (MLdependsParser.parse (lookahead, lexer, parseerror, complain))
               handle e => (close_in source'stream; raise e)
  in
    close_in source'stream;
    names
  end

end
