
functor MLdependsLrValsFun
  (structure Token :TOKEN
   structure ErrorMsg :ERRORMSG) :ML_LRVALS = 
struct
structure ParserData=
struct
structure Header = 
struct
val mt = ([],[],[])
fun sigdef (newdef:string) (sigdefs, sigrefs, fundefs) =
  (newdef::sigdefs, sigrefs, fundefs)
fun sigref (newref:string) (sigdefs, sigrefs, fundefs) =
  (sigdefs, newref::sigrefs, fundefs)
fun fundef (newdef:string) (sigdefs, sigrefs, fundefs) =
  (sigdefs, sigrefs, newdef::fundefs)
fun merge (sd0, sr0, fd0) (sd1, sr1, fd1) =
  (sd0@sd1, sr0@sr1, fd0@fd1)

end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\002\000\000\000\013\000\000\000\000\000\
\\001\000\003\000\018\000\013\000\017\000\034\000\016\000\000\000\
\\001\000\003\000\029\000\028\000\028\000\000\000\
\\001\000\003\000\068\000\013\000\017\000\032\000\067\000\034\000\016\000\000\000\
\\001\000\003\000\068\000\013\000\017\000\034\000\016\000\000\000\
\\001\000\003\000\129\000\000\000\
\\001\000\003\000\129\000\004\000\128\000\037\000\127\000\038\000\126\000\000\000\
\\001\000\003\000\145\000\005\000\144\000\000\000\
\\001\000\003\000\145\000\005\000\144\000\039\000\143\000\000\000\
\\001\000\004\000\094\000\000\000\
\\001\000\007\000\013\000\000\000\
\\001\000\009\000\135\000\036\000\155\000\040\000\154\000\000\000\
\\001\000\012\000\085\000\000\000\
\\001\000\012\000\134\000\000\000\
\\001\000\013\000\024\000\000\000\
\\001\000\013\000\098\000\000\000\
\\001\000\013\000\131\000\000\000\
\\001\000\017\000\008\000\029\000\007\000\041\000\006\000\000\000\
\\001\000\018\000\102\000\000\000\
\\001\000\035\000\083\000\000\000\
\\001\000\035\000\096\000\000\000\
\\001\000\035\000\110\000\000\000\
\\001\000\035\000\158\000\000\000\
\\001\000\038\000\025\000\000\000\
\\001\000\039\000\156\000\000\000\
\\001\000\040\000\050\000\000\000\
\\001\000\040\000\112\000\000\000\
\\001\000\040\000\153\000\000\000\
\\171\000\000\000\
\\172\000\000\000\
\\173\000\000\000\
\\173\000\016\000\100\000\000\000\
\\174\000\000\000\
\\175\000\000\000\
\\176\000\000\000\
\\177\000\025\000\056\000\000\000\
\\178\000\000\000\
\\179\000\000\000\
\\180\000\000\000\
\\181\000\000\000\
\\182\000\000\000\
\\183\000\016\000\146\000\000\000\
\\184\000\009\000\135\000\000\000\
\\185\000\000\000\
\\186\000\036\000\157\000\000\000\
\\187\000\000\000\
\\188\000\000\000\
\\189\000\000\000\
\\190\000\000\000\
\\191\000\000\000\
\\192\000\000\000\
\\193\000\000\000\
\\194\000\000\000\
\\195\000\003\000\129\000\034\000\137\000\000\000\
\\196\000\000\000\
\\197\000\009\000\135\000\000\000\
\\198\000\003\000\129\000\034\000\137\000\000\000\
\\199\000\009\000\135\000\036\000\155\000\000\000\
\\200\000\000\000\
\\201\000\000\000\
\\202\000\000\000\
\\203\000\004\000\060\000\038\000\059\000\000\000\
\\204\000\036\000\113\000\000\000\
\\205\000\000\000\
\\206\000\000\000\
\\207\000\008\000\105\000\000\000\
\\208\000\000\000\
\\209\000\010\000\160\000\000\000\
\\210\000\000\000\
\\211\000\024\000\168\000\000\000\
\\212\000\009\000\135\000\000\000\
\\213\000\003\000\068\000\013\000\017\000\034\000\016\000\000\000\
\\214\000\000\000\
\\215\000\005\000\074\000\006\000\073\000\000\000\
\\216\000\000\000\
\\217\000\005\000\074\000\006\000\073\000\000\000\
\\218\000\000\000\
\\219\000\000\000\
\\220\000\003\000\018\000\013\000\017\000\034\000\016\000\000\000\
\\221\000\000\000\
\\222\000\002\000\048\000\003\000\047\000\011\000\046\000\014\000\045\000\
\\015\000\044\000\019\000\043\000\020\000\042\000\021\000\041\000\
\\022\000\040\000\023\000\039\000\026\000\038\000\027\000\037\000\
\\031\000\036\000\032\000\035\000\033\000\034\000\000\000\
\\222\000\002\000\048\000\011\000\046\000\014\000\045\000\015\000\044\000\
\\019\000\043\000\020\000\042\000\021\000\041\000\022\000\040\000\
\\023\000\039\000\026\000\038\000\027\000\037\000\031\000\036\000\
\\032\000\035\000\033\000\034\000\000\000\
\\223\000\000\000\
\\224\000\000\000\
\\225\000\008\000\095\000\000\000\
\\226\000\000\000\
\\227\000\008\000\091\000\000\000\
\\228\000\008\000\091\000\000\000\
\\229\000\008\000\089\000\000\000\
\\230\000\008\000\103\000\000\000\
\\231\000\000\000\
\\232\000\008\000\097\000\000\000\
\\233\000\000\000\
\\234\000\000\000\
\\235\000\000\000\
\\236\000\008\000\095\000\000\000\
\\237\000\000\000\
\\238\000\008\000\091\000\000\000\
\\239\000\000\000\
\\240\000\008\000\089\000\000\000\
\\241\000\009\000\135\000\000\000\
\\242\000\008\000\103\000\000\000\
\\243\000\024\000\104\000\000\000\
\\244\000\009\000\135\000\000\000\
\\245\000\008\000\097\000\000\000\
\\246\000\000\000\
\\247\000\000\000\
\\248\000\013\000\098\000\000\000\
\\249\000\000\000\
\\250\000\000\000\
\\251\000\000\000\
\\252\000\035\000\087\000\000\000\
\\253\000\000\000\
\\254\000\008\000\023\000\000\000\
\\255\000\000\000\
\\000\001\029\000\007\000\041\000\006\000\000\000\
\\001\001\000\000\
\\002\001\002\000\010\000\000\000\
\\003\001\000\000\
\\004\001\008\000\023\000\000\000\
\\005\001\000\000\
\\006\001\000\000\
\\007\001\000\000\
\\008\001\000\000\
\\009\001\007\000\013\000\000\000\
\\010\001\000\000\
\\011\001\017\000\011\000\000\000\
\\012\001\000\000\
\\013\001\000\000\
\"
val actionRowNumbers =
"\017\000\115\000\117\000\126\000\
\\010\000\001\000\001\000\116\000\
\\118\000\001\000\120\000\124\000\
\\119\000\014\000\032\000\033\000\
\\030\000\127\000\023\000\128\000\
\\125\000\001\000\002\000\080\000\
\\113\000\114\000\081\000\109\000\
\\025\000\081\000\122\000\001\000\
\\035\000\061\000\001\000\003\000\
\\004\000\077\000\081\000\075\000\
\\073\000\001\000\001\000\061\000\
\\061\000\019\000\081\000\012\000\
\\111\000\082\000\090\000\078\000\
\\088\000\001\000\034\000\086\000\
\\001\000\009\000\059\000\084\000\
\\020\000\106\000\091\000\015\000\
\\037\000\004\000\031\000\092\000\
\\071\000\018\000\076\000\029\000\
\\028\000\074\000\094\000\089\000\
\\102\000\087\000\065\000\085\000\
\\001\000\002\000\083\000\110\000\
\\123\000\002\000\079\000\035\000\
\\021\000\061\000\098\000\026\000\
\\062\000\001\000\002\000\003\000\
\\004\000\105\000\004\000\072\000\
\\081\000\001\000\006\000\061\000\
\\016\000\121\000\112\000\099\000\
\\006\000\097\000\060\000\009\000\
\\095\000\096\000\104\000\108\000\
\\107\000\036\000\013\000\101\000\
\\103\000\054\000\056\000\051\000\
\\006\000\008\000\045\000\041\000\
\\064\000\035\000\100\000\063\000\
\\093\000\006\000\050\000\006\000\
\\027\000\011\000\024\000\044\000\
\\022\000\047\000\039\000\038\000\
\\005\000\067\000\066\000\001\000\
\\055\000\052\000\053\000\005\000\
\\049\000\006\000\046\000\007\000\
\\006\000\040\000\035\000\069\000\
\\048\000\058\000\057\000\043\000\
\\042\000\068\000\006\000\070\000\
\\000\000"
val gotoT =
"\
\\033\000\003\000\034\000\002\000\035\000\001\000\039\000\168\000\000\000\
\\033\000\007\000\034\000\002\000\035\000\001\000\000\000\
\\000\000\
\\000\000\
\\038\000\010\000\000\000\
\\001\000\013\000\032\000\012\000\000\000\
\\001\000\018\000\037\000\017\000\000\000\
\\000\000\
\\000\000\
\\001\000\018\000\037\000\019\000\000\000\
\\000\000\
\\038\000\020\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\013\000\032\000\024\000\000\000\
\\030\000\025\000\000\000\
\\020\000\031\000\022\000\030\000\023\000\029\000\036\000\028\000\000\000\
\\000\000\
\\000\000\
\\020\000\031\000\022\000\047\000\023\000\029\000\000\000\
\\000\000\
\\000\000\
\\020\000\031\000\022\000\049\000\023\000\029\000\000\000\
\\000\000\
\\001\000\051\000\021\000\050\000\000\000\
\\003\000\053\000\026\000\052\000\000\000\
\\014\000\056\000\025\000\055\000\000\000\
\\001\000\060\000\024\000\059\000\000\000\
\\001\000\064\000\004\000\063\000\028\000\062\000\029\000\061\000\000\000\
\\001\000\064\000\004\000\068\000\005\000\067\000\000\000\
\\000\000\
\\020\000\031\000\022\000\069\000\023\000\029\000\000\000\
\\002\000\070\000\000\000\
\\002\000\073\000\000\000\
\\001\000\074\000\000\000\
\\001\000\076\000\027\000\075\000\000\000\
\\014\000\056\000\025\000\077\000\000\000\
\\014\000\080\000\016\000\079\000\017\000\078\000\000\000\
\\000\000\
\\020\000\031\000\022\000\082\000\023\000\029\000\000\000\
\\000\000\
\\031\000\084\000\000\000\
\\000\000\
\\000\000\
\\001\000\051\000\021\000\086\000\000\000\
\\000\000\
\\001\000\088\000\000\000\
\\000\000\
\\000\000\
\\001\000\090\000\000\000\
\\015\000\091\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\064\000\004\000\063\000\029\000\097\000\000\000\
\\000\000\
\\000\000\
\\001\000\064\000\004\000\068\000\005\000\099\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\104\000\000\000\
\\030\000\105\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\030\000\106\000\000\000\
\\000\000\
\\003\000\053\000\026\000\107\000\000\000\
\\000\000\
\\014\000\056\000\025\000\109\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\060\000\024\000\112\000\000\000\
\\030\000\113\000\000\000\
\\001\000\064\000\004\000\063\000\028\000\114\000\029\000\061\000\000\000\
\\001\000\064\000\004\000\116\000\029\000\115\000\000\000\
\\000\000\
\\001\000\064\000\004\000\117\000\000\000\
\\000\000\
\\020\000\031\000\022\000\118\000\023\000\029\000\000\000\
\\001\000\076\000\027\000\119\000\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\120\000\000\000\
\\014\000\080\000\016\000\128\000\017\000\078\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\130\000\000\000\
\\000\000\
\\000\000\
\\015\000\131\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\134\000\000\000\
\\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\137\000\
\\013\000\136\000\000\000\
\\006\000\140\000\008\000\139\000\009\000\138\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\147\000\018\000\146\000\019\000\145\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\148\000\000\000\
\\000\000\
\\007\000\123\000\010\000\150\000\011\000\149\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\157\000\000\000\
\\000\000\
\\000\000\
\\001\000\159\000\000\000\
\\000\000\
\\000\000\
\\007\000\134\000\000\000\
\\007\000\160\000\000\000\
\\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\162\000\
\\013\000\161\000\000\000\
\\000\000\
\\006\000\140\000\008\000\139\000\009\000\163\000\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\164\000\000\000\
\\000\000\
\\003\000\147\000\018\000\165\000\019\000\145\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\007\000\123\000\010\000\122\000\011\000\121\000\012\000\167\000\000\000\
\\000\000\
\\000\000\
\"
val numstates = 169
val numrules = 99
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.arrayoflist(actionRows) in fn i=>Array.sub(a,i) end
in Array.arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = pos*pos -> ErrorMsg.severity -> string -> unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | STRING of  (string)
 | INT0 of  (int) | INT of  (int) | TYVAR of  (string)
 | ID of  (string)
 | interdec of  (string list*string list*string list)
 | importdec of  (unit)
 | fctb of  (string list*string list*string list)
 | fparam of  (string list*string list*string list)
 | sdec' of  (string list*string list*string list)
 | sdec of  (string list*string list*string list)
 | sdecs of  (string list*string list*string list)
 | sigb of  (string list*string list*string list)
 | sigconstraint_op of  (string list*string list*string list)
 | sign of  (string list*string list*string list) | patheqn of  (unit)
 | sharespec of  (unit) | exnspec of  (unit) | valspec of  (unit)
 | tyspec of  (unit)
 | strspec of  (string list*string list*string list)
 | spec of  (string list*string list*string list)
 | spec_s of  (string list*string list*string list) | ops of  (unit)
 | fixity of  (unit) | constr of  (unit) | constrs of  (unit)
 | db' of  (unit) | db of  (unit) | tyvar_pc of  (unit)
 | tyvars of  (unit) | ty0_pc of  (unit) | ty of  (unit)
 | tuple_ty of  (unit) | ty' of  (unit) | tlabels of  (unit)
 | tlabel of  (unit) | tycon of  (unit) | selector of  (unit)
 | qid_p0 of  (unit) | qid of  (unit) | op_op of  (unit)
 | int of  (unit) | ident of  (string)
end
type svalue = MlyValue.svalue
type result = string list*string list*string list
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 40) => true | (T 32) => true | (T 31) => true | (T 30) => true
 | (T 28) => true | (T 27) => true | (T 26) => true | (T 25) => true
 | (T 24) => true | (T 23) => true | (T 22) => true | (T 21) => true
 | (T 20) => true | (T 19) => true | (T 18) => true | (T 17) => true
 | (T 16) => true | (T 14) => true | (T 13) => true | (T 11) => true
 | (T 10) => true | (T 7) => true | _ => false
val preferred_insert =
fn (T 32) => true | _ => false
val preferred_subst =
fn (T 1) =>(T 35)::nil
|(T 34) =>(T 23)::nil
|(T 35) =>(T 1)::nil
| _ => nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "SEMICOLON"
  | (T 2) => "ID"
  | (T 3) => "TYVAR"
  | (T 4) => "INT"
  | (T 5) => "INT0"
  | (T 6) => "STRING"
  | (T 7) => "AND"
  | (T 8) => "ARROW"
  | (T 9) => "BAR"
  | (T 10) => "DATATYPE"
  | (T 11) => "END"
  | (T 12) => "EQUAL"
  | (T 13) => "EQTYPE"
  | (T 14) => "EXCEPTION"
  | (T 15) => "DOT"
  | (T 16) => "FUNCTOR"
  | (T 17) => "IN"
  | (T 18) => "INCLUDE"
  | (T 19) => "INFIX"
  | (T 20) => "INFIXR"
  | (T 21) => "LOCAL"
  | (T 22) => "NONFIX"
  | (T 23) => "OF"
  | (T 24) => "OP"
  | (T 25) => "OPEN"
  | (T 26) => "SHARING"
  | (T 27) => "SIG"
  | (T 28) => "SIGNATURE"
  | (T 29) => "STRUCT"
  | (T 30) => "STRUCTURE"
  | (T 31) => "TYPE"
  | (T 32) => "VAL"
  | (T 33) => "ASTERISK"
  | (T 34) => "COLON"
  | (T 35) => "COMMA"
  | (T 36) => "LBRACE"
  | (T 37) => "LPAREN"
  | (T 38) => "RBRACE"
  | (T 39) => "RPAREN"
  | (T 40) => "IMPORT"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 2) => MlyValue.ID(("bogus")) | 
(T 3) => MlyValue.TYVAR(("'bogus")) | 
(T 4) => MlyValue.INT((1)) | 
(T 5) => MlyValue.INT0((0)) | 
(T 6) => MlyValue.STRING(("")) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 7) :: (T 8) :: (T 9) :: (T 10) :: (T 
11) :: (T 12) :: (T 13) :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 
18) :: (T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 
25) :: (T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 
32) :: (T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37) :: (T 38) :: (T 
39) :: (T 40) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (error):arg) =>
case (i392,stack)
of (0,(_,(_,INT1left,INT1right))::rest671) => let val result=
MlyValue.int(())
 in (LrTable.NT 1,(result,INT1left,INT1right),rest671) end
| (1,(_,(_,INT01left,INT01right))::rest671) => let val result=
MlyValue.int(())
 in (LrTable.NT 1,(result,INT01left,INT01right),rest671) end
| (2,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.ident((ID))
 in (LrTable.NT 0,(result,ID1left,ID1right),rest671) end
| (3,(_,(_,ASTERISK1left,ASTERISK1right))::rest671) => let val result=
MlyValue.ident(("*"))
 in (LrTable.NT 0,(result,ASTERISK1left,ASTERISK1right),rest671) end
| (4,(_,(_,EQUAL1left,EQUAL1right))::rest671) => let val result=
MlyValue.ident(("="))
 in (LrTable.NT 0,(result,EQUAL1left,EQUAL1right),rest671) end
| (5,(_,(_,OP1left,OP1right))::rest671) => let val result=
MlyValue.op_op(())
 in (LrTable.NT 2,(result,OP1left,OP1right),rest671) end
| (6,rest671) => let val result=MlyValue.op_op(())
 in (LrTable.NT 2,(result,defaultPos,defaultPos),rest671) end
| (7,(_,(_,_,qid1right))::_::(_,(_,ID1left,_))::rest671) => let val 
result=MlyValue.qid(())
 in (LrTable.NT 3,(result,ID1left,qid1right),rest671) end
| (8,(_,(_,ident1left,ident1right))::rest671) => let val result=
MlyValue.qid(())
 in (LrTable.NT 3,(result,ident1left,ident1right),rest671) end
| (9,(_,(_,ID1left,ID1right))::rest671) => let val result=
MlyValue.selector(())
 in (LrTable.NT 5,(result,ID1left,ID1right),rest671) end
| (10,(_,(_,INT1left,INT1right))::rest671) => let val result=
MlyValue.selector(())
 in (LrTable.NT 5,(result,INT1left,INT1right),rest671) end
| (11,(_,(_,_,tycon1right))::_::(_,(_,ID1left,_))::rest671) => let 
val result=MlyValue.tycon(())
 in (LrTable.NT 6,(result,ID1left,tycon1right),rest671) end
| (12,(_,(_,ID1left,ID1right))::rest671) => let val result=
MlyValue.tycon(())
 in (LrTable.NT 6,(result,ID1left,ID1right),rest671) end
| (13,(_,(_,_,ty1right))::_::(_,(_,selector1left,_))::rest671) => let 
val result=MlyValue.tlabel(())
 in (LrTable.NT 7,(result,selector1left,ty1right),rest671) end
| (14,(_,(_,_,tlabels1right))::_::(_,(_,tlabel1left,_))::rest671) => 
let val result=MlyValue.tlabels(())
 in (LrTable.NT 8,(result,tlabel1left,tlabels1right),rest671) end
| (15,(_,(_,tlabel1left,tlabel1right))::rest671) => let val result=
MlyValue.tlabels(())
 in (LrTable.NT 8,(result,tlabel1left,tlabel1right),rest671) end
| (16,(_,(_,TYVAR1left,TYVAR1right))::rest671) => let val result=
MlyValue.ty'(())
 in (LrTable.NT 9,(result,TYVAR1left,TYVAR1right),rest671) end
| (17,(_,(_,_,RBRACE1right))::_::(_,(_,LBRACE1left,_))::rest671) => 
let val result=MlyValue.ty'(())
 in (LrTable.NT 9,(result,LBRACE1left,RBRACE1right),rest671) end
| (18,(_,(_,_,RBRACE1right))::(_,(_,LBRACE1left,_))::rest671) => let 
val result=MlyValue.ty'(())
 in (LrTable.NT 9,(result,LBRACE1left,RBRACE1right),rest671) end
| (19,(_,(_,_,tycon1right))::_::_::(_,(_,LPAREN1left,_))::rest671) => 
let val result=MlyValue.ty'(())
 in (LrTable.NT 9,(result,LPAREN1left,tycon1right),rest671) end
| (20,(_,(_,_,RPAREN1right))::_::(_,(_,LPAREN1left,_))::rest671) => 
let val result=MlyValue.ty'(())
 in (LrTable.NT 9,(result,LPAREN1left,RPAREN1right),rest671) end
| (21,(_,(_,_,tycon1right))::(_,(_,ty'1left,_))::rest671) => let val 
result=MlyValue.ty'(())
 in (LrTable.NT 9,(result,ty'1left,tycon1right),rest671) end
| (22,(_,(_,tycon1left,tycon1right))::rest671) => let val result=
MlyValue.ty'(())
 in (LrTable.NT 9,(result,tycon1left,tycon1right),rest671) end
| (23,(_,(_,_,tuple_ty1right))::_::(_,(_,ty'1left,_))::rest671) => 
let val result=MlyValue.tuple_ty(())
 in (LrTable.NT 10,(result,ty'1left,tuple_ty1right),rest671) end
| (24,(_,(_,_,ty'2right))::_::(_,(_,ty'1left,_))::rest671) => let val 
result=MlyValue.tuple_ty(())
 in (LrTable.NT 10,(result,ty'1left,ty'2right),rest671) end
| (25,(_,(_,tuple_ty1left,tuple_ty1right))::rest671) => let val result
=MlyValue.ty(())
 in (LrTable.NT 11,(result,tuple_ty1left,tuple_ty1right),rest671) end
| (26,(_,(_,_,ty2right))::_::(_,(_,ty1left,_))::rest671) => let val 
result=MlyValue.ty(())
 in (LrTable.NT 11,(result,ty1left,ty2right),rest671) end
| (27,(_,(_,ty'1left,ty'1right))::rest671) => let val result=
MlyValue.ty(())
 in (LrTable.NT 11,(result,ty'1left,ty'1right),rest671) end
| (28,(_,(_,_,ty2right))::_::(_,(_,ty1left,_))::rest671) => let val 
result=MlyValue.ty0_pc(())
 in (LrTable.NT 12,(result,ty1left,ty2right),rest671) end
| (29,(_,(_,_,ty0_pc1right))::_::(_,(_,ty1left,_))::rest671) => let 
val result=MlyValue.ty0_pc(())
 in (LrTable.NT 12,(result,ty1left,ty0_pc1right),rest671) end
| (30,(_,(_,TYVAR1left,TYVAR1right))::rest671) => let val result=
MlyValue.tyvars(())
 in (LrTable.NT 13,(result,TYVAR1left,TYVAR1right),rest671) end
| (31,(_,(_,_,RPAREN1right))::_::(_,(_,LPAREN1left,_))::rest671) => 
let val result=MlyValue.tyvars(())
 in (LrTable.NT 13,(result,LPAREN1left,RPAREN1right),rest671) end
| (32,rest671) => let val result=MlyValue.tyvars(())
 in (LrTable.NT 13,(result,defaultPos,defaultPos),rest671) end
| (33,(_,(_,TYVAR1left,TYVAR1right))::rest671) => let val result=
MlyValue.tyvar_pc(())
 in (LrTable.NT 14,(result,TYVAR1left,TYVAR1right),rest671) end
| (34,(_,(_,_,tyvar_pc1right))::_::(_,(_,TYVAR1left,_))::rest671) => 
let val result=MlyValue.tyvar_pc(())
 in (LrTable.NT 14,(result,TYVAR1left,tyvar_pc1right),rest671) end
| (35,(_,(_,_,db1right))::_::(_,(_,db'1left,_))::rest671) => let val 
result=MlyValue.db(())
 in (LrTable.NT 15,(result,db'1left,db1right),rest671) end
| (36,(_,(_,db'1left,db'1right))::rest671) => let val result=
MlyValue.db(())
 in (LrTable.NT 15,(result,db'1left,db'1right),rest671) end
| (37,(_,(_,_,constrs1right))::_::_::(_,(_,tyvars1left,_))::rest671)
 => let val result=MlyValue.db'(())
 in (LrTable.NT 16,(result,tyvars1left,constrs1right),rest671) end
| (38,(_,(_,constr1left,constr1right))::rest671) => let val result=
MlyValue.constrs(())
 in (LrTable.NT 17,(result,constr1left,constr1right),rest671) end
| (39,(_,(_,_,constrs1right))::_::(_,(_,constr1left,_))::rest671) => 
let val result=MlyValue.constrs(())
 in (LrTable.NT 17,(result,constr1left,constrs1right),rest671) end
| (40,(_,(_,_,ident1right))::(_,(_,op_op1left,_))::rest671) => let 
val result=MlyValue.constr(())
 in (LrTable.NT 18,(result,op_op1left,ident1right),rest671) end
| (41,(_,(_,_,ty1right))::_::_::(_,(_,op_op1left,_))::rest671) => let 
val result=MlyValue.constr(())
 in (LrTable.NT 18,(result,op_op1left,ty1right),rest671) end
| (42,(_,(_,qid1left,qid1right))::rest671) => let val result=
MlyValue.qid_p0(())
 in (LrTable.NT 4,(result,qid1left,qid1right),rest671) end
| (43,(_,(_,_,qid_p01right))::(_,(_,qid1left,_))::rest671) => let val 
result=MlyValue.qid_p0(())
 in (LrTable.NT 4,(result,qid1left,qid_p01right),rest671) end
| (44,(_,(_,INFIX1left,INFIX1right))::rest671) => let val result=
MlyValue.fixity(())
 in (LrTable.NT 19,(result,INFIX1left,INFIX1right),rest671) end
| (45,(_,(_,_,int1right))::(_,(_,INFIX1left,_))::rest671) => let val 
result=MlyValue.fixity(())
 in (LrTable.NT 19,(result,INFIX1left,int1right),rest671) end
| (46,(_,(_,INFIXR1left,INFIXR1right))::rest671) => let val result=
MlyValue.fixity(())
 in (LrTable.NT 19,(result,INFIXR1left,INFIXR1right),rest671) end
| (47,(_,(_,_,int1right))::(_,(_,INFIXR1left,_))::rest671) => let val 
result=MlyValue.fixity(())
 in (LrTable.NT 19,(result,INFIXR1left,int1right),rest671) end
| (48,(_,(_,NONFIX1left,NONFIX1right))::rest671) => let val result=
MlyValue.fixity(())
 in (LrTable.NT 19,(result,NONFIX1left,NONFIX1right),rest671) end
| (49,(_,(_,ident1left,ident1right))::rest671) => let val result=
MlyValue.ops(())
 in (LrTable.NT 20,(result,ident1left,ident1right),rest671) end
| (50,(_,(_,_,ops1right))::(_,(_,ident1left,_))::rest671) => let val 
result=MlyValue.ops(())
 in (LrTable.NT 20,(result,ident1left,ops1right),rest671) end
| (51,rest671) => let val result=MlyValue.spec_s((mt))
 in (LrTable.NT 21,(result,defaultPos,defaultPos),rest671) end
| (52,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(MlyValue.spec 
spec,spec1left,_))::rest671) => let val result=MlyValue.spec_s((
merge spec spec_s))
 in (LrTable.NT 21,(result,spec1left,spec_s1right),rest671) end
| (53,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(_,
SEMICOLON1left,_))::rest671) => let val result=MlyValue.spec_s((spec_s
))
 in (LrTable.NT 21,(result,SEMICOLON1left,spec_s1right),rest671) end
| (54,(_,(MlyValue.strspec strspec,_,strspec1right))::(_,(_,
STRUCTURE1left,_))::rest671) => let val result=MlyValue.spec((strspec)
)
 in (LrTable.NT 22,(result,STRUCTURE1left,strspec1right),rest671) end
| (55,(_,(_,_,db1right))::(_,(_,DATATYPE1left,_))::rest671) => let 
val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,DATATYPE1left,db1right),rest671) end
| (56,(_,(_,_,tyspec1right))::(_,(_,TYPE1left,_))::rest671) => let 
val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,TYPE1left,tyspec1right),rest671) end
| (57,(_,(_,_,tyspec1right))::(_,(_,EQTYPE1left,_))::rest671) => let 
val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,EQTYPE1left,tyspec1right),rest671) end
| (58,(_,(_,_,valspec1right))::(_,(_,VAL1left,_))::rest671) => let 
val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,VAL1left,valspec1right),rest671) end
| (59,(_,(_,_,exnspec1right))::(_,(_,EXCEPTION1left,_))::rest671) => 
let val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,EXCEPTION1left,exnspec1right),rest671) end
| (60,(_,(_,_,ops1right))::(_,(_,fixity1left,_))::rest671) => let val 
result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,fixity1left,ops1right),rest671) end
| (61,(_,(_,_,sharespec1right))::(_,(_,SHARING1left,_))::rest671) => 
let val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,SHARING1left,sharespec1right),rest671) end
| (62,(_,(_,_,qid_p01right))::(_,(_,OPEN1left,_))::rest671) => let 
val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,OPEN1left,qid_p01right),rest671) end
| (63,(_,(_,_,END1right))::_::_::_::(_,(_,LOCAL1left,_))::rest671) => 
let val result=MlyValue.spec((mt))
 in (LrTable.NT 22,(result,LOCAL1left,END1right),rest671) end
| (64,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,INCLUDE1left,_))
::rest671) => let val result=MlyValue.spec((sigref ident mt))
 in (LrTable.NT 22,(result,INCLUDE1left,ident1right),rest671) end
| (65,(_,(MlyValue.strspec strspec2,_,strspec2right))::_::(_,(
MlyValue.strspec strspec1,strspec1left,_))::rest671) => let val result
=MlyValue.strspec((merge strspec1 strspec2))
 in (LrTable.NT 23,(result,strspec1left,strspec2right),rest671) end
| (66,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(_,ident1left,_))::
rest671) => let val result=MlyValue.strspec((sign))
 in (LrTable.NT 23,(result,ident1left,sign1right),rest671) end
| (67,(_,(_,_,tyspec2right))::_::(_,(_,tyspec1left,_))::rest671) => 
let val result=MlyValue.tyspec(())
 in (LrTable.NT 24,(result,tyspec1left,tyspec2right),rest671) end
| (68,(_,(_,_,ident1right))::(_,(_,tyvars1left,_))::rest671) => let 
val result=MlyValue.tyspec(())
 in (LrTable.NT 24,(result,tyvars1left,ident1right),rest671) end
| (69,(_,(_,_,valspec2right))::_::(_,(_,valspec1left,_))::rest671) => 
let val result=MlyValue.valspec(())
 in (LrTable.NT 25,(result,valspec1left,valspec2right),rest671) end
| (70,(_,(_,_,ty1right))::_::_::(_,(_,op_op1left,_))::rest671) => let 
val result=MlyValue.valspec(())
 in (LrTable.NT 25,(result,op_op1left,ty1right),rest671) end
| (71,(_,(_,_,exnspec2right))::_::(_,(_,exnspec1left,_))::rest671) => 
let val result=MlyValue.exnspec(())
 in (LrTable.NT 26,(result,exnspec1left,exnspec2right),rest671) end
| (72,(_,(_,ident1left,ident1right))::rest671) => let val result=
MlyValue.exnspec(())
 in (LrTable.NT 26,(result,ident1left,ident1right),rest671) end
| (73,(_,(_,_,ty1right))::_::(_,(_,ident1left,_))::rest671) => let 
val result=MlyValue.exnspec(())
 in (LrTable.NT 26,(result,ident1left,ty1right),rest671) end
| (74,(_,(_,_,sharespec2right))::_::(_,(_,sharespec1left,_))::rest671)
 => let val result=MlyValue.sharespec(())
 in (LrTable.NT 27,(result,sharespec1left,sharespec2right),rest671)
 end
| (75,(_,(_,_,patheqn1right))::(_,(_,TYPE1left,_))::rest671) => let 
val result=MlyValue.sharespec(())
 in (LrTable.NT 27,(result,TYPE1left,patheqn1right),rest671) end
| (76,(_,(_,patheqn1left,patheqn1right))::rest671) => let val result=
MlyValue.sharespec(())
 in (LrTable.NT 27,(result,patheqn1left,patheqn1right),rest671) end
| (77,(_,(_,_,qid2right))::_::(_,(_,qid1left,_))::rest671) => let val 
result=MlyValue.patheqn(())
 in (LrTable.NT 28,(result,qid1left,qid2right),rest671) end
| (78,(_,(_,_,patheqn1right))::_::(_,(_,qid1left,_))::rest671) => let 
val result=MlyValue.patheqn(())
 in (LrTable.NT 28,(result,qid1left,patheqn1right),rest671) end
| (79,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.sign((sigref ID mt))
 in (LrTable.NT 29,(result,ID1left,ID1right),rest671) end
| (80,(_,(_,_,END1right))::(_,(MlyValue.spec_s spec_s,_,_))::(_,(_,
SIG1left,_))::rest671) => let val result=MlyValue.sign((spec_s))
 in (LrTable.NT 29,(result,SIG1left,END1right),rest671) end
| (81,rest671) => let val result=MlyValue.sigconstraint_op((mt))
 in (LrTable.NT 30,(result,defaultPos,defaultPos),rest671) end
| (82,(_,(MlyValue.sign sign,_,sign1right))::(_,(_,COLON1left,_))::
rest671) => let val result=MlyValue.sigconstraint_op((sign))
 in (LrTable.NT 30,(result,COLON1left,sign1right),rest671) end
| (83,(_,(MlyValue.sigb sigb2,_,sigb2right))::_::(_,(MlyValue.sigb 
sigb1,sigb1left,_))::rest671) => let val result=MlyValue.sigb((
merge sigb1 sigb2))
 in (LrTable.NT 31,(result,sigb1left,sigb2right),rest671) end
| (84,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ident 
ident,ident1left,_))::rest671) => let val result=MlyValue.sigb((
sigdef ident sign))
 in (LrTable.NT 31,(result,ident1left,sign1right),rest671) end
| (85,(_,(MlyValue.sdec' sdec',sdec'1left,sdec'1right))::rest671) => 
let val result=MlyValue.sdecs((sdec'))
 in (LrTable.NT 32,(result,sdec'1left,sdec'1right),rest671) end
| (86,(_,(MlyValue.sdecs sdecs,_,sdecs1right))::(_,(MlyValue.sdec' 
sdec',sdec'1left,_))::rest671) => let val result=MlyValue.sdecs((
merge sdec' sdecs))
 in (LrTable.NT 32,(result,sdec'1left,sdecs1right),rest671) end
| (87,(_,(MlyValue.sdec sdec,sdec1left,sdec1right))::rest671) => let 
val result=MlyValue.sdec'((sdec))
 in (LrTable.NT 34,(result,sdec1left,sdec1right),rest671) end
| (88,(_,(_,_,SEMICOLON1right))::(_,(MlyValue.sdec sdec,sdec1left,_))
::rest671) => let val result=MlyValue.sdec'((sdec))
 in (LrTable.NT 34,(result,sdec1left,SEMICOLON1right),rest671) end
| (89,(_,(MlyValue.sigb sigb,_,sigb1right))::(_,(_,SIGNATURE1left,_))
::rest671) => let val result=MlyValue.sdec((sigb))
 in (LrTable.NT 33,(result,SIGNATURE1left,sigb1right),rest671) end
| (90,(_,(_,_,importdec1right))::(_,(_,IMPORT1left,_))::rest671) => 
let val result=MlyValue.sdec((mt))
 in (LrTable.NT 33,(result,IMPORT1left,importdec1right),rest671) end
| (91,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(_,ID1left,_))::
rest671) => let val result=MlyValue.fparam((sign))
 in (LrTable.NT 35,(result,ID1left,sign1right),rest671) end
| (92,(_,(MlyValue.spec_s spec_s,spec_s1left,spec_s1right))::rest671)
 => let val result=MlyValue.fparam((spec_s))
 in (LrTable.NT 35,(result,spec_s1left,spec_s1right),rest671) end
| (93,(_,(MlyValue.sigconstraint_op sigconstraint_op,_,
sigconstraint_op1right))::_::(_,(MlyValue.fparam fparam,_,_))::_::(_,(
MlyValue.ident ident,ident1left,_))::rest671) => let val result=
MlyValue.fctb((fundef ident (merge sigconstraint_op fparam)))
 in (LrTable.NT 36,(result,ident1left,sigconstraint_op1right),rest671)
 end
| (94,(_,(_,STRING1left,STRING1right))::rest671) => let val result=
MlyValue.importdec(())
 in (LrTable.NT 37,(result,STRING1left,STRING1right),rest671) end
| (95,(_,(_,_,importdec1right))::(_,(_,STRING1left,_))::rest671) => 
let val result=MlyValue.importdec(())
 in (LrTable.NT 37,(result,STRING1left,importdec1right),rest671) end
| (96,(_,(MlyValue.sdecs sdecs,sdecs1left,sdecs1right))::rest671) => 
let val result=MlyValue.interdec((sdecs))
 in (LrTable.NT 38,(result,sdecs1left,sdecs1right),rest671) end
| (97,(_,(MlyValue.fctb fctb,_,fctb1right))::(_,(_,FUNCTOR1left,_))::
rest671) => let val result=MlyValue.interdec((fctb))
 in (LrTable.NT 38,(result,FUNCTOR1left,fctb1right),rest671) end
| (98,(_,(MlyValue.fctb fctb,_,fctb1right))::_::(_,(MlyValue.sdecs 
sdecs,sdecs1left,_))::rest671) => let val result=MlyValue.interdec((
merge fctb sdecs))
 in (LrTable.NT 38,(result,sdecs1left,fctb1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.interdec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.ID i,p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.TYVAR i,p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.INT i,p1,p2))
fun INT0 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.INT0 i,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.STRING i,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
end
end
