# sel.tcl --
# Bindings for keypad-based cut and paste
# Copyright (c) 1995 by Sun Microsystems
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc Sel_Init {win} {
    # Set up handler for PRIMARY selection
    selection handle $win [list Output_selection $win]
}

proc SelCopy {win} {
    if [catch {$win index sel.first}] {
	Status $win "No selection to copy"
	return
    }
    Feedback $win "copy"
    if [catch {selection get} html] {
	Status $win "No selection to copy"
    } else {
	clipboard clear
	clipboard append $html
    }
    Feedback $win "ready"
}
proc SelCut {win} {
    if [catch {$win index sel.first}] {
	return
    }
    SelCopy $win
    Edit_Delete $win
}
proc SelPaste {win} {
    if [catch {
	Edit_PasteHtml $win [SelGet $win 1]
    } err] {
	Status $win $err
    }
}
proc SelGet {w {clipboard 0}} {
    set other [selection own -displayof $w]
    if {$other == $w} {
	# Intra-widow paste - do no URL conversions
	if [catch {$w index sel.first} first] {
	    if {$clipboard} {
		return [selection get -selection CLIPBOARD]
	    }
	    error "No selection"
	}
	return [Output_string $w $first [$w index sel.last]]
    } else {
	# Get the selection from another application
	if [catch {selection get} html] {
	    if {$clipboard} {
		return [selection get -selection CLIPBOARD]
	    } else {
		error "No selection"
	    }
	} else {
	    return $html
	}
    }
}
proc Sel_PasteText {win} {
    if ![catch { SelGet $win 1} text] {
	Undo_Mark $win PasteText
	Edit_PasteHtml $win [Edit_ConvertPlainText $text]
	Undo_Mark $win PasteTextEnd
    }
}
