#
 ! floating point => integer conversion routines
 !-----------------------------------------------------------------------------
 ! ported to 68000 by Kai-Uwe Bloem, 12/89
 !  #1  original author: Peter S. Housel 6/12/89,6/14/89
 !  #2  replaced shifts by swap if possible for speed increase	-kub-, 01/90
 !  #3  Added wrapper routine to provide C68 IEEE compatibility
 !						Dave & Keith Walker	02/92
 !-----------------------------------------------------------------------------

	.sect .text

#ifndef NOACK
	.define .cfi
#endif /* NOACK */
#ifndef NOC68
	.define	.sftol
	.define	.dftol
#endif /* NOC68 */

BIAS4	=	0x7F - 1
BIAS8	=	0x3FF - 1

REGS	=	4*4			! Size of registers saved

!----------------------------------------
!	C68 wrapper routines
!
!	sp	Return address
!	sp+4	address of float/double
!----------------------------------------
#ifndef NOC68
.dftol:
	move.l  #8,d0			! source size (double)
	bra	label

.sftol:
	move.l	#4,d0			! source size (float)
label:
	sub.l	#12,sp			! make space to set up stack to ACK style
	pea	tidyc68			! set return address for wrapper code
	move.w	#4,4(sp)		! destination size
	move.w	d0,6(sp)		! source size
	move.l	12+4+4(sp),a1		! address of passed value
	movem.l	(a1),d0/d1		! get it
	movem.l	d0/d1,8(sp)		! ... and set value where ACK puts it!
	bra	shared			! join ACK code

!	Exit code for C68
!	(exception in that does NOT tidy stack !

tidyc68:
	lea	12(sp),sp	! remove workspace from stack
	rts
#endif /* NOC68 */

!-----------------------------------------------
!	Entry point for ACK
!
!		sp	Return address
!		sp+4	(word) target size
!		sp+6	(word) source size
!		sp+8	floating point number
!-----------------------------------------------
#ifndef NOACK
.cfi:
#endif /* NOACK */
!-----------------------------------------------
!	The code from here is common to the
!	ACK and C68 compilers.
!-----------------------------------------------
shared:
	move.w	6(sp),d0
	cmp.w	#4,d0
	bne	cfi8
cfi4:
	move.w	8(sp),d0	! extract exp
	move.w	d0,d2		! extract sign
	lsr.w	#7,d0		! shift down 7
	and.w	#0x0ff,d0	! kill sign bit

	move.w	d2,d1
	and.w	#0x7f,d1	! remove exponent from mantissa
	or.w	#0x80,d1	! restore implied leading "1"
	move.w	d1,8(sp)

	cmp.w	#BIAS4,d0	! check exponent
	blt	zer4		! strictly fractional, no integer part ?
	cmp.w	#BIAS4+32,d0	! is it too big to fit in a 32-bit integer ?
	bgt	toobig

	move.l	8(sp),d1
	sub.w	#BIAS4+24,d0	! adjust exponent
	bgt	2f		! shift up
	beq	3f		! no shift

	cmp.w	#-8,d0		! replace far shifts by swap
	bgt	1f
	clr.w	d1		! shift fast, 16 bits
	swap	d1
	add.w	#16,d0		! account for swap
	bgt	2f
	beq	3f

1:	lsr.l	#1,d1		! shift down to align radix point;
	add.w	#1,d0		! extra bits fall off the end (no rounding)
	blt	1b		! shifted all the way down yet ?
	bra	3f

2:	add.l	d1,d1		! shift up to align radix point
	sub.w	#1,d0
	bgt	2b
	bra	3f
zer4:
	clr.l	d1		! make the whole thing zero
3:	move.l	d1,8(sp)
	bra	cfi8b		! amazingly, we can share the rest of the code

cfi8:
	cmp.w	#8,d0
	bne	ill		! ill)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  