/*
	This module assumes that floating point numbers are in
	Motorola FastFloatingPointFormat format.
*/

#include <math.h>

/*
	The function |frexp()| splits a floating-point number into
	fraction |f| and an exponent |n|, such that the absolute
	value of |f| is less than 1.0 but not less than 0.5 and such
	that |f| times 2 raised to the power |n| is equal to |x|.
	The fraction |f| is returned and as a side effect the exponent
	|n| is stored into the place pointed to by |nptr|.  If the
	argument to |frexp()| is zero then both returned values
	will be zero.
*/

double
frexp (x, nptr)
	double	x;
	int *	nptr;
{
	long *	mptr = &x;

	if (*mptr == 0) {
		*nptr = 0;
		return ((double) 0);
	}

	*nptr = (*mptr & 0x7f) - 0x40;
	*mptr = (*mptr & ~0x7f) | 0x40;		/* this changes x */
	return (x);
}
