.\" ms(7) manpage by rosenkra@convex.com (Bill Rosenkranz, 7/22/90)
.\"
.TH MS 7
.SH NAME
ms - text formatting macros
.SH SYNOPSIS
nroff  -ms  [ options ]  file  ...
.SH DESCRIPTION
This package of nroff macro definitions provides a
formatting facility for various styles of articles, theses, and books.
All external -ms macros are defined below.
.PP
Note that this -ms macro package is a subset of the complete ms package
since nroff(1) is not quite up to it yet.
Still, it supports most of what is normally used, including the table
of contents macros.
.PP
Some nroff requests may be unsafe in conjunction with this package.
However, the first four requests below may be used with impunity after
initialization, and the last two may be used even before initialization:
.nf

	.bp    begin new page
	.br    break output line
	.sp n  insert n spacing lines
	.ce n  center next n lines

	.ls n  line spacing: n=1 single, n=2 double space
	.na    no alignment of right margin

.fi
Font changes with \f are also allowed;
for example, '\\fIword\\fR' will italicize word.
.SH FILES
.ec |
\lib\tmac\tmac.s
.ec \
.SH REQUESTS
.nf
.cc +
Macro   Initial   Break?   Explanation
Name    Value     Reset?
.AB x   -         y      begin abstract; if x=no don't label abstract
.AE     -         y      end abstract
.AI     -         y      author's institution, centered
.AU     -         y      author's name, centered
.B x    -         n      embolden x; if no x, switch to boldface
.I x    -         n      italicize x; if no x, switch to italics
.IP x   -         y,y    indented paragraph, with hanging tag x
.LP     -         y,y    left (block) paragraph.
.NH x   -         y,y    numbered header; x=level, x=0 resets
.PP     -         y,y    paragraph with first line indented
.QP     -         y,y    quoted paragraph (indented, shorter)
.R      on        n      return to Roman font
.RE     -         y,y    end level of relative indentation
.RS     5n        y,y    right shift: start level of relative indent
.SH     -         y,y    section header, no numbering
.TL     -         y      title, centered
.XP     -         y,y    extended paragraph (biblio entry)
.XS p   -         y      begin index entry, p = page
.XA p   -         y      another index entry, p = page
.XE     -         y      end index entry
.PX     -         y      print index (ignored)

+cc .
.fi
.SH REGISTERS
There are currently no user controlled registers in this implementation.
.PP
Here is a list of string registers available in -ms; they
may be used anywhere in the text:
.nf
.ec |

     Name  String's Function

     \*(DW weekday
     \*(MO month (month of the year)
     \*(DY day (current date)
     \*Q   quote (" in nroff)
     \*U   unquote (" in nroff)
     \*-   dash (-- in nroff)

.ec \
.fi
.SH EXAMPLES
For an example, see the test files (*.ms) included in the distribution.
.SH BUGS
Probably zillions, especially considering it is so incomplete.
However, it is useful (better than nothing at all).
I have used this package extensively at home to write reports for work.
The results were nearly 100% compatible with Unix (BSD).
No support for displays and keeps, tables, boxed text, multicolumn, other
modes (e.g. thesis mode), footnotes, and beginning/end page traps.
Indented paragraph with tag puts the tag on its own line regardless how
long it is.
.SH AUTHOR
.nf
Adapted for Atari ST (TOS) and Minix by Bill Rosenkranz

net:    rosenkra@convex.com
CIS:    71460,17
GENIE:  W.ROSENKRANZ
.fi

