.\" nroff(1) manpage by rosenkra@convex.com (Bill Rosenkranz, 7/22/90)
.\"
.TH NROFF 1
.SH NAME
nroff - text processor (Version 1.10)
.SH SYNOPSIS
nroff [options] file [...]
.SH DESCRIPTION
Nroff is a text processor and formatter based on the design
provided in "Software Tools" by Kernighan and Plauger.
It has been modified to closely resemble the Unix(tm) nroff command.
The text and commands found in the file(s)
are processed to generate formatted text.
Note that one (and only one) of the files can be "-" which reads
input from stdin at that point.
The output always goes to stdout which can be redirected by the shell.
.\" Using the command line option -l will cause the output to
.\" be sent to the printer instead.
The -o option lets you redirect error output to the specified
file rather than stderr.
Debugging information always goes to the file "nroff.dbg" and is
generally used only for program development.
.SH OPTIONS
The following command line options are available:
.IP -d
Set debug mode.
.IP -h
Hold before exit (Atari TOS only).
.IP -m<name>
Process  macro  file  tmac.<name>.
Thus -man would cause the file tmac.an to be loaded.
Note that files processed in this way should contain only macro definitions,
no immediate output should be generated from this file (see ENVIRONMENT).
.IP -o<file>
Set error log file (default is stderr).
.IP -raN
Preset number register 'a' (single character) to N (decimal integer only).
.IP -po<n>
Shift output right n spaces (like .po).
.IP -pn<n>
Initial page number (like .pn).
.IP -v
Prints the version information to stdout.
.IP +<n>
Causes output to start with page n.
.IP -<n>
Causes output to stop after page n.
.IP -
Input from stdin.
.sp
.SH ENVIRONMENT
Nroff recognizes the following environment variables from the shell:
.IP TMACDIR
An alternate directory to find the files tmac.* ("." for example).
The default is c:\\lib\\tmac under TOS and /usr/lib/tmac under
Minix or Unix(tm).
.IP TMPDIR
An alternate directory to place any temporary files.
The default is the current directory.
Note that nroff does not currently use any temporary files.
.SH COMMANDS
Commands typically are distinguished by a period in column one
of the input
followed by a two character abbreviation for the command funtion.
The abbreviation may then be followed by an optional numeric or
character argument.
The numeric argument may be an absolute value such as setting
the right margin to a particular column, or the argument may be
preceded by a plus sign or a minus sign to indicate that the
parameter should be modified relative to a previous setting.
The following commands are recognized (those marked "extension"
are requests added to the basic set provided by Unix(tm) nroff):
.\"
.IP .ad
Begin line adjustment.
If fill mode is not on, adjustment is defered until it is back on.
If a type indicator is present, the adjustment type is changed as follows:
.nf

     Indicator      Type
        l           adjust left margin only
        r           adjust right margin only
        c           center
     b or n         adjust both margins (default)
     absent         unchanged
.fi
.\"
.IP .af
Assign format to number register.
The available formats are:
.nf

     Format    Numbering Sequence
       1       0,1,2,3,4,...
      001      000,001,002,...
       i       0,i,ii,iii,iv,v,...
       I       0,I,II,III,IV,V,...
       a       0,a,b,...,z,aa,ab,...zz,aaa,...
       A       0,A,B,...,Z,AA,AB,...ZZ,AAA,...

.fi
The second format above indicates that the field width, i.e. number
of digits, is specified by the number of digits in the format type.
.\"
.IP .bd
Ignored by nroff.
.\"
.IP .bo (extension)
Causes the following lines of text to appear in boldface.
The optional argument specifies the number of lines to be typed in boldface.
Boldface and underlining are mutually exclusive features.
The appearance of a boldface command will cause any underlining to cease.
.\"
.IP .bp (extension)
Causes succeeding text to appear at the top of a new page.
The optional argument specifies the page number for the new page.
The initial value is one and the default value is one more than
the previous page number.
.\"
.IP .br
Causes succeeding text to start on a new line at the current left margin.
There is no numeric argument for this command.
.\"
.IP .bs (extension)
Enables or disables the appearance of backspaces in the output text.
Underlining and boldface options are implemented by inserting
character - backspace - character combinations into the output buffer.
This is fine for devices which properly recognize the backspace character.
Some printers, however, do not recognize backspaces, so the option is
provided to overprint one line buffer with another.
The first line buffer is terminated with just a carriage return
rather than the carriage return - linefeed combination.
A zero argument or no argument to the backspace command removes
backspaces from the output.
A non-zero argument leaves them in the output.
The default is to remove backspaces.
.\"
.IP .cc
Changes the nroff command character to that specified by the
character argument.
If no argument is provided, the default is a period (\.).
.\"
.IP .ce
Causes the next line of text to appear centered on the output.
The optional argument specifies if more than one line is to be centered.
.\"
.IP .cs
Ignored by nroff.
.\"
.IP .cu
Causes the next line(s) of text to be continuously underlined.
Unlike the underline command (see \.ul) which underlines only
alphanumerics, continuous underlining underlines all printable characters.
The optional argument specifies the number of lines of text to underlined.
Any normal underlining or boldface commands currently in effect will be
terminated.
.\"
.IP .c2
Changes the nroff no break character to that specified by the
character argument.
If no argument is provided, the default is a single quote.
.\"
.IP .de
Causes all text and commands following to be used to define a macro.
The definition is terminated by a \.en command or the
default \.\. terminator.
The first two characters of the argument following the \.de
command become the name of the new command.
It should be noted that upper and lower case arguments are considered different.
Thus, the commands \.PP and \.pp could define two different macros.
Care should be exercised since existing commands may be redefined.
.sp
A macro may contain up to nine arguments.
In the macro definition, the placement of arguments is designated by the
two character sequences, $1, $2, ... $9.
When the macro is invoked, each argument of the macro command line is
substituted for its corresponding designator in the expansion.
The first argument of the macro command is substituted for the $1
in the expansion, the second argument for the $2, and so forth.
Arguments are typically strings which do not contain blanks or tabs.
If an argument is to contain blanks, then it should be surrounded by
either single or double quotes.
.\"
.IP .ds
Define a string.
To initiate the string with a blank or include blanks
in the string, start it with a single or double quite.
The string
can contain other defined strings or number registers as well as normal
text.
Strings are stored on the macro name space.
.\"
.IP .ec
Changes the nroff escape character to that specified by the
character argument.
If no argument is provided, the default is a backslash.
.\"
.IP .ef (extension)
Specifies the text for the footer on even numbered pages.
The format is the same as for the footer command (see \.fo).
.\"
.IP .eh (extension)
Specifies the text for the header on even numbered pages.
The format is the same as for the footer command (see \.fo).
.\"
.IP .en (extension)
Designates the end of a macro definition.
.\"
.IP .eo
Turn the escape mechanism off.
.\"
.IP .ex
Exit nroff at this point in the processing.
Ex forces all files closed and flushes the output.
.\"
.IP .fi
Causes the input text to be rearranged or filled to obtain the maximum
word count possible between the previously set left and right margins.
No argument is expected.
.\"
.IP .fl
Causes the output buffer to be flushed immediately.
.\"
.IP .fo (extension)
Specifies text to be used for a footer.
The footer text contains three strings seperated by a delimiter character.
The first non-blank character following the command is designated
as the delimiter.
The first text string is left justified to the current indentation
value (specified by \.in).
The second string is centered between the current indentation value
and the current right margin value (specified by \.rm).
The third string is right justified to the current right margin value.
The absence of footer text will result in the footer being printed as
one blank line.
The presence of the page number character (set by \.pc) in the footer
text results in the current page number being inserted at that position.
Multiple occurrances of the page number character are allowed.
.\"
.IP .ft
Changes the current font.
The choices are R (Times Roman), I (Times Italic), B (Times Bold),
S (math special), and P used to request the previous font.
P resets the next previous font to be the one just changed, amounting to a swap.
.\"
.IP .he (extension)
Specifies text to be used for a header.
The format is the same as for the footer (see \.fo).
.\"
.IP .if
Execute a command if the condition is true.
Format is:
.nf

     .if c command
     .if !c command
     .if N command
     .if !N command
     .if "str1"str2" command
     .if !"str1"str2" command

.fi
Here c is a single letter: n (true if nroff), t (true if troff), e (true
if even page), or o (true if odd page).
N is a numerical experssion and can include operators +, -, *, /, % (mod),
>, <, >=, <=, = (or ==), & (and), or : (or).
If the result is greater than 0, the condition evaluates true.
Numbers in the expression can be either constants or contents of number
registers.
Strings are tested using delimeter / or " only at this time.
Note that "block" conditionals like:
.nf

     .if c \\{\\
     ...
     ...
     ... \\}

.fi
are not yet supported.
Also the .ie/.el conditional is not yet supported.
.\"
.IP .in
Indents the left margin to the column value specified by the argument.
The default left margin is set to zero.
.\"
.IP .ju (extension)
Causes blanks to be inserted between words in a line of
output in order to align or justify the right margin.
The default is to justify.
.\"
.IP .lg
Ignored by nroff.
.\"
.IP .ll
Sets the current line length.
The default is eighty.
.\"
.IP .ls
Sets the line spacing to the value specified by the argument.
The default is for single spacing.
.\"
.IP .lt
Set length of three-part titles.
Line length and title length
are independent.
Indents do not apply to titles but page offsets do.
.\"
.IP .m1 (extension)
Specifies the number of lines in the header margin.
This is the space from the physical top of page to and including
the header text.
A value of zero causes the header to not be printed.
A value of one causes the header to appear at the physical top of page.
Larger argument values cause the appropriate number of blank
lines to appear before the header is printed.
.\"
.IP .m2 (extension)
Specifies the number of blank lines to be printed between
the header line and the first line of the processed text.
.\"
.IP .m3 (extension)
Specifies the number of blank lines to be printed between
the last line of processed text and the footer line.
.\"
.IP .m4 (extension)
Specifies the number of lines in the footer margin.
This command affects the footer the same way the \.m1
command affects the header.
.\"
.IP .mc
Margin character. The first argument is the character to use,
the second is the distance to the right of the right margin
to place the margin character. Useful for change bars.
No arguments turns the capability off. Note that with this
nroff, the margin character is always a single character only
and this distance is prefered to be in inches (e.g. 0.2i).
The default space is 0.2i (2 spaces).
.\"
.IP .na
Noadjust.
Ajdustment is turned off; the right margin is ragged.
The adjustment type for \.ad is not changed.
Output line filling still occurs if fill mode is on.
.\"
.IP .ne
Specifies a number of lines which should not be broken across a page boundary.
If the number of lines remaining on a page is less than the
value needed, then a new output page is started.
.\"
.IP .nf
Specifies that succeeding text should be printed without
rearrangement, or with no fill.
No argument is expected.
.\"
.IP .nj (extension)
Specifies that no attempt should be made to align or justify the right margin.
No argument is expected.
.\"
.IP .nr
Causes the value of a number register to be set or modified.
A total of twenty-six number registers are available designated
\\na through \\nz (either upper or lower case is allowed).
When the sequence \\nc is imbedded in the text, the current value
of number register c replaces the sequence, thus, such things as
paragraph numbering can be accomplished with relative ease.
.\"
.IP .of (extension)
Specifies the text for the footer on odd numbered pages.
The format is the same as the footer command (see \.fo).
.\"
.IP .oh (extension)
Specifies the text for the header on odd numbered pages.
The format is the same as the footer command (see \.fo).
.\"
.IP .pc
Specifies the page number character to be used in headers and footers.
The occurrance of this character in the header or footer text
results in the current page number being printed.
The default for this character is the percent sign (%).
.\"
.IP .pl
Specifies the page length or the number of lines per output page.
The default is sixty-six.
.\"
.IP .pm
Print macros.
The names and sizes of the macros are printed to stdout.
This is useful when building a macro package to see how much of the
total namespace is consumed by the package.
.\"
.IP .pn
Changes the page number of the current page and all
subsequent pages to its argument.
If no argument is given, the command is ignored.
.\"
.IP .po
Specifies a page offset value.
This allows the formatted text to be shifted to the right by
the number of spaces specified.
This feature may also be invoked by a switch on the command line.
.\"
.IP .ps
Ignored by nroff.
.\"
.IP .rr
Removes a number register.
.\"
.IP .so
Causes input to be retrieved from the file specified
by the command's character string argument.
The contents of the new file are inserted into the output
stream until an EOF is detected.
Processing of the original file is then resumed.
Command nesting is allowed.
.\"
.IP .sp
Specifies a number of blank lines to be output before
printing the next line of text.
.\"
.IP .ss
Ignored by nroff.
.\"
.IP .ti
Temporarily alters the indentation or left margin value for a single
succeeding input line.
.\"
.IP .tl
Specifies text to be used for a page title.
The format is the same as for the header (see \.he).
.\"
.IP .ul
Causes the next line(s) of text to be underlined.
Unlike the \.cu command, this command causes only alphanumerics
to be underlined, skipping punctuation and white space.
Underline and boldface are mutually exclusive.
.PP
The following nroff commands, normally available, are currently
not implemented in this version:
.cc +
\.fp, \.mk, \.rt, \.vs, \.sv, \.os, \.ns, \.rs, \.am, \.as, \.rm, \.rn,
\.di, \.da, \.wh, \.ch, \.dt, \.it, \.em, \.ta, \.tc, \.lc, \.fc, \.lg,
\.uf, \.tr, \.nh, \.hy, \.hc, \.hw, \.nm, \.nn, \.ie, \.el, \.ev, \.rd,
\.ex, \.nx, \.pi, \.tm, and \.ig.
+cc .
.\"
.SH ESCAPE SEQUENCES
Escape sequences are used to access special characters (such as Greek
letters) which may be outside the normal printable ASCII character set.
The are also used to toggle certain actions such as font selection.
.PP
.ne 5
The escape sequences include:
.sp
.eo
.\" .ec -
.nf
\\          backslash character
\e          printable version of escape character
\'          accute accent (equivalent to \\(aa)
\`          grave accent (equivalent to \\(ga)
\-          minus sign
\.          period
\<space>    a single, unpaddable space
\0          digit-width space
\|          1\6em space (zero space in nroff)
\^          1\12em space (zero space in nroff)
\&          non-printing zero-width character
\"          beginning of comment
\%          default hyphenation character
\(xx        special character named xx
\*x,\*(xx   interpolate string x or xx
\fc         font change (c = R,I,B,S,P)
\nx         interpolate number register x
\t          horizontal tab
.fi
.sp
.ne 5
The Atari ST (TOS) version of nroff includes the following special
characters. NOTE: THESE ARE NOT AVAILABLE UNDER Minix OR Unix(tm)!
.sp
.nf
\(co        copyright
\(rg        registered
\(tm        trademark
\(12        1/2
\(14        1/4
\(p2        exponent 2
\(p3        exponent 3
\(pn        exponent n
\(aa        acute
\(ga        grave
\(de        degree
\(dg        dagger
\(ct        cent
\(bu        bullet
\(pp        paragraph
\(^g        ring bell
\(ua        up arrow
\(da        dn arrow
\(->        rt arrow
\(<-        lf arrow
\(di        divide
\(sr        sq root
\(==        ==
\(>=        >=
\(<=        <=
\(+-        +-
\(~=        ~=
\(ap        approx
\(no        not
\(mo        memeber
\(ca        intersect
\(cu        union
\(*a        alpha
\(*b        beta
\(*g        gamma
\(*d        delta
\(*s        sigma
\(*p        pi
\(*m        mu
.fi
.ec
.SH PREDEFINED GENERAL NUMBER REGISTERS
The following number registers are available for both reading and writing.
They are accessed with the \\n(xx and \\nx escape and can be set with .nr:
.nf
.ne 5

%           current page number
dw          current day of the week (1-7)
dy          current day of the month (1-31)
hh          current hours (0-23)
ln          current line number
mm          current minutes (0-59)
mo          current month (1-12)
ss          current seconds (0-59)
yr          last 2 digits of current year
.fi
.sp
The following number registers are available for reading only:
.nf
.cc +

.$          number of args available in current macro
.A          always 1 in nroff
.H          available horizontal resolution
.T          always 0 in nroff
.V          available vertical resolution
.c          number of lines read from current file
.f          current font (1-4)
.i          current indent
.l          current line length
.o          current page offset
.p          current page length
.v          current vertical spacing
+cc .

.fi
.SH NOTES
There are several missing features, notably diversions, traps,
conditionals, all the hard stuff.
This means you can't use some existing macro packages (yet, I hope).
There is no complete -ms and -me packages as a result.
The goal is to make this nroff work with all the SunOS macro packages
sometime before Unix becomes obsolete!
.PP
If you make additions to this code, please mail the changes to me so I
can make formal distributions.
.SH BUGS
Undoubtedly more than I know about.
Here are a few:
.PP
The ability to perform numerical calculations on registers is not
implemented.
.PP
All dimensional units are in em's or inches only.
.PP
Lines with multiple string instances (i.e. \\*(xx) don't seem to work.
.PP
Lines with font changes (e.g. for italics) use vt52 escape sequences
to go to highlight mode.
This should read termcap/terminfo to do it right.
.PP
Some interpolations don't work properly.
.PP
The code uses statically allocated arrays for macros, strings, and registers.
This should be changed to dynamically allocated buffers or
write to intermediate files on small memory systems (i.e. Minix).
.SH FILES
.nf
.ec |
\lib\tmac\tmac.*   predefined macros (see ENVIRONMENT)
nroff.dbg          debugging output
stderr             default error output stream
stdout             output stream

.ec \
.fi
.SH AUTHOR
.nf
Adapted for Atari ST (TOS) and Minix by Bill Rosenkranz 11/89

net:    rosenkra@convex.com
CIS:    71460,17
GENIE:  W.ROSENKRANZ

Original author:

Stephen L. Browning
5723 North Parker Avenue
Indianapolis, Indiana 46220

.fi
.SH HISTORY
.nf
Originally written in BDS C (by Stephen L. Browning?)
Adapted for standard C by W. N. Paul
Heavily hacked up to conform to the "real" nroff with numerous
additions by Bill Rosenkranz 11/89
Bug fixes (termcap) and Minix 1.5.5 compatibility by
Wim 'Blue Baron' van Dorst (wsincc@tuerc3.urc.tue.nl)

.fi

.SH RECOMMENDATIONS
I envisioned this rather limited version as a way of formatting
man pages for my Atari ST system.
It works just fine for that.
The man macro package is certainly adequate for that purpose.
However, it would be nice to have more.
I suggest you limit
yourself to things which would port easily to other environments.
All the man macros available here should port without effort
to a more complete Unix(tm) environment.
.PP
Nroff as it stands can certainly be useful.
I recommend you don't
use the commands marked "extension".
Study the source for the man pages here (nroff(1), ms(7), and man(7)) as
well as the macro packages (tmac.an and tmac.s) and the examples to find
out the quirks.
Some things may not quite work like they do under Unix(tm), but it is
fairly close for what is here.
.SH REFERENCES
This document briefly describes the workings of nroff.
It is certainly not the definitive work on text processing.
I suggest you go out and get a good book (there are several on the market)
or refer to the Unix(tm) manuals for more help.
Nroff is just like a compiler and is much more complicated than (say) the C
language which only has a handful of rules and is much more thoroughly
documented.
Good luck!
.SH REQUEST SUMMARY
The following table summarizes the nroff requests currently available:
.nf
.ne 8
.cc +

Request Form    Initial  Default  Notes   Explanation
--------------  -------  -------  ------- ----------------------
Font and Character Size Control

.ps +-N         10pt     prev     E       point size (ignored)
.ss N           12/36em  ignored  E       space size (ignored)
.cs F N M       off      -        P       constant space mode (ign)
.bd F N         off      -        P       embolden font F (ignored)
.bd S F N       off      -        P       embolden special font
.ft F           Roman    prev     E       change to font F

+ne 4
Page Control

.pl +-N         11in     11in     v       page length
.bp +-N         N=1      -        B,v     eject page
.pn +-N         N=1      ignored  -       next page number N
.po +-N         0        prev     v       page offset
.ne N           -        N=1V     D,v     need N vertical space

+ne 4
Text Filling, Adjusting, and Centering

.br             -        -        B       break
.fi             fill     -        B,E     fill mode
.nf             fill     -        B,E     no fill or adjust
.ad c           adj,both adjust   E       adjust output, mode c
.na             adjust   -        E       no adjust
.ce N           off      N=1      B,E     center N lines

+ne 4
Vertical Spacing

.ls N           N=1      prev     E       output N-1 Vs
.sp N           -        N=1V     B,v     space vertical

+ne 4
Line Length and Indenting

.ll +-N         6.5i     prev     E,m     line length
.in +-N         N=0      prev     B,E,m   indent
.ti +-N         -        ignored  B,E,m   temporary indent

+ne 4
Macros, Strings, Diversions, and Position Traps

.de xx yy       -        .yy=..   -       define macro xx
.ds xx str      -        ignored  -       define string xx

+ne 4
Number Registers

.nr R +-N M              -        u       define and set num reg
.af R c         arabic   -        -       assign format to reg
.rr R           -        -        -       remove register

+ne 4
I/O Conventions and Character Translation

.ec c           \        \        -       set escape char
.eo             on       -        -       turn off escape mech
.lg N           -        -        -       ligature mode (ignored)
.ul N           off      N=1      E       underline N lines
.cu N           off      N=1      E       cont. underline
.cc c           .        .        E       set control char
.c2 c           '        '        E       set nobreak control char

+ne 4
Three-part Titles

.tl 'l'c'r'              -        -       three-part title
.pc c           %        off      -       page number char
.lt +-N         6.5in    prev     E,m     length of title

+ne 4
Conditional Acceptence of Input

.if c cmd                -        -       if c true, accept cmd
.if !c cmd               -        -       if c false, accept cmd
.if N cmd                -        -       if N > 0, accept cmd
.if !N cmd               -        -       if N <= 0, accept cmd
.if "s1"s2" cmd          -        -       if strings same, accept cmd
.if !"s1"s2" cmd         -        -       if strings differ, accept cmd

+ne 4
Input/Output File Switching

.so filename             -        -       switch source file

+ne 4
Miscellaneous

.mc c N         -        off      E,m     margin char c, seperation N
.pm t           -        all      -       print macro names
.fl             -        -        B       flush output buffer

+ne 4
Notes

B       causes a break
D       mode or parameters associated with current diversion level
E       relevant parameters are a part of the current environment
O       must stay in effect until logical output
P       mode must be still or again in effect at time of physical output
v,p,m,u default scale indicators

+cc
.fi
