! Custom routines. These are routines that can be provided by the programmer to do certain
! things. Unless you have a VERY good reason, NEVER allow a routine that replaces a stubbed one
! to contain nothing. It MUST contain a rfalse!

! AfterPrompt
! Just after the prompt is displayed.
! Whereas GamePostRoutine is like a super-after rule, AfterPrompt should be used for system
! manipulation (as opposed to game manipulation).
[ AfterPrompt;
 rfalse;
];

! Amusing
! Providing the AMUSING_PROVIDED default is set to 0, shows amusing things to do.
! So long as you die (method 2, i.e. winning).
[ Amusing;
 print (FormatText)"%B";
 print (Center)"Closing comments.";
 print (FormatText)"%P", (NewLine)2;
 print "In an interview C.E.Forman had with Matt Barringer a few years back, Mr. Barringer commented on how awful the game was. It's made him something of an (in)famous legend in the IF community. I suspect that, if he were to do ~Detective~ now, he'd definitely do it differently.", (NewLine)2;
 print "Matt probably can't help but cringe every time he has ~Detective~ mentioned to him. It makes ~Inhumane~, by Andrew Plotkin, look good. Matt was two years younger than Zarf when he did ~Detective~, Zarf being 14 when he did ~Inhumane~. Personally, I like ~Inhumane~. It's a fun diversion for a few minutes. ~Detective~, unfortunately, cannot even claim that.", (NewLine)2;
 print "Andrew's gone on to much bigger and better things, such as ~So Far~ and ~Space Under the Window~. Matt didn't. A shame, really, as he obviously learnt from his mistakes.", (NewLine)2;
 print (FormatText)"%B%FSTUART MOORE.%P", (NewLine)2;
 rfalse;
];

! BeforeParsing
! Just before the prompt is displayed.
! Whereas GamePreRoutine is like a super-before rule, BeforeParsing should be used for system
! manipulation (as opposed to game manipulation).
[ BeforeParsing;
 rfalse;
];

! GamePostRoutine
! Allows you to do things after the player has done something.
[ GamePostRoutine;
 rfalse;
];

! GamePreRoutine
! Allows you to do things before the player can do anything.
[ GamePreRoutine;
 rfalse;
];

! TimePasses
! What happens with the passing of time. This is called after every turn.
[ TimePasses;
 rfalse;
];

! NewLine
! Prints 'NewLines' number of new_lines.
[ NewLine NewLines Count;
 for (Count=0: Count<NewLines: Count++)
 {
  new_line;
 }
 rfalse;
];

! FormatText
! Syntax: FormatText (string);
! To quote Allen Garvin, the author of this routine:
! "I added the printf from the designer's manual, but didn't find it very useful, so I changed
! it into this :)"
! Note that this routine uses the global table 'printed_text'.
! You may need to increase $MAX_STATIC_DATA should you make this table larger.
[ FormatText format j k;
 @output_stream 3 printed_text;	! Most cunning. Re-route textual output to this array.
 print (string) format;		! Just print it out (to an array and not the screen).
 @output_stream -3;		! And resume normal service.
 j = printed_text-->0;		! Determine (less 2) the string length.
 for (k=2: k<j+2: k++)		! Then get to work.
 {
  if (printed_text->k == '%')	! A '%' symbol is used to control formatting.
  {
   switch (printed_text-> (++k))
   {
    '%': print "%";		! To get a % mark, use '%%'.
    ' ': spaces 1;		! To get a single space, '% '. Not sure why this may be of use.
    'B': style bold;		! i.e. use the sequence '%B' for bold text.
    'F': style fixed;		! i.e. use the sequence '%F' for fixed-point text.
    'P': style roman;		! i.e. use the sequence '%P' to return to normal.
    'R': style reverse;		! i.e. use the sequence '%R' for reverse-video text.
    'U': style underline;	! i.e. use the sequence '%U' for underlined text.
   }
  } else			! Just print the character out.
  {
   print (char) printed_text->k;
  }
 }
];