!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                            Routines
!**
!***************************************************************************


!***************************************************************************
!** 
!**                            Go Booklet
!**
!***************************************************************************

Menu book_menu "The Rules of Go";
Option -> "The Game of Go"
   with description
           "Go, called baduk in Korean and wei-chi or weiqi in 
           Chinese, is a 4,000 year-old game of strategy played
           by more than 100 million people. Go was considered 
           one of the Four Great Accomplishments of ancient 
           China, one of the worthy pursuits of a lifetime - 
           along with poetry, archery, and calligraphy. It is 
           both an art and a mental workout - ingeniously disguised 
           as a game. Anyone, from children of five or six to 
           people in their nineties, can play and enjoy Go.";

Option -> "Basic Equipment"
   with description [;
           print "A Go set consists of a board, stones and bowls.^^
         
                  The board is generally made of wood, though other materials 
                  can be used. The Go board (called the 'goban') is marked 
                  with a square grid of vertical and horizontal lines. There 
                  are 3 standard sizes for Go boards. A standard full-size 
                  board has 19 lines in each direction, or 19x19 = 361 points. 
                  For shorter games, a 13x13 board is commonly used. Beginners 
                  usually play on a 9x9 board. Note that the size of the board 
                  refers to the number of lines in each direction, not the 
                  number of squares. The diagrams shown in these rules show 
                  only the intersection points, not the grid lines. Here is 
                  an example of a 19x19 board:^^
                     
                 [Press any key to continue.]^";

	   Pause();
           @erase_window -1;

           font off;

           print ". . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . + . . . . . + . . . . . + . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . + . . . . . + . . . . . + . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . + . . . . . + . . . . . + . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^
	          . . . . . . . . . . . . . . . . . . .^^";
                     
            font on;

	    "The nine '+'s (which are small black dots on a real board) are 
	    used when a handicap is given and they also act as landmarks.^^
		    
            A Go set has 180 white stones and 181 black stones. The stones are 
            circular, slightly less than one inch in diameter. They are 
            thickest in the center and gradually taper towards the edge.^^
            
            Go stones may be made of plastic, glass or precious metals, but 
            traditionally the white stones are made of clamshell while the 
            black stones are made of slate.^^

            The last components of a Go set are bowls that hold all the black 
            and white stones. The bowls ('go-ke') can be made of plastic, 
            though traditional bowls are made of wood. They are shaped 
            somewhat like a flattened sphere but with the lid shaped in the 
            form of a saucer. The lid is used to hold captured stones.";
   ];

Option -> "Moves"
   with description [;
           print "Black always plays the first move. Players alternate 
                  making moves, playing one stone during their turn.^^

                  Here is a diagram which shows the first few moves of a game 
                  being played on a 9x9 board: ^^";
           
           font off;

           print "I  . . . . . . . . .^
                  H  . . . . . . . . .^
                  G  . . 1 . . . 3 . .^
                  F  . . . . . . . . .^
                  E  . 5 . . . . . 6 .^
                  D  . . . . . . . . .^
                  C  . . . . . . 2 . .^
                  B  . . 4 . . . . . .^
                  A  . . . . . . . . .^^";

           print "   1 2 3 4 5 6 7 8 9^^";
           
           font on;

           "This is how games and moves are usually shown. The stones are 
           numbered to show the order in which they were played. Black first 
           played stone number 1, then White played stone number 2, and 
           so on.^^
           
           An alternate method of recording moves is to use the letter-number 
           coordinates where each stone is played. In the example above, move
           number 1 was played on coordinates G3, move number 2 on C7, etc.^^
           
           Note that the stones are played on the intersections of the lines, 
           not in the squares formed by the lines. Stones may also be played 
           on the edge of the board, or even in the corners. Although either 
           player may pass at any time, it is never a good idea until the game 
           is over. Passing is only used to end the game, which is covered 
           later.";
   ];

Option -> "Capturing and Suicide"
   with description [;
           print "Two points are adjacent if they are next to each other 
                  in a vertical or horizontal (but not diagonal) direction. 
                  Two stones of the same color on adjacent points are 
                  connected and belong to the same group of stones. An empty 
                  point adjacent to a group of stones is a 'liberty' of that 
                  group. When enemy stones occupy all of a group's liberties 
                  (in other words, when the group is surrounded by enemy 
                  stones), that group is captured and removed from the 
                  board.^^

                  In the figure below, the two stones marked 'A' are on 
                  adjacent points and they are connected together. So are the 
                  two stones marked 'B'. The two stones marked 'C' are not on 
                  adjacent points and they are not connected. Much larger 
                  groups of connected stones are often formed. For example, 
                  all of the stones marked 'D' are connected together, and so 
                  are all of the stones marked 'E'. Note that groups 'D' and 
                  'E' are not connected to each other, even though they are 
                  close together.^^";
           
           font off;

           print ". . . . . . . . . . ^
                  . A A . B . . C . . ^
                  . . . . B . C . . . ^
                  . . . . . . . . . . ^
                  . . . . . . . . . . ^
                  . . D D D . . E E . ^
                  . . D . D D D . E . ^
                  . D D D D D D . E . ^
                  . . . . . . D . E . ^
                  . . . . . . . E E . ^
                  . . . . . . . . . . ^^";
           
           font on;

           print "[Press any key to continue.]^";

	   Pause();
           @erase_window -1;

           print "Each vacant point adjacent to a group of connected stones 
                  is a liberty for that group. A single stone in the center 
                  of the board (like A in the figure below) has 4 liberties. 
                  A stone on the edge of the board (B) has 3 liberties, and a 
                  stone in the corner (C) has only 2. The stones marked 'D' 
                  are already partly surrounded by enemy stones (X), and they 
                  have only 4 liberties left.^^";
           
           font off;

           print ". . . 1 B 3 . 1 C^
                  . 4 . . 2 . . . 2^
                  1 A 3 . . . . . .^
                  . 2 . . . X . . .^
                  . . . . 1 D 2 . .^
                  . . . X D D 3 . .^
                  . . . 4 D X . . .^
                  . . . X X . . . .^
                  . . . . X . . . .^
                  . . . . . . . . .^^";
           
           font on;

           "You may not play a stone which would have no liberties. 
           In other words, you may not play a stone which would capture itself. 
           However, you can play such a move if it captures one or more enemy 
           stones, because once the enemy stones are removed from the board, 
           your stone will have liberties again.";
   ];

Option -> "Life and Death"
   with description [;
           print "One of the most important concepts in Go is that of life
                  and death. A group of stones must have at least two points 
                  of territory (called ~eyes~) to ensure that it cannot be 
                  captured. This is shown in the following diagram:^^";

           font off;
           
           print ". . . . . . . . .^
                  . . . . . . . . .^
                  . . . O O . . . .^
                  . . O X X O O . .^
                  . . O X . X X O .^
                  . . O X X . X O .^
                  . . . O O X X O .^
                  . . . . . O O . .^
                  . . . . . . . . .^
                  . . . . . . . . .^^";

           font on;

           print "The black stones have two eyes. White cannot capture the
                  black stones; placing a white stone in one of the eyes 
                  would be suicide (which is not allowed) because it still 
                  leaves the black stones with a liberty.^^";

           print "Here is another example:^^";
           
	   font off;

           print ". . . . . . . . .^
                  . . . O O O . . .^
                  . . O X X X O . .^
                  . . O X . X O . .^
                  . . O X 1 X O . .^
                  . . O X . X O . .^
                  . . O X X X O . .^
                  . . . O O O . . .^
                  . . . . . . . . .^
                  . . . . . . . . .^^";

           font on;

           "In this diagram, the black stones will live if black plays 
            a stone at 1 - this will create two eyes. If white plays
            there first, black will not be able to create two eyes and 
            will be captured.";
   ];

Option -> "Repetition"
   with description [;
           print "A stone may not be played if it will make the board look 
                  exactly the same as it did earlier in the game. In other 
                  words, repetition is not allowed.^^
           
                  This rule prevents the same moves from being played over 
                  and over again so that the game never ends. In real games, 
                  there is only one common pattern for which this rule is 
                  needed. It is called a 'ko' (which rhymes with 'go') 
                  and it looks like this:^^";
           
           font off;
           
           print ". . . . .     . . . . . .     . . . . . . ^
                  . . X O .     . . X O . .     . . X O . . ^
                  . X O . O  -> . X . 1 O .  -> . X 2 . O . ^
                  . . X O .     . . X O . .     . . X O . . ^
                  . . . . .     . . . . . .     . . . . . . ^^";
           
           font on;
      
           "Black can play 1, which captures a white stone. But if White played 2, 
           capturing the stone that Black just played, it would bring us right 
           back where we started. Black and White could go on capturing each others' 
           stones forever. Therefore, White is not allowed to play stone number 2 
           right away. Instead, White must first play a move somewhere else on the 
           board. If Black plays somewhere else, too, then White can come back and 
           play stone number 2 because this will not make the board look the same 
           as it did before (the two stones that were played somewhere else will 
           make it look different).";
   ];

Option -> "Scoring"
   with description [;
           print "If the last move of each player was a pass, the game ends 
                  and scoring begins. First, the players must agree which 
                  stones on the board are dead. The dead stones are considered 
                  to be captured, and are removed from the board. Each player 
                  gets one point for every opponent's stone that was captured, 
                  and one point for every empty point of territory. A group of 
                  connected empty points is territory if it is surrounded by 
                  stones of only that player's color. The player with the 
                  higher score wins.^^

                  In the example below, the stones marked 'A' surround six 
                  points of territory while the stones marked 'B' surround 
                  ten points.^^";
           
           font off;
           
           print ". . A . . . . . .^
                  . . A . . . . . .^
                  . . A . . . . . .^
                  A A A . . . . . .^
                  . . . . . . B B B^
                  . . . . . . B . .^
                  . . . . . B B . .^
                  . . . . . B . . .^
                  . . . . . B . . .^^";

            font on;

            print "Komi:^^";

            "In a game played between players of equal skill, black 
             has an advantage by playing first. To offset this advantage,
             white receives 5.5 points as compensation. In handicap games
             between players of unequal skill, the compensation is 
             only 0.5 point. The half point is used to avoid ties.";
   ];

Option -> "Handicaps and Ranks"
   with description
	   "If one of the players is stronger than the other, a handicap 
	   can be given. The weaker player takes the black stones, and 
	   is allowed to make between two and nine moves before the first white 
	   stone is played. (Black always plays one stone before the first 
	   white one anyway, and so the smallest handicap is a two stone 
	   handicap.) In China, Black may play these moves anywhere on 
	   the board, but in Japan they must be played on the handicap 
	   points or star points which are the nine points on the board 
	   marked with small black dots. In most other countries, the 
	   Japanese system is most often used.^^
	               
	   Ranks: Go playing ability is called 'strength.' Go strength
	   is distinguished by levels called dan (pronounced dahn) and kyu.
	   Players start out at 30 kyu and work up towards 1 kyu. The rank
	   following 1 kyu is 1 dan; the top amateur rank is 6 dan. 
	   Professionals are ranked from 1 dan to 9 dan (top level).";

!***************************************************************************
!** 
!**                            Routines
!**
!***************************************************************************

[ Amusing ;
   if (deadflag == 2) {
      move amuse to help_menu;
      help_menu.select(); }
];

[ PrintTaskName achievement;
   switch(achievement)
   {
      0  : "Reading the Go booklet";
      1  : "Unlocking the safe";
      2  : "Capturing a black Go stone";
      3  : "Retrieving the fuse";
      4  : "Opening the water valve";
      5  : "Retrieving the red ball";
      6  : "Making a baseball bat out of the log";
      7  : "Opening the steel door";
      8  : "Making four silver Go stones";
      9  : "Completing the Go problem in the Northern Testing Room"; ! 2 points
      10 : "Completing the Go problem in the Northern Testing Room"; ! 1 point
      11 : "Completing the Go problem in the Southern Testing Room"; ! 2 points
      12 : "Completing the Go problem in the Southern Testing Room"; ! 1 point
      13 : "Completing the Go problem in the Eastern Testing Room";  ! 2 points
      14 : "Completing the Go problem in the Eastern Testing Room";  ! 1 point
      15 : "Completing the Go problem in the Western Testing Room";  ! 2 points
      16 : "Completing the Go problem in the Western Testing Room";  ! 1 point
      17 : "Correctly scoring the Go game";
   }
];

[ PrintRank;
   print ", earning you the rank of ";
   switch(score) {
      0     : "30 kyu.";
      1, 2  : "25 kyu.";
      3, 4  : "20 kyu.";
      5, 6  : "15 kyu.";
      7, 8  : "10 kyu.";
      9, 10 : "5 kyu.";
     11, 12 : "1 dan.";
     13, 14 : "2 dan.";
     15, 16 : "3 dan.";
     17, 18 : "4 dan.";
     19, 20 : "5 dan.";
     21, 22 : "6 dan.";
     23, 24 : "7 dan.";
     25, 26 : "8 dan.";
     27, 28 : "9 dan.";
   }
];

[ ChooseObjects obj code;
   if (code<2) { if (obj has scenery) return 2; rfalse; }

   if (action_to_be == ##Push && 
      (obj == gas_switch || obj == blower_switch || 
       obj == green_button || obj == glass_plate)) { return 2; }

   if (obj hasnt scenery) return 2;

   return 1;
];

!***************************************************************************
!**
!** Define a new grammar token 'square' that matches coordinates like
!** "f2" or "a3", and puts the rank and file of the specified square
!** in global variables. This is so that the player can issue commands
!** such as "put stone on a5".
!**
!***************************************************************************

[ square w a b;
    if (wn <= parse->1 && WordLength(wn) == 2) {
        w = WordAddress(wn);
	rank = w->0;
	file = w->1;
	if (rank >= 'a' && rank <= 'i' && file >= '1' && file <= '9') {
        switch (rank) {
         'a': a = 8;
         'b': a = 7;
         'c': a = 6;
         'd': a = 5;
         'e': a = 4;
         'f': a = 3;
         'g': a = 2;
         'h': a = 1;
         'i': a = 0; }

        switch (file) {
         '1': b = 0;
         '2': b = 1;
         '3': b = 2;
         '4': b = 3;
         '5': b = 4;
         '6': b = 5;
         '7': b = 6;
         '8': b = 7;
         '9': b = 8; }

        position = (a*9) + b;
        ++wn;
        return 0;
	}
	else
	   position = -1;
    }
    return 0;
];

!***************************************************************************
!**
!** Augment ParserError so that it prints an appropriate error message
!** when the parser expects a square but finds something that isn't 
!** the name of a square.
!**
!** Note that BeforeParsing sets position to 0 before any parsing
!** is done, so if parsed_rank = -1 then there must have been a failed
!** attempt at parsing a square name in this command.
!**
!***************************************************************************

[ ParserError pn;
    if (pn == CANTSEE_PE && position == -1 && location == go_room)
        "There is no such coordinate.";
    rfalse;
];

[ Avail a b c d;
   if ((a in player || a in location || a in small_board) &&
       (b in player || b in location || b in small_board) &&
       (c in player || c in location || c in small_board) &&
       (d in player || d in location || d in small_board))
      return 1;
   else
      return 0;
];

[ CaptureSub a ;
   if (location ~= go_room)
      "That doesn't work here.";

   if (noun ~= 0 && noun hasnt stone)
      "That can't be captured.";

   if (noun ~= 0 && noun has stone && noun notin small_board)
      "That can only be captured if it's on the Go board.";

   if (noun ~= 0 && noun in small_board)
      "You'll have to specify which coordinate you want to capture 
       the stone from, such as, ~CAPTURE E8.~";

   if (location == go_room && go_bd->position == 0)
      "There's nothing there to capture.";

   if (position == 20 || position == 24 || position == 56 || position == 60) {
      if (task_done->2 == 0)
         "You'll have to prove that you know how to capture stones before you 
          can use the CAPTURE verb.";

      if (Avail(stone1, stone2, stone3, stone4) == 1) {
          for (a = 0: a < 81: a++) {
             if (go_bd->a > 1 && go_bd->a < 6) go_bd->a = 0; }

          move stone1 to small_board;
          move stone2 to small_board;
          move stone3 to small_board;
          move stone4 to small_board;

          give stone1 concealed;
          give stone2 concealed;
          give stone3 concealed;
          give stone4 concealed;

          go_bd->(position-1) = 2;
          go_bd->(position+1) = 3;
          go_bd->(position-9) = 4;
          go_bd->(position+9) = 5;

          go_bd->position = 0;

          switch(position) {
             20 : stair1 = 1;
             24 : stair2 = 1;
             56 : stair4 = 1;
             60 : stair5 = 1; }

          print "You place the white Go stones around the black stone on ", 
                 (char) rank - 32, (char) file, ". ";
          CaptureMsg(1);
          PrintBoard();
          rtrue; }
      else
         "You can't do that unless you have the proper stones."; }

   if (position == 40 && go_bd->40 == 10) {

      if (Avail(stone5, stone6, stone7, stone8) == 1) {
          for (a = 0: a < 81: a++) {
             if (go_bd->a > 5 && go_bd->a < 10) go_bd->a = 0; }

          move stone5 to small_board;
          move stone6 to small_board;
          move stone7 to small_board;
          move stone8 to small_board;

          give stone5 concealed;
          give stone6 concealed;
          give stone7 concealed;
          give stone8 concealed;

          go_bd->(position-1) = 6;
          go_bd->(position+1) = 7;
          go_bd->(position-9) = 8;
          go_bd->(position+9) = 9;

          go_bd->40 = 0;
          stair3 = 1;
          print "You place the silver Go stones around the gold stone on ", 
                 (char) rank - 32, (char) file, ". ";
          CaptureMsg(2);
          PrintBoard();
          rtrue; }
      else
         "You can't do that unless you have the proper stones."; }

   "Nothing happens.";
];

[ PlayStoneSub a;
   if (noun has stone && 
      (location ~= go_room or PuzzleRoomN or PuzzleRoomS or 
                   PuzzleRoomE or PuzzleRoomW))
      "That doesn't work here.";

   if (noun has stone && location == go_room) {
      if (noun notin player)
         "You need to be holding ", (the) noun, " before you can put it on 
          top of something else.";

      if (go_bd->position ~= 0)
         "There's already a stone there.";

      else {
         move noun to small_board;
         give noun concealed;
         go_bd->position = noun.number;
         print "You put ", (the) noun, " on ", (char) rank - 32, (char) file, ".^^";
         PrintBoard();
         rtrue; }}

   if (noun has stone &&
      (location == PuzzleRoomN or PuzzleRoomS or 
                   PuzzleRoomE or PuzzleRoomW)) {
      if (noun notin player)
         "You need to be holding ", (the) noun, " before you can put it on 
          top of something else.";

      if (puz_bd->position ~= 0)
         "There's already a stone there.";

      else {
         move noun to small_board;
         give noun concealed;
         puz_bd->position = 3;
         print "You put ", (the) noun, " on ", (char) rank - 32, (char) file, ".^^";
         switch(location) {
            PuzzleRoomN: a = tries->1;
                         a++;
                         tries->1 = a;
                         if (position ~= 8)
                            WrongAnswer(1);
                         else
                            CorrectAnswer(1);
            PuzzleRoomS: a = tries->2;
                         a++;
                         tries->2 = a;
                         if (position ~= 26)
                            WrongAnswer(2);
                         else
                            CorrectAnswer(2);

            PuzzleRoomE: a = tries->3;
                         a++;
                         tries->3 = a;
                         if (position ~= 5)
                            WrongAnswer(3);
                         else
                            CorrectAnswer(3);

            PuzzleRoomW: a = tries->4;
                         a++;
                         tries->4 = a; 
                         if (position ~= 42)
                            WrongAnswer(4);
                         else
                            CorrectAnswer(4); }
         rtrue; }}

   if (noun hasnt stone && 
      (location == go_room or PuzzleRoomN or PuzzleRoomS or 
                   PuzzleRoomE or PuzzleRoomW))
      "It's a Go board, not a table.";
   else
      "You can't do that here.";
];

[ CorrectAnswer a;
   print "^After a moment the crystal Go stone begins to change color, finally
          becoming ";

   switch(a) {
      1      : print "black.";
               puz_bd->position = 1;
      2 to 4 : print "white.";
               puz_bd->position = 2; }

   new_line; new_line;
   PrintPuzzleBoard(a);
   answers->a = 1;
   switch(a) {
      1 : if (tries->1 < 4)
             Achieved(9);
          else
             Achieved(10);
      2 : if (tries->2 < 4)
             Achieved(11);
          else
             Achieved(12);
      3 : if (tries->3 < 4)
             Achieved(13);
          else
             Achieved(14);
      4 : if (tries->4 < 4)
             Achieved(15);
          else
             Achieved(16); }

      print "^Correct!^^";
      switch(a) {
         1 : print "Playing a black stone on I9 will create two eyes,
                    thus allowing black to live.";

         2 : print "Playing a white stone on G9 will prevent black from 
                    creating two eyes, thus killing the black group.";

         3 : print "Playing a white stone on I6 will prevent black from 
                    creating two eyes, thus killing the black group.";

         4 : print "Playing a white stone on E7 will ensure that white 
                    will be able to make two eyes."; }

      remove crystal_stone1;
      give crystal_stone1 ~concealed;
      remove open_bowl;
      ClearPuzzleBoard();

      switch(a) {
         1 : remove puzzle_board_n;
             remove stones_n;

         2 : remove puzzle_board_s;
             remove stones_s;

         3 : remove puzzle_board_e;
             remove stones_e;

         4 : remove puzzle_board_w;
             remove stones_w; }

      "^^As you watch, the Go board, bowl and stones fade from view, leaving 
       only the pedestal.";
];

[ WrongAnswer a;
   PrintPuzzleBoard(a);
   ClearPuzzleBoard();
   move crystal_stone1 to player;
   give crystal_stone1 ~concealed;
   "^^After a few moments the crystal Go stone fades away and you notice that
    you are holding it again. It appears that was not the correct answer.";
];

[ TakeStoneSub a;
   if (location ~= go_room or PuzzleRoomN or PuzzleRoomS or 
                   PuzzleRoomE or PuzzleRoomW)
      "That doesn't work here.";

   if (location == PuzzleRoomN or PuzzleRoomS or 
                   PuzzleRoomE or PuzzleRoomW) {
      if (puz_bd->position == 0)
         "There's nothing there.";
      else
         "The stones are fixed in place."; }

   if (location == go_room) {
      if (go_bd->position == 0)
         "There's nothing there.";

      if ((position == 20 || position == 24 || 
           position == 56 || position == 60) &&
          (go_bd->position == 1))
             "The black stones are fixed in place.";

      else {
         a = go_bd->position;
         switch (a) {
            2: move stone1  to player; give stone1 ~concealed;
            3: move stone2  to player; give stone2 ~concealed;
            4: move stone3  to player; give stone3 ~concealed;
            5: move stone4  to player; give stone4 ~concealed;

            6: move stone5  to player; give stone5 ~concealed;
            7: move stone6  to player; give stone6 ~concealed;
            8: move stone7  to player; give stone7 ~concealed;
            9: move stone8  to player; give stone8 ~concealed;

           10: move gold_stone1 to player; give gold_stone1 ~concealed; }

         go_bd->position = 0;
         
         print "You pick up the ";
      
         switch (a) {
            2 to 5 : print "white stone";
            6 to 9 : print "silver stone";
            10 :     print "gold stone"; }

         print " from ", (char) rank - 32, (char) file, ".^^";
         PrintBoard();
         rtrue; }}
];

[ BeforeParsing ;
   position = 0;
];

[ Pause dummy;
	@read_char 1 dummy;
	return dummy;
];

[ LostMind ;
   "You've lost your mind.";
];

[ DeathMessage ;
   print "The game has ended";
];

[ PrintCube a;
   print " A ";
      switch (a) {
         1 : print "jet black";
         2 : print "dark green";
         4 : print "bright white";
         5 : print "deep red"; }
         
   print " cube rests in a depression located in the top 
           of the block.";
];

[ RemoveStones i j;
   objectloop(i in player) if (i has stone) j++;
   if (j > 0) {
      objectloop(i in player && i has stone) remove i;
      print "You notice that ";
      if (j == 1)
         "the Go stone you were carrying has disappeared!";
      else
         "all of the Go stones you were carrying have disappeared!"; }
   else
      rtrue;
];

[ RemoveCrystal ;
   if (crystal_stone1 in player) {
      remove crystal_stone1;
      "As you leave the room you notice that the crystal Go stone has
       disappeared."; }
];

!***************************************************************************
!**
!**  This routine prints out the instructions for each Go problem
!**  
!***************************************************************************

[ PrintInstructions a ;
   print "^This looks exactly like one of the Go problems your teacher is 
          always making you solve. Based on your knowledge, it looks 
          like ";
   switch(a) {
      1 : print "it is black's turn to play. All you have to do is determine 
                 where a stone must be played in order to allow the black 
                 stones to live. ^^";
      2 : print "it is white's turn to play. All you have to do is determine 
                 where a stone must be played in order to kill the black 
                 stones. ^^";
      3 : print "it is white's turn to play. All you have to do is determine 
                 where a stone must be played in order to kill the black 
                 stones. ^^";
      4 : print "it is white's turn to play. All you have to do is determine 
                 where a stone must be played in order to ensure the white 
                 stones will live. ^^"; }

      "To place a stone on the board, you'll have to specify which coordinate 
       to put the stone on, such as, ~PUT [or PLACE or PLAY] THE CRYSTAL STONE 
       ON E5.~";
];

!***************************************************************************
!**
!**  These routines set up and print out the four Go problems
!**  
!***************************************************************************

[ ClearPuzzleBoard i;
   for (i = 0: i <= 80: i++) ! Clear the 9x9 board
      puz_bd->i = 0;
];

[ PrintPuzzleBoard a i j;

!** This one works differently than the the other 9x9 board.
!** In this case, 1 = black, 2 = white and 3 = clear

!** First, set up the puzzles:

   switch (a) {
      1 : puz_bd->6  = 1;
          puz_bd->15 = 1;
          puz_bd->16 = 1;
          puz_bd->25 = 1;
          puz_bd->26 = 1;
          puz_bd->4  = 2;
          puz_bd->13 = 2;
          puz_bd->23 = 2;
          puz_bd->33 = 2;
          puz_bd->34 = 2;
          puz_bd->35 = 2;

      2 : puz_bd->7  = 1;
          puz_bd->8  = 1;
          puz_bd->16 = 1;
          puz_bd->15 = 1;
          puz_bd->24 = 1;
          puz_bd->33 = 1;
          puz_bd->42 = 1;
          puz_bd->43 = 1;
          puz_bd->44 = 1;
          puz_bd->13 = 2;
          puz_bd->22 = 2;
          puz_bd->31 = 2;
          puz_bd->41 = 2;
          puz_bd->50 = 2;
          puz_bd->51 = 2;
          puz_bd->52 = 2;
          puz_bd->53 = 2;

      3 : puz_bd->7  = 1;
          puz_bd->14 = 1;
          puz_bd->15 = 1;
          puz_bd->16 = 1;
          puz_bd->17 = 1;
          puz_bd->13 = 2;
          puz_bd->21 = 2;
          puz_bd->23 = 2;
          puz_bd->24 = 2;
          puz_bd->25 = 2;
          puz_bd->26 = 2;

      4 : puz_bd->20 = 1;
          puz_bd->22 = 1;
          puz_bd->13 = 1;
          puz_bd->30 = 1;
          puz_bd->39 = 1;
          puz_bd->48 = 1;
          puz_bd->58 = 1;
          puz_bd->59 = 1;
          puz_bd->51 = 1;
          puz_bd->43 = 1;
          puz_bd->34 = 1;
          puz_bd->6  = 2;
          puz_bd->15 = 2;
          puz_bd->16 = 2;
          puz_bd->17 = 2;
          puz_bd->23 = 2;
          puz_bd->24 = 2;
          puz_bd->33 = 2;
          puz_bd->31 = 2;
          puz_bd->40 = 2;
          puz_bd->41 = 2; }

   font off;
   for (i=0: i<=80: i++) {
      if (i%9 == 0) {
         j = (i / 9) + 1;
         print (char) go_coord->j;
         print "  "; }

      switch (puz_bd->i) { 
         0 : if (i == 20 || i == 24 || i == 56 || i == 60) 
                print "+ "; else print ". ";
         1 : print "X ";
         2 : print "O ";
         3 : print "C "; }

      if (i%9 == 8)
         print "^"; }

   print "^   1 2 3 4 5 6 7 8 9^^";
   font on;      

   print "^Legend:^^";
   print "X: Black stones^";
   print "O: White stones^";

   j = 0;
   for (i=0: i<=80: i++)
      if (puz_bd->i == 3) j++;
   
   if (j > 0)
      "C: Crystal stone";
   else
      rtrue;
];

!***************************************************************************
!**
!**  Initialise
!**
!***************************************************************************

[Initialise i;

   lookmode = 2;         ! Verbose

   stair1 = 0;
   stair2 = 0;
   stair3 = 0;
   stair4 = 0;
   stair5 = 0;

   combo1 = random(100) - 1;
   combo2 = random(100) - 1;
   combo3 = random(100) - 1;

   for (i = 0: i <= 80: i++) ! Clear the 9x9 board
      go_bd->i = 0;

   go_bd->20 = 1; ! Put the four black stones in position
   go_bd->24 = 1;
   go_bd->56 = 1;
   go_bd->60 = 1;

   location = Living_Room;

   "^^It is time for your weekly Go lesson. You have been coming to your 
    teacher's home for the past six months and though she isn't 
    extravagant with her praise, you feel that your game is improving.

    ^^Smiling inwardly, you remember your teacher's words the last time you 
    called Go a 'game'. ~A 'game'!~ she said. ~Go is not just a game - it is 
    a reflection of your inner self!~

    ^^But you sense that something is wrong: your teacher doesn't answer 
    your knock, and in fact the front door is unlocked. Curious, you step 
    inside...^";
];

Include "Grammar";

!***************************************************************************
!**
!**  Verbs and Their Routines
!**
!***************************************************************************

Verb 'plug' = 'put';

Verb 'chew' = 'eat';

Verb 'pour' = 'empty';

Verb 'spin' = 'turn';

Verb 'flip' = 'turn';

Verb meta 'help' 'about' 'credits'
     *                                -> Help;

Verb meta 'hint' 'hints' 'walkthru' 'walkthrough'
     *                                -> Hint;

!***************************************************************************

[XyzzySub;
   print "^From ";
   style bold;
   print "The New Hacker's Dictionary";
   style roman;
   print ":^^";
   
   print "xyzzy /X-Y-Z-Z-Y/, /X-Y-ziz'ee/, /ziz'ee/, or /ik-ziz'ee/ adj.^^";

   print "[from the ADVENT game] The canonical 'magic word'. This comes from 
          ADVENT, in which the idea is to explore an underground cave with many
          rooms and to collect the treasures you find there. If you type 'xyzzy' 
          at the appropriate time, you can move instantly between two otherwise 
          distant points.^^"; 

   print "Xyzzy has actually been implemented as an undocumented no-op command 
          on several OSes; in Data General's AOS/VS, for example, it would
          typically respond ~Nothing happens,~ just as ADVENT did if the magic 
          was invoked at the wrong spot or before a player had performed the action 
          that enabled the word. In more recent 32-bit versions, by the way, 
          AOS/VS responds ~Twice as much happens.~^";
];

Verb 'xyzzy'
     *                                -> Xyzzy;

!***************************************************************************

[ BounceSub ;
   "That doesn't work.";
];

Verb 'bounce'
     * noun                           -> Bounce;

!***************************************************************************

[ ZorkSub ;
   print "^From ";
   style bold;
   print "The New Hacker's Dictionary";
   style roman;
   print ":^^";

   print "Zork: /zork/ n. The second of the great early experiments in 
          computer fantasy gaming. Originally written on MIT-DM during the 
          late 1970s, later distributed with BSD UNIX (as a patched, 
          sourceless RT-11 Fortran binary) and commercialized as 'The Zork 
          Trilogy' by Infocom.^^";

   print "Shameless plug: For those of you who use Hugo to play interactive 
          fiction, check out my port of Zork I (called 'Hugo Zork') on the
          Interactive Fiction archive at ftp.gmd.de or one of its mirrors.^";
];

Verb 'zork'
     *                                -> Zork;

!***************************************************************************

[ FlushSub ;
   "You can't flush that.";
];

Verb 'flush'
     * noun                           -> Flush;

!***************************************************************************

[ PlaySub ;
   "Well, if it will make you feel better...";
];

[ PlayGoSub ;
   "You can't do that until you find your teacher.";
];

Verb 'play'
     * 'go'                           -> PlayGo
     * noun                           -> Play
     * 'with' noun                    -> Play
     * multiheld 'on' square          -> PlayStone
     * multiheld 'at' square          -> PlayStone;

!***************************************************************************

Verb 'place'
     * multiheld 'on' square          -> PlayStone
     * multiheld 'at' square          -> PlayStone;

Verb 'capture'
     * noun                           -> Capture
     * square                         -> Capture
     * 'from' square                  -> Capture;

!***************************************************************************

[ CountSub ;
   LostMind(); 
];

Verb 'count'
     * noun                           -> Count;

!***************************************************************************

[ ShakeSub ;
   "Nothing happens.";
];

Verb 'shake'
     * noun                           -> Shake;

!***************************************************************************

[ RebootSub ;
   "That usually only works on computers.";
];

Verb 'reboot' 'boot'
     * noun                           -> Reboot;

!***************************************************************************

[ ResetSub a b;
   if (location == go_room && noun == small_board) {
      for (a = 0: a < 81: a++) {
         b = go_bd->a;
         switch (b) {
            2: move stone1 to player; give stone1 ~concealed;
            3: move stone2 to player; give stone2 ~concealed;
            4: move stone3 to player; give stone3 ~concealed;
            5: move stone4 to player; give stone4 ~concealed;

            6: move stone5 to player; give stone5 ~concealed;
            7: move stone6 to player; give stone6 ~concealed;
            8: move stone7 to player; give stone7 ~concealed;
            9: move stone8 to player; give stone8 ~concealed;

           10: move gold_stone1 to player; give gold_stone1 ~concealed; }

           if (go_bd->a > 1) go_bd->a = 0; }
      print "^";
      PrintBoard(); }

    else
      "That usually only works on computers.";
];

Verb 'reset'
     * noun                           -> Reset;

!***************************************************************************

[ AbortSub ;
   "That's doesn't work.";
];

Verb 'abort' 'stop'
     *                                -> Abort
     * noun                           -> Abort;

!***************************************************************************

[ MutterSub ;
   "Speak up!";
];

Verb 'mutter' 'mumble'
     *                                -> Mutter;

!***************************************************************************

[ YellSub ;
   "Go players are known to have more dignity than that.";
];

Verb 'yell' 'scream'
     *                                -> Yell;

!***************************************************************************

![ PrySub ;
!   if (second == 0)
!      "You'll have to specify what you want to pry ", (the) noun, " with.";
!   else
!      "That doesn't work.";
!];

!Verb 'pry'
!     * noun                           -> Pry
!     * noun 'with' noun               -> Pry;

!***************************************************************************

[ BeatSub ;
   "That's not really designed for that - acoustics and all, you know.";
];

Verb 'bang' 'beat' 'tap' 'rap'
     * noun                           -> Beat;

!***************************************************************************

[ GetWithSub ;
   "Try re-wording that or be more specific.";
];

Extend 'get'
      * noun 'with' noun              -> GetWith;

!***************************************************************************

Extend 'put' first
     * multiheld 'on' square          -> PlayStone
     * multiheld 'at' square          -> PlayStone;

Extend 'take'
     * square                         -> TakeStone
     * multi square                   -> TakeStone
     * multi 'at' square              -> TakeStone
     * multi 'from' square            -> TakeStone
     * multi 'on' square              -> TakeStone;

Extend 'get'
     * square                         -> TakeStone
     * multi square                   -> TakeStone
     * multi 'at' square              -> TakeStone
     * multi 'from' square            -> TakeStone
     * multi 'on' square              -> TakeStone;
     
Extend 'remove'
     * square                         -> TakeStone
     * multi square                   -> TakeStone
     * multi 'at' square              -> TakeStone
     * multi 'from' square            -> TakeStone
     * multi 'on' square              -> TakeStone;

!***************************************************************************

[ AttackWithSub ;
   if (noun == second)
      LostMind();
   else
      "That's a good way to relieve stress, but now is not the time.";
];

Extend 'swing'
     * held 'at' noun                 -> AttackWith reverse;

Extend 'attack'
     * noun 'with' held               -> AttackWith;

!***************************************************************************

Extend 'exit'
     * noun                           -> Exit;

!***************************************************************************

[ VerbositySub ;
   "A hollow voice says, ~Leave that alone.~";
];

Extend 'superbrief' replace
     *                                -> Verbosity;
Extend 'verbose' replace
     *                                -> Verbosity;
Extend 'brief' replace
     *                                -> Verbosity;

!***************************************************************************

[ TurnDialSub;
   dial_setting = second;
   "You turn the dial to ", dial_setting, ".";
];

Extend 'turn'
     * dialable 'to' number           -> TurnDial;

!***************************************************************************

[ LookBehindSub ;
   if (location hasnt light)
      "But it's dark.";

   if (noun has nobehind)
      "You'll have to show me how to do that.";

   "You find nothing of interest.";
];

Extend 'look'
     * 'behind' noun                  -> LookBehind;

!***************************************************************************

Extend 'jump'
     * 'on'                           -> Jump
     * 'on' noun                      -> Jump;

!***************************************************************************

[ PushWithSub ;
    "Nothing happens.";
];

Extend 'push'
     * noun 'with' noun               -> PushWith;

!***************************************************************************

Extend 'empty'
     * noun 'in' noun                 -> EmptyT;

!***************************************************************************

Extend 'eat' first
     * noun                           -> Eat;
