!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                  Part 4 - Elemental Rooms (Continued)
!**
!***************************************************************************

!***************************************************************************
!**
!**  Objects
!**  
!***************************************************************************

Object open_bowl "Go bowl"
   with name "kaya" "gold" "colored" "gold-colored" "fine" "grained" 
             "fine-grained" "wood" "wooden" "go" "bowl" "go-ke" "ke",
        description [;
           print "Like the Go bowls in the living room, this one is made 
                  from gold-colored, fine-grained kaya wood. ";

           <<Search self>>;
        ],
        before [;
           Receive:
              if (noun hasnt stone)
                 "That doesn't go in there.";

           Open:
              "It's already open.";

           Close:
              "You don't have a lid to close it with.";

           Burn:
              if (second == match && match has light) {
                 deadflag = 1;
                 "A booming voice says ~Wrong, cretin!~ and
                  you notice that you have turned into a pile
                  of dust. Wait - wrong game.... Oh, well, too late
                  now."; }
              rfalse;

           Push, Pull, Take, Shake:
              "It's fixed in place.";
        ],
   has  scenery container open ~openable;

crystal_stone crystal_stone1 "crystal Go stone";

Object teacher "teacher"
   with name "teacher" "chinese" "woman" "lady" "kimono" "silk" "elaborate"
             "eyes" "young" "old",
        description
           "Your teacher has that amazing ability to look old and young at 
            the same time. While she usually appears in blue jeans, today 
            she is wearing an elaborate silk kimono. There is also none of 
            her normal familiarity or joking; she has a look like there is 
            a great deal at stake. She seems to be impelling you to direct 
            your concentration to the Go board.",
        describe
           "^Your teacher is here, waiting patiently.",
        life [;
           Answer: 
              "She replies, ~You need to pay attention to your lesson.~";

           Ask:
              switch(second) {
                 'book', 'books':
                    "~I've been collecting those books for many years.~";

                 'diary':
                    if (diary has general)
                       "You decide it is better to not talk about that.";
                    else
                       "~I started writing a diary a long time ago. You 
                        haven't been reading it, have you?~";

                 'board':
                    "~It was given to me by my teacher - it is very old.~";

                 'go': 
                    "~The greatest game in the world - but it's not just a
                     game, is it?~";

                 'stone', 'stones':
                    "~I made these stones myself.~";
                    
                 'me':
                    "~Right now you need to pay attention to this lesson.~";

                 'cube', 'cubes':
                    "~They represent four of the five basic elements. I 
                     received them as a gift a long time ago.~";

                 'house':
                    "~There's more to it than you thought, isn't there?~";

                 'waterwheel', 'lathe', 'oven', 'furnace', 'kiln':
                    "~That's just some extra equipment left over from 
                     my other projects.~";

                 'sphere', 'spheres', 'lesson', 'score':
                    "~You have to put the white sphere in the depression that 
                     corresponds to white's score, and the black sphere 
                     in the depression that corresponds to black's score.~";

                 'teacher', 'herself', 'her':
                    "She just chuckles.";

                 'zork', 'reversi', 'reverzi', 'tetris':
                    "~It's good, but Go is better~.";

                 'sculpture':
                    "She smiles and says, ~I've enjoyed watching it grow, but
                     I have to admit, it's somewhat more difficult to prune 
                     than a bonsai tree.~"; }

              "~You must find your own answer.~";

           Show, Give:
              switch(noun) {
                 diary:
                    remove diary;
                    give diary general;
                    "With a quick movement of her hand she reaches over and 
                     takes the diary from you, then hides it in the folds of 
                     her kimono."; }

              "Your teacher merely stares at you.";

           ThrowAt, Attack, Kiss:
              "That would not be wise.";
        ],
        orders [ ;
           "You know better than to say that.";
        ],
        before [;
           Take:
              "I wouldn't try that if I were you.";
        ],
   has  animate female;

Object earth "tightly packed earth"
   with name "walls" "walls" "floor" "ceiling" "room" "chamber" "tightly" 
             "packed" "earth" "cement",
        description
           "The earth is tightly packed and has the feel of cement.",
        found_in Room3 Room3N Room3S Room3E Room3W,
   has  scenery;

Object black_sphere "perfect black sphere"
   with name "perfect" "black" "slate" "sphere",
        number 0,
        article "a",
        description [;
           print "A perfect black sphere, made of slate. ";
           
           if (self.number ~= 0)
              "It currently rests in depression number ", self.number, ".";
           else
              new_line; rtrue;
        ];

Object white_sphere "perfect white sphere"
   with name "perfect" "white" "clam" "shell" "clamshell" "sphere",
        number 0,
        article "a",
        description [;
           print "A perfect white sphere, made of clamshell. ";

           if (self.number ~= 0)
              "It currently rests in depression number ", self.number, ".";
           else
              new_line; rtrue;
        ];

Object ped_depressions "depression"
   with name "shallow" "depression" "depressions" "circular",
        description [; 
          print "One hundred shallow circular depressions, each numbered 
                 from one to 100, are arranged in a 10 by 10 pattern on 
                 the surface of the pedestal. ^";

          if (white_sphere.number ~= 0)
             "^The white sphere rests in depression ", white_sphere.number, ". ";

          if (black_sphere.number ~= 0)
             "^The black sphere rests in depression ", black_sphere.number, ".";
        ],
        before [;
           Receive:
              if (noun ~= white_sphere or black_sphere)
                 "That doesn't go there.";

              "Try putting the sphere in a specific depression, such as, 
               ~PUT THE WHITE SPHERE IN 12.~";

           Push:
              "Nothing happens.";
        ],
   has  scenery;

Object ped_holes "pedestal depression"
   with description [; <<Examine ped_depressions>>; ],
        number 0,
        parse_name [ i ;
           last_hole = -1;
           i=TryNumber(wn);
           if (i > 0 && i < 101) {
              last_hole = i;
              return 1; }
           else
              return 0;
        ],
        before [;
           Receive:
              if (noun ~= white_sphere or black_sphere)
                 "That doesn't go there.";

              if (last_hole < 1)
                 "You'll have to specify which depression you want to put ",
                  (the) noun, " in, such as, ~PUT THE WHITE SPHERE IN 12.~";

              if ((noun == black_sphere && white_sphere.number == last_hole) ||
                  (noun == white_sphere && black_sphere.number == last_hole))
                 "There's already something there.";

              move noun to self;
              give noun concealed;
              noun.number = last_hole;
              "You place ", (the) noun, " in the depression numbered ",
               noun.number, ".";

           LetGo:
              noun.number = 0;
              give noun ~concealed;
              rfalse;

           Push: <<Push ped_depressions>>;
        ],
        each_turn [;
           if (white_sphere.number ~= 0 && black_sphere.number ~= 0) {
              self.number++;
              if (white_sphere.number == 72 && black_sphere.number == 68) {
                 Achieved(17);
                 deadflag = 2;
                 new_line;
                 print "As you place the second sphere on the pedestal, you 
                        feel a deep rumble from within the earth. The 
                        pedestal vibrates for a moment, rotates ninety
                        degrees, then slowly sinks out of sight into a hole in 
                        the floor. A stairway is revealed, leading down into 
                        darkness.^^";

                 print "~As you can see,~ your teacher says, ~that was not very 
                        difficult. However, the value of a lesson is not 
                        determined by its difficulty, but by what it teaches. 
                        In this case, the question was who won or lost this game 
                        of Go. I once told you that Go is not just a game - it 
                        is a reflection of your inner self. It can also be 
                        said to be a reflection of the world around us. All 
                        life must have balance - this is the concept of yin 
                        and yang. The point of this lesson was to show you 
                        that there is an imbalance in the world, an imbalance 
                        which must be corrected. I have labored my whole life 
                        towards this end, but now I've grown old...~^^";

                 print "She pauses, as if collecting her thoughts. Slowly at 
                        first, then with increasing speed, she changes. Her body 
                        begins to grow and change shape. You stare, transfixed, 
                        as she becomes a dragon. A Chinese dragon, to be exact. 
                        One with a wingless, sinuous and scaled body, a large 
                        horned and whiskered head, and four stumpy clawed 
                        legs. ^^";

                 print "The dragon/teacher heads towards the newly revealed 
                        stairway. Just before entering, she speaks. You expect 
                        a loud, raspy roar, but it is your teacher's old 
                        voice; that alone has not changed. ~As I said, I've 
                        grown old, too old to continue what must be done. You 
                        have proven to be a worthy apprentice. Come with me, 
                        for there is much for you to learn.~^^"; 
                 rtrue; }

              else {
                 move white_sphere to player;
                 move black_sphere to player;
                 white_sphere.number = 0;
                 black_sphere.number = 0;
                 new_line;
                 switch(self.number) {
                    1, 3 : "Your teacher removes the spheres and hands them
                            back to you. ~Incorrect,~ she says.";
                 
                    2 : "A frown crosses your teacher's face for a moment, then
                         she removes the spheres and hands them back to you. 
                         ~Incorrect,~ she says.";

                    4 : deadflag = 3;
                        print "You sense that your teacher is angry and 
                               disappointed, even though her face betrays no 
                               emotion. She looks at you and says, ~Well, 
                               that is the end of today's lesson. In fact, 
                               that will be your last lesson for some time. 
                               Today I will be leaving on a long journey - 
                               I do not know when I will return. If you'll 
                               excuse me, I must get ready.~ She escorts you 
                               out of the house and locks the door behind 
                               you.^^";

                        print "That was the last time you ever saw your 
                               teacher. In the years to follow, you can't 
                               help wondering if there was some important 
                               lesson you failed to grasp, some doorway you 
                               failed to open...^^"; }
                 rtrue; }}
        ],
   has  scenery container open ~openable;

Object final_stones "Go stones"
   with name "black" "white" "Go" "stone" "stones",
        description
           "They are standard Go stones. The black stones are made of slate 
            and the white ones are made of clamshell.",
        before [;
           Take:
              "The stones are fixed in place.";
        ],
   has  scenery pluralname;

!***************************************************************************
!**
!**  "Earth" Area
!**
!***************************************************************************

Object Room3 "Earthen Chamber"
   with description [;
          print "The walls and floor of this chamber are composed of tightly 
                 packed earth. The air here is cool and dry. A marble pedestal
                 occupies the center of this room";

          if (Go_Board in pedestal_3)
             print "; the missing Go board rests on top of it. ";
          else
             print ". A 10 by 10 pattern of depressions covers the surface 
                    where the Go board had been. ";

          if (self hasnt general) {
             give self general;
             print "^^Seeing the Go board reminds you of the time your teacher
                    made you go look for a special herb in the forest behind
                    her house. Sometimes your ~Go lessons~ get pretty 
                    strange...^^"; }

          "There are steps leading up, and exits to the north, south, east 
           and west.";
        ],
        each_turn [ a b;
           for (a=1: a<=4: a++)
              if (answers->a == 1) b++;

           if (b == 4 && teacher hasnt general) {
              #ifdef INCLUDE_HINTS;
                 move endgame to hint_menu;
              #endif;
              give teacher general;
              move teacher to Room3;
              move ped_depressions to pedestal_3;
              move ped_holes to pedestal_3;
              move white_sphere to player;
              move black_sphere to player;
              move Go_Board to Room3;
              move final_stones to Go_Board;
              print "^As you enter the room, you see your teacher walking 
                     down the stairs. She walks up to the large Go board 
                     and motions for you to follow.^^";

              print "~Congratulations,~ she says in her light sing-song 
                     voice. ~By coming this far, you've shown your ability 
                     to, as they say, 'think outside the box.'~^^";

              print "Your teacher lifts the Go board off of its pedestal
                     and places it on the ground. You see many Go stones
                     on the board - you could have sworn they were not there
                     a moment ago. In addition, a 10 by 10 pattern of 
                     depressions covers the top of the pedestal - these must 
                     have been hidden by the board...^^";

              print "Your teacher hands you two spheres, one white and the 
                     other black. She continues: ~Now it is time for your 
                     lesson. Look closely at this board. Assuming a komi of 
                     zero and no captured stones, determine the score for 
                     this game. Put the white sphere in the depression that 
                     corresponds to white's score, and the black sphere in the 
                     depression that corresponds to black's score.~^^";

              print "[ Press any key to continue. ]^";

              Pause();
              @erase_window -1;
              <<Examine Go_Board>>; }
        ],
        before [;
           Go:
              if (teacher in location)
                 "You're right in the middle of a lesson.";

           Smell:
              "You smell a faint odor of incense.";
        ],
        u_to [; virtual_loc = 40; PlayerTo(Maze); return 1; ],
        n_to Room3N,
        s_to Room3S,
        e_to Room3E,
        w_to Room3W,
   has  light;

Object -> pedestal_3 "pedestal"
   with name "marble" "pedestal",
        description [;
           print "The marble pedestal occupies the center of the room. ";

           if (teacher in Room3)
              "A 10 by 10 pattern of depressions covers the surface where the 
               Go board had been.";
           else
              "A wooden Go board rests on top of it.";
        ],
        before [;
           Receive:
              if (Go_Board in self)
                 "There's already something there.";

              if (noun == white_sphere or black_sphere)
                 "Try putting the sphere in a specific depression, such as, 
                  ~PUT THE WHITE SPHERE IN 12.~";

              "That doesn't go there.";
        ],
   has  supporter scenery;

Object -> -> Go_Board "large Go board"
   with name "board" "go" "kaya" "floor" "pyramid" "shaped" "pyramid-shaped" 
             "indentation" "wood" "wooden" "large",
        description [;
           if (teacher notin Room3) {
              if (self hasnt general) {
                 give self general;
                 print "This is the missing Go board! It's "; }
              else
                 print "The board is ";
                 
              "made of kaya, a light yellow, fine-grained wood. It's at least 
               six inches thick and must have come from a kaya tree well over 
               two hundred years old."; }
           else {
              font off;
              new_line; new_line;
              print ". . . . . . . O X X . . X O . O . . .^
   	                . . . . . . . O O X . X X O O . . . .^
	                . . . O . . . O X X . X O O X O O O O^
	                . . . + . . . O O X X X X X X X X O O^
	                . . O . . . . O X X O O X O O X X X O^
	                . . . O . O O O X X O O O O O O O X X^
	                . . . . O X X X X O O X X X X X O O O^
	                . . . O X . . . X O X . . . . X O . O^
	                . . . O X . . . X X . X . . . . X O .^
	                . . . O X X X . X + . X . . . + X O O^
	                . . . . O O X X . . . X . . . X X X O^
	                O O O O O X . . . . . X X . . X X O O^
	                O X X X X X X X X X . . . . . X X X O^
	                O O O O O X . X O O X . . X . . . . X^
	                O X X X X X X X X O X . . . . X X . X^
	                X . . X O X O X O O X X X X X X . . X^
	                . X . X O O O O O O O X O O O O X X X^
	                . . . X X O . O . O X X O . O . O X O^
	                . . . X O O . . O X X X O . . O O O O^^";

               font on; }
        ],
        before [;
           Burn:
              if (second == match && match has light) {
                 deadflag = 1;
                 "A booming voice says ~Wrong, cretin!~ and
                  you notice that you have turned into a pile
                  of dust. Wait - wrong game.... Oh, well, too late
                  now."; }
               rfalse;

           Receive:
              if (noun has stone)
                 "Solitaire Go - what a concept!";
              else
                 "It's a Go board, not a table.";

           Search: <<LookUnder self>>;

           Take:
              if (self notin pedestal_3)
                 "That's not a wise thing to do in the middle of a lesson.";
              else
                 "It's firmly attached to the pedestal.";

           LookUnder:
              "Carved into the bottom of the board is a pyramid-shaped 
               indentation. There are several theories about its function; 
               one is that it improves the resonance and tone of the board 
               when a stone is rapped on its surface. Japanese folklore has 
               it that the well served to hold the blood of kibitzers who 
               were unwise enough to blurt out advice aloud during a game 
               and were beheaded on the spot. Others have speculated the 
               legend refers to a time when the ancestor of the Go board 
               itself was a pyramidal altar used for pessomancy - divination 
               by pebbles - and, possibly, for blood offerings from live 
               sacrifices.";
        ],
   has  scenery supporter;

Object Room3N "Northern Chamber"
   with description [;
          print "The walls and floor of this chamber are composed of tightly 
                 packed earth. A block of marble occupies the center of this 
                 room.";

           if (children(pedestal_3n) ~= 0) PrintCube(child(pedestal_3n).number);

           if (self has general)
              " There are exits to the north and south.";
           else
              " There is an exit to the south.";
        ],
        n_to [ ;
           if (self has general) return hallway_n;
           else
              rfalse;
        ],
        s_to Room3,
   has  light;

pedestal -> pedestal_3n "block of marble";

Object hallway_n "North-South Passageway"
   with description
           "You are in a long, narrow passageway that runs north and south.",
        n_to [;
           move open_bowl to pedestal_pn;
           move crystal_stone1 to open_bowl;
           return PuzzleRoomN;
        ],
        s_to Room3N,
   has  light;

Object PuzzleRoomN "Northern Testing Room"
   with description [;
           print "A marble pedestal dominates the center of this room. ";

           if (puzzle_board_n in pedestal_pn)
              print "A wooden Go board and bowl rest on top of the 
                     pedestal. "; 
           
           "The only exit is to the south.";
        ],
        s_to [;
           RemoveCrystal();
           return hallway_n;
        ],
   has  light;

Object -> stones_n "Go stones"
   with name "black" "white" "Go" "stones" "stone",
        description
           "They are standard Go stones - the white stones are made of
            clamshell and the black stones are made of slate.",
        before [;
           Take:
              "The stones are fixed in place.";
        ],
   has  scenery pluralname;

Object -> pedestal_pn "pedestal"
   with name "marble" "pedestal",
        description [;
           print "The marble pedestal occupies the center of the room. ";
           
           if (puzzle_board_n in self)
              "A wooden Go board and bowl rest on top of the pedestal. ";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              "There's already something there.";
        ],
   has  scenery supporter;

PuzzleBoard -> -> puzzle_board_n "small Go board"
   with description [ ;
           print "The wooden Go board rests atop the pedestal. Here is a
           close-up of the board:^^";

           PrintPuzzleBoard(1);
           PrintInstructions(1);
        ];

Object Room3S "Southern Chamber"
   with description [;
          print "The walls and floor of this chamber are composed of tightly 
                 packed earth. A block of marble occupies the center of this 
                 room.";

           if (children(pedestal_3s) ~= 0) PrintCube(child(pedestal_3s).number);

           if (self has general)
              " There are exits to the north and south.";
           else
              " There is an exit to the north.";
        ],
        n_to Room3,
        s_to [ ;
           if (self has general) return hallway_s;
           else
              rfalse;
        ],
   has  light;

pedestal -> pedestal_3s "block of marble";

Object hallway_s "North-South Passageway"
   with description
           "You are in a long, narrow passageway that runs north and south.",
        n_to Room3S,
        s_to [;
           move open_bowl to pedestal_ps;
           move crystal_stone1 to open_bowl;
           return PuzzleRoomS;
        ],
   has  light;

Object PuzzleRoomS "Southern Testing Room"
   with description [;
           print "A marble pedestal dominates the center of this room. ";

           if (puzzle_board_s in pedestal_ps)
              print "A wooden Go board and bowl rest on top of the 
                     pedestal. "; 
           
           "The only exit is to the north.";
        ],
        n_to [;
           RemoveCrystal();
           return hallway_s;
        ],
   has  light;

Object -> stones_s "Go stones"
   with name "black" "white" "Go" "stones" "stone",
        description
           "They are standard Go stones - the white stones are made of
            clamshell and the black stones are made of slate.",
        before [;
           Take:
              "The stones are fixed in place.";
        ],
   has  scenery pluralname;

Object -> pedestal_ps "pedestal"
   with name "marble" "pedestal",
        description [;
           print "The marble pedestal occupies the center of the room. ";
           
           if (puzzle_board_s in self)
              "A wooden Go board and bowl rest on top of the pedestal. ";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              "There's already something there.";
        ],
   has  scenery supporter;

PuzzleBoard -> -> puzzle_board_s "small Go board"
   with description [ ;
           print "The wooden Go board rests atop the pedestal. Here is a
           close-up of the board:^^";

           PrintPuzzleBoard(2);
           PrintInstructions(2);
        ];

Object Room3E "Eastern Chamber"
   with description [;
          print "The walls and floor of this chamber are composed of tightly 
                 packed earth. A block of marble occupies the center of this 
                 room.";

           if (children(pedestal_3e) ~= 0) PrintCube(child(pedestal_3e).number);

           if (self has general)
              " There are exits to the east and west.";
           else
              " There is an exit to the west.";
        ],
        w_to Room3,
        e_to [ ;
           if (self has general) return hallway_e;
           else
              rfalse;
        ],
   has  light;

pedestal -> pedestal_3e "block of marble";

Object hallway_e "East-West Passageway"
   with description
           "You are in a long, narrow passageway that runs east and west.",
        w_to Room3E,
        e_to [;
           move open_bowl to pedestal_pe;
           move crystal_stone1 to open_bowl;
           return PuzzleRoomE;
        ],
   has  light;

Object PuzzleRoomE "Eastern Testing Room"
   with description [;
           print "A marble pedestal dominates the center of this room. ";

           if (puzzle_board_e in pedestal_pe)
              print "A wooden Go board and bowl rest on top of the 
                     pedestal. ";
           
           "The only exit is to the west.";
        ],
        w_to [;
           RemoveCrystal();
           return hallway_e;
        ],
   has  light;

Object -> stones_e "Go stones"
   with name "black" "white" "Go" "stones" "stone",
        description
           "They are standard Go stones - the white stones are made of
            clamshell and the black stones are made of slate.",
        before [;
           Take:
              "The stones are fixed in place.";
        ],
   has  scenery pluralname;

Object -> pedestal_pe "pedestal"
   with name "marble" "pedestal",
        description [;
           print "The marble pedestal occupies the center of the room. ";
           
           if (puzzle_board_e in self)
              "A wooden Go board and bowl rest on top of the pedestal. ";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              "There's already something there.";
        ],
   has  scenery supporter;

PuzzleBoard -> -> puzzle_board_e "small Go board"
   with description [ ;
           print "The wooden Go board rests atop the pedestal. Here is a
           close-up of the board:^^";

           PrintPuzzleBoard(3);
           PrintInstructions(3);
        ];

Object Room3W "Western Chamber"
   with description [;
          print "The walls and floor of this chamber are composed of tightly 
                 packed earth. A block of marble occupies the center of this 
                 room.";

           if (children(pedestal_3w) ~= 0) PrintCube(child(pedestal_3w).number);

           if (self has general)
              " There are exits to the east and west.";
           else
              " There is an exit to the east.";
        ],
        e_to Room3,
        w_to [ ;
           if (self has general) return hallway_w;
           else
              rfalse;
        ],
   has  light;

pedestal -> pedestal_3w "block of marble";

Object hallway_w "East-West Passageway"
   with description
           "You are in a long, narrow passageway that runs east and west.",
        e_to Room3W,
        w_to [;
           move open_bowl to pedestal_pw;
           move crystal_stone1 to open_bowl;
           return PuzzleRoomW;
        ],
   has  light;

Object PuzzleRoomW "Western Testing Room"
   with description [;
           print "A marble pedestal dominates the center of this room. ";

           if (puzzle_board_w in pedestal_pw)
              print "A wooden Go board and bowl rest on top of the 
                     pedestal. ";
           
           "The only exit is to the east.";
        ],
        e_to [;
           RemoveCrystal();
           return hallway_w;
        ],
   has  light;

Object -> stones_w "Go stones"
   with name "black" "white" "Go" "stones" "stone",
        description
           "They are standard Go stones - the white stones are made of
            clamshell and the black stones are made of slate.",
        before [;
           Take:
              "The stones are fixed in place.";
        ],
   has  scenery pluralname;

Object -> pedestal_pw "pedestal"
   with name "marble" "pedestal",
        description [;
           print "The marble pedestal occupies the center of the room. ";
           
           if (puzzle_board_w in self)
              "A wooden Go board and bowl rest on top of the pedestal. ";
           else
              new_line; rtrue;
        ],
        before [;
           Receive:
              "There's already something there.";
        ],
   has  scenery supporter;

PuzzleBoard -> -> puzzle_board_w "small Go board"
   with description [ ;
           print "The wooden Go board rests atop the pedestal. Here is a
           close-up of the board:^^";

           PrintPuzzleBoard(4);
           PrintInstructions(4);
        ];

