/*
	-------------------------------------------
	HUGO Front End for the Sega Dreamcast
	Copyright (c) 2004
        Eyatn Kaziberdov
	-------------------------------------------


        The follwing files are needed to make
	the dreamcast port he.c dcio.h dcio.c hedc.c
        Requires KOS V1.2.0 by Dan Potter to compile.
*/

#include "heheader.h"
#include<kos.h>
extern int dcwinleft,dcwintop,dcwinright,dcwinbottom;
char charrom[2048];
char keyboard;
static unsigned char x=0,y=0;   //screen co-ords
unsigned short *fbuffer=0xa5000000;
char bug=0;

///////////////////////////////////////////////////////////////////////////

void dcprintf(uint16 *address,int scrnwidth,int reverse, unsigned char character,uint16 color,uint16 bcolor){
     uint8 i,j,k=0;
     uint16 *screenptr;
     uint8 bitmask;
     int c;


     for(i=0;i<16;i+=2){
        bitmask=0x80;

        for(j=0;j<8;j++){
            c=charrom[k+((character)*8)]&(bitmask); //get char 1 bit at a time
            if(reverse!=0)c=!c;  //negate the bit so the char is reversed
            bitmask = bitmask >>1; //prepare to get next bit
            if(c!=0){
            screenptr=address+(i*640);
            screenptr[j]= color;      //draw the bit from the char as a pixel on screen
            //screenptr[j+1]= color; //if you want 40x25

            screenptr=address+(i*640)+640; //remove section if you want 80x50 or 40x50
            screenptr[j]= color;
            //screenptr[j+1]= color; //if you want 40x25

           }
            else{
            screenptr=address+(i*640);
            screenptr[j]= bcolor;
            //screenptr[j+1]= 0x0000; //if you want 40x25

            screenptr=address+(i*640)+640; //remove section if you want 80x50 or 40x50
            screenptr[j]= bcolor;
            //screenptr[j+1]= 0x0000; //if you want 40x25
            }
            }//end for J
            k++; //move pointer to next (byte) or line of bits in the character
            }//end for I
        }//end dcprintf
///////////////////////////////////////////////////////////////////////////
int getkey(){
	int c;

        c=-1;
        while(c==-1){
        c=kbd_get_key();

        }
        return c;

}
///////////////////////////////////////////////////////////////////////////
void sdcprintf(uint16 *address,int scrnwidth,int reverse, char * character,uint16 color,uint16 bcolor){
     while(*character){
          if(*character>=32 && *character<=122 ){
                          dcprintf( fbuffer+(y*16*640)+(x*8),640,0, *character,color,bcolor);
                          x++;
          }//end ascII
      
          if(x>dcwinright-1){
                  y++;
                  x=0;
                  if(y>dcwinbottom-1){
                  y=dcwinbottom-1;
                  scroll();
                  }
                  }

        if((*character=='\r'))x=0;
        if((*character==0x0d)){
                  y++;
                  x=0;
                  if(y>dcwinbottom-1){
                  y=dcwinbottom-1;
                  scroll();
                  }
          }
        bug=character;
        character++;
     }

}
///////////////////////////////////////////////////////////////////////////

void xprintf(char *character, int color,uint16 bcolor){
  sdcprintf((fbuffer+(y*16*640)+(x*8)),640,0, character,color,bcolor);
}
///////////////////////////////////////////////////////////////////////////

void xprintc(char character, int color,uint16 bcolor){
  if(character>=32 && character<=122 ){
  dcprintf((fbuffer+(y*16*640)+(x*8)),640,0, character,color,bcolor);
  x++;

          if(x>dcwinright-1){
                  y++;
                  x=0;
                  if(y>dcwinbottom-1){
                  y=dcwinbottom-1;
                  scroll();
                  }
                  }

           }//end acII
           if((character==0x0d)){
                  y++;
                  x=0;
                  if(y>dcwinbottom-1){
                  y=dcwinbottom-1;
                  scroll();
                  }
          }

}
///////////////////////////////////////////////////////////////////////////
void scroll(void){
unsigned long *dest,*src;
unsigned long i,lines;
dest=fbuffer+(640*(16*(dcwintop-1)));
src=dest+(320*16);
unsigned long calc;
extern int bcolor;
lines=dcwinbottom-dcwintop;

for(lines=0;lines<(dcwinbottom-dcwintop);lines++){
        for(i=0;i<16*320;i++){
             *dest=*src;
              dest++;
              src++;
        }
}

for(i=0;i<(16*320*1);i++){
      *dest=bcolor+bcolor*0x10000;
       dest++;
}

}
///////////////////////////////////////////////////////////////////////////
int loadfont(){
 FILE *fh;

	if (!(fh=fopen("/rd/font.bin","rb")));
        fread(charrom,1,1400,fh);
        fclose(fh);
}
///////////////////////////////////////////////////////////////////////////
void clearscreen(){
  vid_empty(); //clear the screen start over
                  x=0;
                  y=0;
}
///////////////////////////////////////////////////////////////////////////
void clearwin(int bcolor){
 unsigned short *dest;
 unsigned long i;
 dest=fbuffer+(640*(16*(dcwintop-1)))+(8*(dcwinleft-1));
 for(i=0;i<(dcwinbottom*16*640);i++){
           *dest=bcolor;
           dest++;
}

 x=dcwinleft-1;
 y=dcwintop-1;
}
///////////////////////////////////////////////////////////////////////////
void settextpos(int xpos,int ypos){

                  x=(xpos-1)+(dcwinleft-1);
                  y=(ypos-1)+(dcwintop-1);
                  if(y>dcwinbottom-1)y=dcwinbottom-1;
                  if(x>dcwinright-1)x=dcwinright-1;

 }

///////////////////////////////////////////////////////////////////////////
getinput(int color,int bcolor){
      //extern *buffer;
      //extern int bcolor,color;
      int done=0;
      short ch;  //used to get a char
      char counter=0;
      while(!done){

      dcprintf(fbuffer+(y*16*640)+x*8,640,1,' ',0x4000,bcolor);//make a nice red cursor
      ch=getkey();
      dcprintf(fbuffer+(y*16*640)+x*8,640,0,' ',0x0000,bcolor);//erase the cursor

      if(ch==0x0d){ //hit return
                 buffer[counter]=0x00;
                 done=1;
                 }

      if(ch==0x08 && x>0 && counter>0){ //hit delete
                 x--;// back up the x
                 dcprintf(fbuffer+(y*16*640)+x*8,640,0,' ',color,bcolor); //erase the character
                 counter--;
                 buffer[counter]=0x00;

                 }
      if(ch>=32 && ch<=122 ){//check if it's a printable character
                dcprintf(fbuffer+(y*16*640)+x*8,640,0,ch,color,bcolor);
                 x++;
                 buffer[counter]=ch; //just for fun
                 counter++;

                }//ascii check


       if(x>40){ //reached the end of a line
                 x=0; //position back to start
                 y++; //one line down
               }//end x check


      }//end done

}
///////////////////////////////////////////////////////////////////////////
unsigned long showdir(void){
dirent_t *de;
file_t d;
char name[128][32],index=0,selection=0,total=0,c,i,done=0;

while(kbd_get_key()!=-1);
//load the games off the dir
	d = fs_open("/cd/", O_RDONLY | O_DIR);
        de = fs_readdir(d);
        if (!d) {

	} else {

        while ( (de = fs_readdir(d)) ) {
			strcpy(&name[index],de->name);
                        index++;
                        if (index >= 48)  //load a directory max 48 items
				  break;
                }
 }
fs_close(d);
x=6;
sdcprintf(fbuffer+(0*16*640)+10*8,640,0,"[A]UP    [Z]Down          [Enter]Selects Games",0x7fff,0x0000);

while(!done){
x=10;
y=1;
for(i=0;i<index;i++){
    if(selection==i){
    sdcprintf(fbuffer+(y*16*640)+x*8,640,0,name[i],0x7fff,0x0000);

    }else{
    sdcprintf(fbuffer+(y*16*640)+x*8,640,0,name[i],0x4210,0x0000);

    }
    y++;
    if(i<24){x=10;}else{x=50;}
    if(i==24)y=1;
    }
c=getkey();
//if(c=='p'){
//         strcpy(gamefile,"/rd/pirate.hex");
//         return;
//}

if(c==0x0d)done=1;

if(c=='a' &&selection>0)selection--;
if(c=='z' &&selection<47)selection++;

    }//end while
 strcpy(gamefile,"/cd/");
 strcat(gamefile,name[selection]);

}//end showdir

