/*
** This file contains general information for the story, such as:
	include files
	version information
	modifications to adv.t that are specific to this story (other than Actor)
 	new and modified verbs
*/
#include <adv.t>  // CONFIG.TC loads adv.o with -l option first.
#pragma c+
#include "carlstd.t"
#include "rooms.t"
#include "items.t"
#include "actors.t"
#include "walk.t"
#define STORYVERSION "1.0"

/*
** To be implemented at some point in the future:
**
** NOTE: These are things I was aware of BEFORE feedback from the contest.
**
// Require confirmation that they want a hint.
** Make sure explicit hints can actually be followed.
** Make sure that every unusual command that MUST be entered
	(other than look, directions, etc. but including consultation of the
	almanac etc.) is reflected via HINT.
** Fly can't lap at the congealed grease if the lunch is in the hat.
** Need better ways of talking: SAY "" TO DRAGON; TELL DRAGON ""; DRAGON, ""
** Can we avoid having ALL refer to worn clothes, or at least confirm?
** UNBAR DOOR shouldn't ask which.
** Probably shouldn't be able to read just because alien has the fixed box.
** Shouldn't really be able to speak or read or understand as alien either.
** [MORE] -> [Press SPACE for more.]
** OFFER <actor> <item>
** What if people say back to the alien or dragon the same thing he says?
** Improve slice management somehow.
** GET ALIEN.  DROP HIM.
** Alien should react to talking fly.
** Guards get confused if you cluple Oswale
** ASK ALIEN ABOUT BUTTONS only gives monKnows for one button.
** Should be able to talk to guard in an adjacent room through gates.
** Implement the dungeon.
** Use bar as a battering ram.
** Check for consistency in alien language
** Raise and lower should apply to the portcullis.
** Flammable things placed in the oven should ignite!
** X <room> should be same as LOOK
** Make a west tower, with guard quarters up and dungeon down.
** Object should break when it falls.
** Modify doorway to use the "inside" setting to allow locking/unlocking.
** Guard shouldn't let you in if you knock when you look like an alien!
** LOOK IN THE HOLE
** TAUNT DRAGON (annoy, tease)
** How do you change zefron back if he's down in the pit?
** WAVE AT | SMILE AT | GREET <actor> (or with no dobj)
** YELL "ZEFRON"
** Ordering guard out of courtyard makes him vanish!
** Look into adjacent rooms
** Throw items into adjacent rooms.
** GIVE <ACTOR> <ITEM>
** MAKE BOOK
** FLY OVER <THING>
** monKnows ought to change after alien has seen the box work.
** SLICE BREAD then SLICE BREAD then SLICE LOAF OF BREAD.
** The bar really shouldn't be a keyitem.
** Add help for ALL, AND, BUT, multiple dobjs, pronouns, significant # of chars
** Add commands for inspecting and setting object properties directly
** Eliminate the comma as a command separator (use period instead).
** Maybe people can climb gate if they throw a cushionitem over the top?
** If you retype a command after being asked for clarification, sometimes the new
	command has no effect.
*/

// XXXf Temporary debugging commands.
debuggo: sysverb
	verb = 'debuggo'
	action(actor) = {
		say(datatype(monstrosity.noun));
		carpet.moveInto(hat);
		jam.moveInto(hat);
		testtoast.moveInto(hat);
		almanac.moveInto(hat);
		lunch.moveInto(hat);
		sword.moveInto(hat);
		sword.issharp = true;
		hat.moveInto(Me);
		Me.moveInto(town);
	}
;
bamfVerb: sysverb
	verb = 'bamf'
	sdesc = "bamf"
	doAction = 'Bamf'
	validDo(actor, obj, seqno) = true
	validDoList(actor, prep, dobj) = nil
;
modify thing
	verDoBamf(actor) = {if (isclass(self, floatingItem)) "Can't bamf floater.";}
	doBamf(actor) = {
		if (isclass(self, room)) {
			Me.travelTo(self);
		} else {
			self.moveInto(Me.location);
		}
	}
;
testtoast: slice
	sdesc = "test toast"
	noun = 'toast'
	plural = 'slices' 'bread'
	adjective = 'test' 'perfectly' 'toasted'
	toastlevel = 2
;

/*
** Predeclare functions.
*/
end: function;
terminate: function;
scoreRank: function;
scoreStatus: function;
rescue: function;
checkReach: function;

// VERSION INFO
version: helpTopic
    noun = 'license' 'story' 'game'
    title = "\(Poor Zefron's Almanac\):  An interactive cross-genre romp."
    sdesc = {
    	self.title;
	"\nCopyright (c) 1997 Carl W.\ Klutzke.  All rights reserved.
	Version << STORYVERSION >>\n
 	Built on << __DATE__ >> at << __TIME__ >> with TADS version
	<< __TADS_VERSION_MAJOR >>.<< __TADS_VERSION_MINOR >> for
	<< __TADS_SYSTEM_NAME >>.\n";
	"Enter \(HELP\) for story and interpreter information.\b";
    }
    hentry = {
	"\"";
	self.sdesc;
	"This work of interactive fiction is provided as \"freeware.\"  Please distribute
	freely, but don't charge money for it or alter it without the author's permission.
	\b\(CONSULT ALMANAC ON AUTHOR\) for information on the creator of this travesty
	of electrons.  \(CONSULT ALMANAC ON CREDITS\) to see a list of his accomplices.\"";
    }

    intro = "\b\tA roar startles you awake.  You leap up and run to the window
	in time to see a flame streak across the sky.  Your master Zefron is already
	there, and the two of you watch and feel the impact just beyond the southern
	horizon.\n
	\t\"A fallen star,\" Zefron muses.  \"Perhaps it's a good omen for my new spell.
	I'll take it as such.  We'll go look for the star in the morning.  With luck Duke
	Oswale won't insist that I put it back where it was.\"\n
	\t\"Go back to sleep.\" The old wizard yawns and stretches, then closes the
	window shutters.  \"I might as well
	work on this spell a bit more as long as I'm already awake.\"  You return to your
	sleeping mat and close your eyes, trying to ignore your master's muttering.
	\"Duple.  Druple.  Drat, that's still not it!\"\n
	\b\tYou are awakened again by a pounding at the trapdoor.  \"Master Zefron!  The duke
	commands you to come quickly!  A dragon is destroying the town!\"  There's a bit
	more pounding, the summons is repeated, and then you hear footsteps cascading down
	the tower stairs at a highly unsafe rate.\n
	\tYou groggily look around the room.  There's no sign of your master.\b"
;

end: function
{
	local almanaconship = isclass(uberloc(almanac), shiproom);
	local packageonship = isclass(uberloc(package), shiproom);
	local monstrositysafe = isclass(ucm.location, couch) ||
		isclass(monstrosity.location, couch);
	
	if (isclass(Me.location, shiproom)) {
		"  Unfortunately, by the time you leave the planet's gravitational field,
		the acceleration of the ship has crushed you into a floormat.  ";
		global.status = 'floormat';
		die(launchbutton);
	} else if (isclass(Me.location, couch)) {
		if (monstrosity == Me.form) {
			"  The acceleration of the ship presses you back into the couch.
			Fortunately, your current form has no rigid bones to break and
			seems well adapted to high pressure.  ";
		} else {
			"  Unfortunately, the acceleration force of the ship requires you to
			conform to the shape of the couch, and your rigid skeletal
			structure can't accommodate this requirement.  ";
			global.status = 'floormat';
			die(launchbutton);
		}

		"\bYou've achieved orbit around the planet and returned to your normal
		form by the time the rescue ship arrives.  ";
		if (monstrositysafe) {
			"The pilot has recovered as well, and is very pleased at your
			success.  It quickly signals the rescue ship that the problem is
			now fixed.  They go on their way, and the pilot resumes the
			original delivery flight.\b";

			if (find(hintVerb.hintlist, launchbutton)) {
				hintVerb.hintlist -= launchbutton;
			}


			if (zefron.firstspeak) {
				if (almanaconship) {
					"As you hurtle toward your destination, you peruse
					Zefron's almanac, and reflect on Zefron's
					generosity in giving it to you.  In the back of the
					book you find a sheet of parchment, which reads as
					follows:\b";
					diploma.readdesc;
					"\bYou give yourself
					a congratulatory cheer.  Your apprenticeship is
					over, and by studying the almanac you are confident
					that someday you will become a master wizard.";
					global.status = 'potential master wizard';
				} else {
					"As you hurtle toward your destination, you look
					around the ship.  In the belly you find a sheet
					of parchment, which you pick up and examine.  It
					reads as follows:\b";
					diploma.readdesc;
					"\bYou give yourself
					a congratulatory cheer.  But you quickly stop when
					you realize that you forgot to bring Zefron's
					almanac with you.  Without that knowledge, your
					studying is at an end.  Your apprenticeship is over,
					but you'll never be more than a journeyman wizard.";
					global.status = 'journeyman wizard';
				}
			} else {
				if (almanaconship) {
					"As you hurtle toward your destination, you mourn
					the loss of Zefron, your master and friend.
					Whatever happened to him, you wonder?  At least
					you have his almanac with you, to carry on his
					legacy.";
				} else {
					"As you hurtle toward your destination, you ponder
					what you have lost.  Your master has vanished,
					and you don't even have his almanac to learn from.
					Maybe the life of a wizard isn't for you after
					all.  Maybe you should be a pilot instead.";
					global.status = 'apprentice pilot';
				}
			}

			"\bIt's not long before you reach your destination, the planet
			Redicula, where you and the pilot are whisked away to the royal
			audience chambers by other monstrosities like itself.  You cause
			something of an uproar, since your cluple spell has worn off by
			now and you're clearly not another Rediculan, as the pilot
			initially thought.  ";
			if (Me == box.location && box.isfixed) {
				"Fortunately your universal translator enables you to
				understand what is going on around you.  ";
			} else {
				"You are quickly furnished with a universal
				translator so you can understand what is going on
				around you.  ";
			}
			"You're surprised at how much of their conversation seems to
			revolve around unmatched socks.  ";

			"\bFinally, you arrive at the royal audience chamber.  A Rediculan
			in magnificent robes approaches the two of you and asks, \"Do
			you have the package?\"\b";
			if (packageonship) {
				"\"Yes, I do,\" the pilot replies.\b
				\"Then you may present it to the King.\"\b
				A fanfare plays, and a figure steps up and sits on the
				throne.  With some surprise you notice that he's not a
				Rediculan, but a human like yourself.  He's in his middle
				years, a bit overweight, with wavy black hair.\b
				\"Here,\" the pilot says.  \"You give it to him.  You've
				earned the right.\"  It puts the package in your hands
				and propels you gently toward the throne.
				You walk up to the throne, kneel respectfully, and hold
				out the package.
				\bThe King accepts it with a dazzling
				smile and rips open the wrappings.  He extracts from
				the package a red and white striped bucket and six
				golden cans.  He opens the bucket and a can, and the
				aroma of fried chicken and beer fills the audience
				chamber.\b
				The King smiles at you again, sitting there in his
				sparkling white jumpsuit, and says, \"Oh man, I've
				been cravin' this for years.  Thank you, man, thank you
				very much.\"";
				global.status = global.status + ' to the King';
			} else {
				"The pilot turns to you.  \"Don't you have it?\"  When
				you shake your head, the pilot turns white and shrugs
				helplessly.  The
				robed Rediculan turns bright red and begins angrily
				shouting orders.\b
				Before long you and the former pilot are down in the
				royal kitchens of Redicula, peeling tubers.";
				global.status = 'apprentice tuber peeler';
			}
			
		} else {
			// Pilot dies.
			"It's at that point that you notice that the tremendous acceleration
			during launch has smooshed the pilot into gelatin.  The
			crew of the rescue ship confiscates the ship and takes
			you to their homeworld, where you are placed in indentured
			servitude, hauling and laundering huge piles of unmatched socks
			until you have paid their bill.";
			global.status = 'indentured sock launderer';
			die(launchbutton);
		}
		
	} else {
		// Endings where you weren't on the ship.
		"  It dwindles into a speck far above you and finally vanishes.\b";

		if (zefron.firstspeak) {
			"Zefron appears and claps you on the shoulder.  \"Well done,
			child, you've saved the day.  And passed your journeyman test
			as well, I might add.  Congratulations!  And now I will say
			goodbye.  I'm retiring and moving somewhere much warmer, with
			better food and fewer marsupials.  I've nominated you to the
			duke as my successor, and he has accepted, since I really gave
			him no other choice.\"\b
			\"Well, I must be going.  Don't worry.  Keep the almanac handy,
			and you'll never know I'm gone.\"  Zefron slaps at his sides and
			looks about, as if looking for his keys.  \"Well, that should do
			it.  I'm off.  Goodbye!\"  In a soft \>\>Foof!\<\< of inrushing
			air, Zefron vanishes.\b";
			if (almanaconship) {
				"The almanac.  Where is the almanac?  You realize with
				horror that you left the almanac on the ship!\b
				You assume your post as Royal Wizard of Fimpoz, but it's
				a disaster.  The two or three spells you know just aren't
				enough to keep the duchy running smoothly.  After a few
				months you are booted out of the country in disgrace.";
				global.status = 'ex-Royal Wizard of Fimpoz';
			} else {
				"Over the next few days, you peruse
				Zefron's almanac, and reflect on Zefron's
				generosity in giving it to you.  In the back of the
				book you find a sheet of parchment, which reads as
				follows:\b";
				diploma.readdesc;
				"\bYou also find that there are many more spells in
				the almanac that simply weren't there before.  Armed
				with this knowledge, you assume the post of Royal
				Wizard of Fimpoz, which you carry on with great
				success.";
				global.status = 'Royal Wizard of Fimpoz';
			}
		} else {
			"Weeks pass and there's still no sign of Zefron.  Duke Oswale
			hires another Royal Wizard to take Zefron's place.
			Unfortunately, the new wizard is an old rival of your former master
			and refuses to acknowledge any of your previous training.  He
			insists that you begin your apprenticeship anew.  You, having
			just saved the planet from certain destruction, are certain
			that you can do better elsewhere, so you pack up your things
			and prepare to leave Fimpoz forever.\b";
			if (almanaconship) {
				"In your packing you notice that you can't find Zefron's
				almanac.  With some horror you realize that you left it
				on the ship!  You'll never be able to pass as even a
				journeyman wizard without it.  But you've already made up
				your mind, and you set out for wherever the road will
				take you.";
				global.status = 'vagabond';
			} else {
				"You also pack up poor Zefron's almanac; the new wizard
				doesn't even want to see it, and is glad to be rid of
				you both.  You hold your head high as you go on down the
				road to seek your fortune.  It's not long before you find
				another little country that can use a wizard of your
				caliber, even if you are still officially an apprentice.
				With the knowledge in the almanac, you carry on
				capably enough.";
			}
		}

		"\bA few months later you are traveling alone at night when a gigantic 
		orange flying disc blots out the moon.  Stubby legs emerge from the
		underside of the disc as it drops to the ground and lands in a nearby
		grainfield.  A hatch under the ship slowly opens.\b";

		if (monstrositysafe && packageonship) {
			if (find(hintVerb.hintlist, launchbutton)) {
				hintVerb.hintlist -= launchbutton;
			}

			"The monstrosity emerges from the hatch!  It turns bright
			yellow and waves as it crosses the field to where you stand.\b
			\"Hello!\"\ says the little box on its neck.  \"Listen, the King
			was very grateful for your assistance in
			getting his package to him.  He wanted me to give you this.\"
			It holds out a coffer, about the size of a breadbox.\b
			You open the coffer and find that it's full of precious jewels,
			of all colors and sizes!  The monstrosity notices your reaction
			and says \"Yep, he said you'd like these.  We make them
			synthetically for industrial use, but I gather they're highly
			valued here.  Silly, really.  I suppose they are pretty though.
			Well, enjoy.  I need to get going.  Got another delivery to
			make.\"\b";
			if (almanaconship) {
				"It turns to go, but then stops.  \"Oh, silly me, I
				almost forgot.  Is this yours?\"  He hands you
				Zefron's almanac!  \"I thought so.  I found it on the
				ship.  Well, see you later!\"  ";
			}
			"With that he boards the disc and flies away, leaving strange
			curving patterns in the standing grain.  You run your fingers
			through the jewels and feel something soft.  When you pull it out
			you find that it's a portrait, like the one you saw the
			monstrosity carrying.  It shows a dark-haired man in a sparkling
			white jumpsuit.  On the back it says \"Thank you very much
			from the King\", and on the front it's signed \"Elvis\".";
			global.status = 'fabulously wealthy ' + global.status;
		} else {
			"A monstrosity emerges from the hatch, similar to the one
			you met earlier.  This one is bright red and brandishes a cylinder
			of some sort at you as it crosses the field.  \"Don't move!\"
			says a little box on its neck.  \"You're under arrest for ";
			if (!packageonship) {
				"stealing the King's package when the ship crashed here
				earlier.  The delivery ship arrived at its destination
				but the package was gone, because you stole it!  ";
			} else {
				"reckless xenocide in launching a spacecraft without
				properly restraining its helpless pilot.  ";
			}
			"Ordinarily, this sort of diplomatic incident would result in
			a war between our planet and yours.  However, that would
			violate our Prime Directive in this case, so we'll settle for
			taking it out of your hide.  Lucky you.  Hold still now, this
			will sting for just a bit.\"\b
			A bolt of light shoots out of the cylinder and strikes you,
			and you shrink into the form of
			a gray squirrel.  \"That should do it.  Transmogrified like
			that, you won't be hurting anybody else.  Scurry on now.\"  The
			monstrosity shambles back to its ship and flies away, as you
			try without success to make your primitive speech organs say
			the elpulc spell.  Before long you give up and scurry off to
			find acorns.";
			global.status = 'small innocuous woodland creature';
		}
	}

	die(nil);
}

rescue: function
{
	"\bNot long after that, darkness falls over the city as a gigantic orange flying
	disc eclipses the sun.  It hangs there in the air for a moment (yes, as a matter
	of fact, in much the way bricks don't), apparently assessing the situation as
	people scream and run about in terror below.  Finally, a booming voice says
	\"Well, it looks as if we've interfered with the normal development of your
	primitive culture.  That's a violation of our Prime Directive, and I'm afraid
	the penalty for that is death.  Not OUR death, of course, unfortunately for
	all of you.  Sorry about that, but don't worry, this will just hurt for a little
	bit.\"\b";
	if (zefron.firstspeak) {
		"Suddenly, another, equally booming but more familiar voice shouts
		\"WAIT!\"  Zefron appears in the town square, and there's a large
		cabinet next to him, covered in gleaming almond-white enamel.  \"We are not
		a primitive culture.  Behold!\"  He puts a goblet in a receptacle on
		the front of the cabinet, and the goblet fills with tiny cubicles of
		ice.  The townsfolk ooh and ahh in wonder.\b
		Nothing happens for a moment, and then the first booming voice resumes.
		\"Okay, whoops, sorry, our mistake.  You qualify for non-primitive
		status, which of course exempts you from Prime Directive violation.  We
		won't have to dump the socks after all.  Carry on then.\"  A shaft of
		green light shoots out from the disc and strikes the dragon in the town
		square, which rises up into a hatch in the bottom of the disc.  The disc
		then flies away.\b";
		if ('prisoner' == global.status) {
			"By the time your period of incarceration has ended, Zefron
			has retired and moved to a tropical island.  Fortunately, the
			chief scullion needs an apprentice.";
			global.status = 'apprentice scullion';
		} else {
			if (isclass(Me.location, shiproom) || 
				isclass (Me.location, couch)) {
				"As you feel the ship start to rise, you hear a soft
				\>\>Foof!\<\< and find yourself standing in the town
				 square.  ";
			}

			"Zefron turns to you and says \"Come along, child.  It's obviously
			time to continue your studies.  You didn't do as well as I'd
			hoped.\"  He hands you a black cord with two prongs, which runs
			out from behind the cabinet.  \"Your next journeyman test will
			be much tougher.  You'll have to invent alternating current.\"";
		}
	} else {
		"A hatch opens on the underside of the disc, and a brightly-colored rain
		of soft cotton tubes rains down upon the town.  And rains.  And
		rains.  It rains for forty days and forty nights, and the whole world is
		covered with unmatched socks (each is unique, like snowflakes) until it
		collapses under their weight into a nice tidy singularity.";
		global.status = 'fraction of a singularity';
	}

	die(nil);
}
	
scoreRank: function
{
    "\bIn a total of "; say( global.turnsofar );
    " turns, you have achieved the status of \"";
    say(global.status);
    ".\" ";
}

replace scoreStatus: function(points, turns)
{
	setscore(cvtstr(turns));
}

/*
 *   The terminate() function is called just before the story ends.  It
 *   generally displays a good-bye message.  The default version does
 *   nothing.  Note that this function is called only when the story is
 *   about to exit, NOT after dying, before a restart, or anywhere else.
 */
terminate: function
{
}

// ADV.T MODIFICATIONS
/*
 *  I happen to know that slices are the only indistinguishable objects in the
 *  story, so I have customized this function accordingly.
 */
replace isIndistinguishable: function(obj1, obj2)
{
    return (firstsc(obj1) == firstsc(obj2) &&
    	obj1.isheel == obj2.isheel &&
    	obj1.isjammed == obj2.isjammed &&
    	obj1.issmashed == obj2.issmashed &&
    	obj1.toastlevel == obj2.toastlevel);
}

/*
 *   preinit() is called after compiling the story, before it is written
 *   to the binary gam file.  It performs all the initialization that can
 *   be done statically before storing the story in the file, which speeds
 *   loading the gam, since all this work has been done ahead of time.
 */
preinit: function
{
	local o;
	global.almTopicList = [];
	o = firstobj(almTopic);
	while( o != nil ) {
		if (!isclass(o, helpTopic)) {
			global.almTopicList += o;
		}
	        o = nextobj( o, almTopic );
	}

	initSearch();
	global.status = 'apprentice wizard';
}

// Modify to be able to get hints and consult on things that
// you can't reach.
replace checkReach: function( loc, actor, v, obj )
{
    if (hintVerb == v || (consultOnVerb == v || almanac == obj)) return;
    
    if ( obj==numObj or obj==strObj ) return;
    if ( not ( actor.isCarrying( obj ) or obj.isIn( actor.location )))
    {
	if (find( loc.reachable, obj ) <> nil ) return;
	"%You% can't reach "; obj.thedesc; " from "; loc.thedesc; ". ";
	exit;
    }
}

modify distantItem
    dobjGen(a, v, i, p) =
    {
        if (nil == find([inspectVerb hintVerb consultOnVerb researchInVerb
		listentoVerb tellVerb askVerb], v))
        {
            "It's too far away.";
            exit;
        }
    }
    iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

modify foodItem
	doEat(actor) = {
		if (fly == Me.form || raven == Me.form) {
			"You nibble a bit on << self.thedesc >>.";
		} else {
		        "That was delicious! ";
		        global.lastMealTime = global.lastMealTime - self.foodvalue;
		        self.moveInto( nil );
		}
	}	
;

modify doorway
	noAutoOpen = true
	bulk = 5
;

/*
** Required to keep dubious messages from appearing if someone
** tries to consult on something that is not a topic.
*/
modify thing
	verIoConsultOn(actor) = "There is no entry on that topic in the almanac."
	verDoResearchIn(actor) = {self.verIoConsultOn(actor);}
	verDoCluple(actor) = {"Nothing happens.";}

    // Change the default messages in case you don't have hands.
    doTake( actor ) =
    {
        local totbulk, totweight;

        totbulk = addbulk( actor.contents ) + self.bulk;
        totweight = addweight( actor.contents );
        if ( not actor.isCarrying( self ))
            totweight = totweight + self.weight + addweight(self.contents);

        if ( totweight > actor.maxweight )
            "%Your% load is too heavy. ";
        else if ( totbulk > actor.maxbulk )
            "%Your% load is too bulky. ";
        else
        {
            self.moveInto( actor );
            "Taken. ";
        }
    }

    // Add Shove to process events when something is put somewhere.
    oldweight = 0
    oldbulk = 0
    Shove( obj ) = {}
    moveInto( obj ) = {
        local loc;

	/*
	 *   For the object containing me, and its container, and so forth,
	 *   tell it via a Grab message that I'm going away.
	 */
	loc = self.location;
	while ( loc )
	{
	    loc.Grab( self );
	    loc = loc.location;
	}

        if ( self.location )
            self.location.contents = self.location.contents - self;
        self.location = obj;
        if ( obj ) {
        	obj.Shove (self);
		obj.contents = obj.contents + self;
	}
    }

	verDoGreet(actor) = {
		"Have you considered professional psychiatric help?";
	}

	hintlevel = 0
	verDoHint(actor) = {
		if (0 == self.hintlevel) {
			"There are no hints specific to << self.thedesc >>.";
		}
	}
	doHint(actor) = {
		switch (self.hintlevel) {
		case 0: "There are no hints specific to << self.thedesc >>.";
			break;
		case 1: self.hint1;
			self.hintlevel++;
			break;
		case 2: self.hint2;
			self.hintlevel++;
			break;
		case 3: self.hint3;
			self.hintlevel++;
			break;
		default: "There are no more hints specific to << self.thedesc >>.";
		}
	}
;

modify basicStrObj
	doSay( actor ) = {
		local temp = lower(substr(self.value, 1, 6));
		if ('cluple' == temp || 'xyzzy' == temp || 'plugh' == temp ||
			'elpulc' == temp) {
			"If you want to use a magic word, just enter the word as
			a command rather than actually SAYing it.  For example,
			\(CLUPLE BEDBUG\).";
		} else {
			"Okay, \""; say( self.value ); "\".";
		}
		if (dragon.location == Me.location) {
			dragon.gotAttention;
		}
	}
;

modify basicNumObj
    verIoMoveTo( actor ) = {}
    ioMoveTo( actor, dobj ) = { dobj.doMoveTo( actor, self ); }
;		

modify iVerb
    action( actor ) =
    {
        if (length( actor.contents ))
        {
            "%You% %have% "; listcont( actor ); ". ";
            listcontcont( actor );
        }
	else
            "%You% %have% nothing.\n";
    }
;

modify putVerb
	verb = 'hang'
;

// VERBS

bronkVerb: deepverb
	verb = 'fart' 'burp' 'belch'
	sdesc = "bronk"
	action(actor) = {
		"%You% make%s% an impressive noise, and feel%s% much relieved.";
	}
;

browseVerb: deepverb
	verb = 'browse'
	sdesc = "browse"
	doAction = 'Browse'
	sight = true
;

clupleVerb: deepverb
    verb = 'cluple'
    sdesc = "cluple"
    doAction = 'Cluple'
    speech = true
;

consultOnVerb: deepverb
	verb = 'consult' 'c'
	sdesc = "consult"
	prepDefault = onPrep
	ioAction(onPrep) = 'ConsultOn'
	validIo( actor, obj, seqno ) = true
	validIoList(actor, prep, dobj) = nil
	sight = true
;

cutWithVerb: deepverb
	verb = 'cut' 'slice'
	sdesc = "cut"
	prepDefault = withPrep
	ioAction(withPrep) = 'CutWith'
;

elpulcVerb: deepverb
	verb = 'elpulc'
	sdesc = "elpulc"
	doAction = 'Elpulc'
	speech = true
	validDoList(actor, prep, iobj) = {
		return [zefron] + inherited.validDoList(actor, prep, iobj);
	}
	validDo(actor, obj, seqno) = {
		return (zefron == obj || inherited.validDo(actor, obj, seqno));
	}
;

modify followVerb
	validDoList(actor, prep, iobj) = {
		return [monstrosity jam] + inherited.validDoList(actor, prep, iobj);
	}
	validDo(actor, obj, seqno) = {
		return (monstrosity == obj || 
			(jam == obj && almanac.isReachable(actor)) ||
			inherited.validDo(actor, obj, seqno));
	}
;

lookOutVerb: deepverb
	sdesc = "look out"
	verb = 'look out' 'l out'
	doAction = 'LookOut'
	sight = true
;

makeVerb: deepverb
	verb = 'make' 'cook' 'mix'
	sdesc = "make"
	doAction = 'Make'
	validDoList = [slice jam toast]
	validDo( actor, obj, seqno ) = true
;

modify moveVerb
	verb = 'slide' 'set' 'shake'
;

/*
** 'ResearchIn' is a synonym of 'ConsultOn', but the iobj and dobj
** are reversed.
*/
researchInVerb: deepverb
	verb = 'research' 'look up' 'read about'
	sdesc = "research"
	prepDefault = inPrep
	ioAction(inPrep) = [disambigDobjFirst] 'ResearchIn'
	validDoList = nil
	validDo( actor, obj, seqno ) = true
	sight = true
;

sharpenWithVerb: deepverb
	verb = 'sharpen' 'hone' 'whet'
	sdesc = "sharpen"
	prepDefault = withPrep
        ioAction(withPrep) = 'SharpenWith'
;

spreadOnVerb: deepverb
	verb = 'spread' 'slather' 'smear'
	sdesc = "spread"
	prepDefault = onPrep
	ioAction(onPrep) = 'SpreadOn'
;

modify waitVerb
	verb = 'stop'
;

replace cleanVerb: deepverb
;

modify climbVerb
	verb = 'climb over'
;

toastVerb: deepverb
	verb = 'toast'
	sdesc = "toast"
	doAction = 'Toast'
;

modify takeVerb
	verb = 'pick'
;

modify turnVerb
	verb = 'crank'
;

xyzzyVerb: deepverb
	verb = 'xyzzy' 'plugh'
	action(actor) = {
		"\b\>\>Foof!\<\<\b
		You are inside a building, a well house for a large spring.\b
		There are some keys on the ground here.\n
		There is a shiny brass lamp nearby.\n
		There is food here.\n
		There is a bottle of water here.\b
		You are able to take in your surroundings for a few seconds before a
		second \>\>Foof!\<\< deposits you back in Zefron's workshop.
		Apparently your feeble wizardly powers won't enable you to stay in that
		distant land for long.\b";
		Me.travelTo(workshop);
	}
	speech = true
;

replace yellVerb: deepverb
	verb = 'yell' 'shout' 'scream' 'yell at' 'shout at' 'scream at'
	action(actor) = {
		"AAAAAAAUUUUUUGGGGGGHHHHHH!!!!!!";
		if (dragon.location == Me.location) {
			dragon.gotAttention;
		}
	}
	doAction = 'YellAt'
	speech = true
;

modify askVerb
	speech = true
;
modify tellVerb
	speech = true
;
modify helloVerb
	speech = true
	verb = 'greet'
	doAction = 'Greet'
;
modify sayVerb
	speech = true
;

class flyVerb: travelVerb
    sdesc = "fly"
    action( actor ) = {
	if (actor.form.canfly) {
		actor.travelTo( self.travelDir( actor ));
	} else {
		"Flapping your arms doesn't seem to get you anywhere.";
	}
    }
;

flyEVerb: flyVerb
	verb = 'fly e' 'fly east'
	travelDir( actor ) = { return( actor.location.east ); }
;

flyWVerb: flyVerb
	verb = 'fly w' 'fly west'
	travelDir( actor ) = { return( actor.location.west ); }
;

flyNVerb: flyVerb
	verb = 'fly n' 'fly north'
	travelDir( actor ) = { return( actor.location.north ); }
;

flySVerb: flyVerb
	verb = 'fly s' 'fly south'
	travelDir( actor ) = { return( actor.location.south ); }
;

flyUVerb: flyVerb
	verb = 'fly u' 'fly up' 'fly'
	travelDir( actor ) = { return( actor.location.up ); }
;

flyDVerb: flyVerb
	verb = 'fly d' 'fly down'
	travelDir( actor ) = { return( actor.location.down ); }
;

flyInVerb: flyVerb
	verb = 'fly in'
	travelDir( actor ) = { return( actor.location.in ); }
;

flyOutVerb: flyVerb
	verb = 'fly out'
	travelDir( actor ) = { return( actor.location.out ); }
;

/*
** Hint system.
*/
hintVerb: sysverb
	hintlist = [startroom maindoorsout guard portcullisout dragon monstrosity
		oldtoast gardengatein fly jam gardenview grapes
		dukeskey carpet dukesdoorin engine ropes launchbutton
		zefron]
	verb = 'hint'
	sdesc = "hint"
	action(actor) = {
		local topic;

		if (zefron.firstspeak && (!garden.isseen || !dukesroom.isseen)) {
			"You have reached a dead end.  You've done something that
			needed to be done, but you did it too soon for you to be
			able to reach a satisfying conclusion to the story.";
			return;
		}

		if (1 > length(hintlist)) {
			"There are no hints left.  You're on your own.";
			return;
		}

		topic = car(hintlist);
		topic.doHint(actor);
		
		// If there's no more hints on the current topic, move on to the next.
		if (3 < topic.hintlevel) {
			hintlist = cdr(hintlist);
		}
	}
	doAction = 'Hint'
	validDo( actor, obj, seqno ) = true
	validDoList(actor, prep, dobj) = nil
;

