/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "%W% (Ames) %G%";
#endif not lint

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/file.h>

#include <netinet/in.h>

#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#include <errno.h>
#include <netdb.h>
#ifndef SYSV
#include <syslog.h>
#endif
#include <pwd.h>

/*
 * comsat
 */
int	debug = 0;
#define	dprintf	if (debug) printf

#ifdef SYSV
#define vfork fork
char *prog = "/usr/local/bin/comsat";
#else
char *prog = "/usr/local/comsat";
#endif

char *Malloc(), *malloc();

extern	errno;

int	onalrm(), onchld();
long	lastmsgtime;

char *index();

#define	MAXIDLE	120

main(argc, argv)
	int argc;
	char *argv[];
{
	register int cc;
	char msgbuf[100];
	struct sockaddr_in from;
	int fromlen;

	/* verify proper invocation */
	fromlen = sizeof (from);
	if (getsockname(0, &from, &fromlen) < 0) {
		fprintf(stderr, "%s: ", argv[0]);
		perror("getsockname");
		_exit(1);
	}
	lastmsgtime = time(0);
	onalrm();
	signal(SIGALRM, onalrm);
	signal(SIGTTOU, SIG_IGN);
	signal(SIGCHLD, onchld);
	for (;;) {
		cc = recv(0, msgbuf, sizeof (msgbuf) - 1, 0);
		if (cc <= 0) {
			if (errno != EINTR)
				sleep(1);
			errno = 0;
			continue;
		}
		sigblock(sigmask(SIGALRM));
		msgbuf[cc] = 0;
		lastmsgtime = time(0);
		mailfor(msgbuf);
		sigsetmask(0);
	}
}

onalrm()
{

	if (time(0) - lastmsgtime >= MAXIDLE)
		exit(0);
	dprintf("alarm\n");
	alarm(15);
}

mailfor(name)
	char *name;
{
	register char *cp;
	int offset;

	dprintf("mailfor %s\n", name);
	cp = name;
	while (*cp && *cp != '@')
		cp++;
	if (*cp == 0) {
		dprintf("bad format\n");
		return;
	}
	*cp = 0;
	offset = atoi(cp+1);
	notify(name, offset);
}

notify(name, offset)
char *name;
{
	FILE *tp;
	struct passwd *pwd;
	int mf;
	char buf[256];
	char *cp;
	int pid, wpid;
	union wait status;
	int ignorestat;
	char *env[8];

	if (fork())
		return;
	signal(SIGCHLD, SIG_DFL);
	pwd = getpwnam(name);
	if (pwd == NULL) {
#ifdef LOG_ERR
		syslog(LOG_ERR, "%s: unknown uid", name);
#endif
		exit(1);
	}
	setgid(pwd->pw_gid);
	initgroups(name, pwd->pw_gid);
	setuid(pwd->pw_uid);
	env[0] = Malloc(strlen(pwd->pw_name) + 6);
	sprintf(env[0], "USER=%s", pwd->pw_name);
	env[1] = Malloc(strlen(pwd->pw_dir) + 6);
	sprintf(env[1], "HOME=%s", pwd->pw_dir);
	env[2] = Malloc(strlen(pwd->pw_shell) + 7);
	sprintf(env[2], "SHELL=%s", pwd->pw_shell);
	env[3] = 0;
	signal(SIGALRM, SIG_DFL);
	alarm(30);
	if (chdir(pwd->pw_dir) < 0 || (tp = fopen(".comsat", "r")) == NULL) {
		open_mail(name, offset);
		(void) open("/dev/null", O_WRONLY, 0);
		(void) dup(1);
		execlp(prog, "comsat", name, 0, env);
		exit(1);
	}
	fcntl(fileno(tp), F_SETFD, 1);
	while (fgets(buf, sizeof buf, tp)) {
		if (cp = index(buf, '\n'))
			*cp = '\0';
		if (buf[0] == '\0')
			continue;
		cp = buf;
		if (*cp == '-') {
			ignorestat = 1;
			cp++;
		} else
			ignorestat = 0;
		if ((pid = vfork()) == 0) {
			open_mail(name, offset);
			(void) open("/dev/null", O_WRONLY, 0);
			(void) dup(1);
			execlp(pwd->pw_shell, pwd->pw_shell, "-c", cp, 0, env);
			_exit(1);
		}
		if (pid > 0) {
			while ((wpid = wait(&status)) != pid &&
			    wpid != -1)
				;
			if (wpid < 0) {
#ifdef LOG_WARNING
				syslog(LOG_WARNING, "wait: %m");
#endif
				continue;
			}
			if (ignorestat == 0 &&
			    status.w_status == 0)	/* success */
				break;
		}
	}
	fclose(tp);
	exit(0);
}

open_mail(name, offset)
char *name;
{
#ifdef SYSV
	static char buf[256] = "/usr/mail/";
#else
	static char buf[256] = "/usr/spool/mail/";
#endif
	static char *mp=NULL;
	int mf;

	if (mp == NULL)
		mp = buf + strlen(buf);
	strcpy(mp, name);
	mf = open(buf, O_RDONLY, 0);
	if (mf < 0)
		exit(1);
	if (lseek(mf, offset, L_SET) == -1)
		exit(1);
#ifdef LOG_ERR
	closelog();
#endif
	close(0); close(1); close(2);
	dup2(mf, 0);
	if (mf != 0)
		close(mf);
}

onchld()
{
	while(wait3(0, WNOHANG, 0) > 0)
		;
}

char *
Malloc(size)
{
	char *cp = malloc(size);

	if (!cp) {
		perror("malloc");
		exit(1);
	}
	return cp;
}
