#include <netat/appletalk.h>
#include <stdio.h>
#include <sys/file.h>
#include <pwd.h>

char *getline();
char *malloc(), *realloc(), *index();
char *getenv();

int	debug = 0;
#define dprintf if (debug) printf

char *deftype = "PopAlert";		/* default entity type */
EntityName entity;
int skt;

main(argc, argv)
char **argv;
{
	register struct passwd *pw;
	FILE *fp, *fi;
	char buf[BUFSIZ];
	char headbuf[1024];
	char junk[4];
	char *from=NULL, *to=NULL, *subject=NULL;
	register char *cp;
	char *ehb;
	int status=0;
	char *name;
	OSErr err;

	if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 'd') {
		if (argv[1][2])
			debug = atoi(argv[1]+2);
		else
			debug = 1;
		argv++; argc--;
	}
	if (argc >= 2)
		name = argv[1];
	else
		name = getenv("USER");
	if (!name) {
		fprintf(stderr, "Usage: ddpcomsat user\n");
		exit(1);
	}

	pw = getpwnam(name);
	if (pw == NULL) {
		fprintf(stderr, "%s: no such user.\n", name);
		return 1;
	}
	strcpy(buf, pw->pw_dir);
	cp = buf + strlen(buf);
	strcpy(cp, "/.mac");
	fp = fopen(buf, "r");
	if (fp == NULL) {
		perror(buf);
		return 1;
	}

	fi = stdin;

	while (fgets(buf, sizeof buf, fi) != NULL) {
		if (buf[0] == '\n')
			break;
		if (strncmp(buf, "From:", 5) == 0) {
			from = getline(buf, fi);
		} else if (strncmp(buf, "To:", 3) == 0) {
			to = getline(buf, fi);
		} else if (strncmp(buf, "Subject:", 8) == 0) {
			subject = getline(buf, fi);
		}
	}
	if (from == NULL)
		from = "";
	if (to == NULL)
		to = "";
	if (subject == NULL)
		subject = "";
	cp = headbuf;
	while (*name && cp < &headbuf[sizeof headbuf])
		*cp++ = *name++;
	*cp++ = '\0';
	while (*from && cp < &headbuf[sizeof headbuf])
		*cp++ = *from++;
	*cp++ = '\0';
	while (*subject && cp < &headbuf[sizeof headbuf])
		*cp++ = *subject++;
	*cp++ = '\0';
	while (*to && cp < &headbuf[sizeof headbuf])
		*cp++ = *to++;
	*cp++ = '\0';
	ehb = cp;

	abInit(debug);
	dbug.db_nbp = debug;
	dbug.db_ddp = debug;
	dbug.db_ini = debug;
	nbpInit();
	err = DDPOpenSocket(&skt, 0);
	if (err != noErr) {
		fprintf(stderr, "open returned %d\n", err);
		return err;
	}
	while (fgets(buf, sizeof buf, fp)) {
		if (cp = index(buf, '\n'));
			*cp = '\0';
		if (buf[0] == '\0')
			continue;
		if (send_ddp(buf, headbuf, ehb-headbuf) == noErr)
		    status++;
	}
			
	return !status;
}

char *
getline(line, fp)
char *line;
FILE *fp;
{
	register char *cp, *cp2;
	int c, size, i;
	char buf[BUFSIZ];

	if (cp = index(line, '\n'))
		*cp = '\0';
	if (cp = index(line, ':'))
		cp++;
	while (*cp == ' ' || *cp == '\t')
		cp++;
	size = strlen(cp) + 1;
	cp2 = malloc(size);
	if (cp2 == NULL)
		return NULL;
	strcpy(cp2, cp);
	while ((c = getc(fp)) == ' ' || c == '\t') {
		ungetc(c, fp);
		fgets(buf, sizeof buf, fp);
		if (cp = index(buf, '\n'))
			*cp = '\0';
		i = strlen(buf);
		cp2 = realloc(cp2, size + i);
		if (cp2 == NULL)
			return NULL;
		strcpy(cp2+size-1, buf);
		size += i;
	}
	ungetc(c, fp);
	return cp2;
}

send_ddp(socket, buf, len)
char *socket, *buf;
{

	AddrBlock addr;

	my_create_entity(socket, &entity);
	if (!getname(&addr, &entity)) {
		fprintf(stderr, "Can't find %s:%s@%s\n", entity.objStr.s,
		    entity.typeStr.s, entity.zoneStr.s);
		return 1;
	}
	dprintf("Got net %d.%02d, node %d, skt %d\n", addr.net>>8,
	    addr.net&0xff, addr.node, addr.skt);
	return doit(skt, &addr, buf, len);
}

doit(skt, addr, buf, n)
AddrBlock *addr;
unsigned char *buf;
unsigned short n;
{
	struct ABusRecord abr;
	OSErr err;

	abr.abResult = 0;
	abr.proto.ddp.ddpType = 109;
	abr.proto.ddp.ddpSocket = skt;
dprintf("skt=%d\n", skt);
	abr.proto.ddp.ddpAddress = *addr;
dprintf("dstskt=%d\n", abr.proto.ddp.ddpAddress.skt);
	abr.proto.ddp.ddpDataPtr = buf;
	abr.proto.ddp.ddpReqCount = n;
	err = DDPWrite(&abr);
	if (err < noErr) {
		fprintf(stderr, "DDPWrite error %d result=%d\n", err, abr.abResult);
		return 1;
	}
	return 0;
}

static void
mylistener(skt, pkt, len, addr)
DDP *pkt;
AddrBlock *addr;
{
	dprintf("Listen %d\n", skt);
}

private boolean
getname(addr,ent)
AddrBlock *addr;
EntityName *ent;
{
  nbpProto nbpr;
  NBPTEntry nbpt[1];		/* should be exact match */
  OSErr err;
  
  nbpr.nbpRetransmitInfo.retransInterval = 8;
  nbpr.nbpRetransmitInfo.retransCount = 3;
  nbpr.nbpDataField = 1;
  nbpr.nbpEntityPtr = ent;
  nbpr.nbpBufPtr = nbpt;
  nbpr.nbpBufSize = sizeof(nbpt);

  err = NBPLookup(&nbpr, FALSE);
  if (err != noErr) {
	fprintf("lookup error %d\n", err);
	return FALSE;
    }
  if (nbpr.nbpDataField != 1) {
dprintf("n = %d\n", nbpr.nbpDataField);
    return(FALSE);
    }
  NBPExtract(nbpt, nbpr.nbpDataField, 1, ent, addr); /* get lw entry */
  return(TRUE);
}

cleanup(i)
{
	DDPCloseSocket(skt);
	exit(i);
}

my_create_entity(s, en)
char *s;
EntityName *en;
{
  create_entity(s, en);	/* must be fully specified name */
  if (*en->objStr.s == '\0')
    en->objStr.s[0] = '=';
  if (*en->typeStr.s == '\0')
    strcpy(en->typeStr.s,deftype); /*  to lookup... */
  if (*en->zoneStr.s == '\0')
    en->zoneStr.s[0] = '*';
}
