/* CDROM.C - Programmed by Maarten Hofman */
/* 120793: Split with includefile */

#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include "cdrom.h"

char longfile[38],drives[26];

char *get_cdrom_drive_letters(void) {
struct REGPACK regs;

  regs.r_ax=0x150d;
  regs.r_es=FP_SEG(drives);
  regs.r_bx=FP_OFF(drives);
  intr(0x2f,&regs);
  return(drives);
}

char *get_file_name(int drive,int what) {
struct REGPACK regs;

  regs.r_ax=what;
  regs.r_es=FP_SEG(longfile);
  regs.r_bx=FP_OFF(longfile);
  regs.r_cx=drive;
  intr(0x2f,&regs);
  if(regs.r_ax==0x0015) return(NULL);
  return(longfile);
}

void send_device_driver_request(int drive,char *header) {
struct REGPACK regs;

  regs.r_ax=0x1510;
  regs.r_es=FP_SEG(header);
  regs.r_bx=FP_OFF(header);
  regs.r_cx=drive;
  intr(0x2f,&regs);
}

int get_number_of_cdroms(void) {
union REGS regs;

   regs.x.ax=0x1500;
   regs.x.bx=0x00;
   int86(0x2f,&regs,&regs);
   return(regs.x.bx);
}

int get_first_cdrom_drive(void) {
union REGS regs;

  regs.x.ax=0x1500;
  regs.x.cx=0xffff;
  int86(0x2f,&regs,&regs);
  return(regs.x.cx);
}

int cdrom_drive_check(int drive) {
union REGS regs;

  regs.x.ax=0x150b;
  regs.x.bx=0x0000;
  regs.x.cx=drive;
  int86(0x2f,&regs,&regs);
  if(regs.x.bx!=0xadad) return(MSCDEX_NOT_INSTALLED);
  if(regs.x.ax==0x0000) return(DRIVE_NOT_SUPPORTED);
  return(DRIVE_SUPPORTED);
}

int mscdex_version(void) {
union REGS regs;

  regs.x.ax=0x150c;
  regs.x.bx=0x0000;
  int86(0x2f,&regs,&regs);
  return(regs.x.bx);
}
