/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.operators.BufferOperator;
import unity.operators.DualHashTable;
import unity.operators.Operator;
import unity.predicates.EquiJoinPredicate;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.relational.TupleTS;

public class EarlyHashJoin
extends Operator {
    private DualHashTable hashTable;
    private int numPartitions;
    private static int MAX_INT = 999999999;
    private static int MIN_FLUSH_SIZE = 500;
    private boolean useBGProcess;
    private static int END_LEFT_TIME_NO_RIGHT_INPUT = 1;
    private static int TIME_NO_INPUT = 1;
    private static int TIME_NO_RIGHT_INPUT = 1;
    private static int MIN_BG_PART_SIZE = 500;
    private static int MIN_TIME_DIFF_PROBE = 50000;
    private long lastSRead = 0L;
    private int BGJoinResults;
    private int BGIOs;
    private EquiJoinPredicate predicate;
    private Relation[] schemas;
    private boolean isMNJoin;
    private boolean usingTupleTS;
    private boolean isLeftOuterJoin;
    private boolean isRightOuterJoin;
    private Tuple nullLeftTuple;
    private Tuple nullRightTuple;
    private boolean[] bufferedInput;
    private boolean bothInputsBuffered;
    private int leftSampleRate;
    private int rightSampleRate;
    private int leftSampleRatePhase1;
    private int rightSampleRatePhase1;
    private int leftSampleRatePhase2;
    private int rightSampleRatePhase2;
    private boolean inPhaseOne;
    private Tuple currentTuple;
    private int currentInput;
    private boolean endLeft;
    private boolean endRight;
    private int timestamp;
    private int leftReadCounter;
    private int rightReadCounter;
    private boolean processingProbe;
    private boolean processingInput;
    private boolean BGThreadActive;
    private int BGPartitionIndex;
    private List BGresults;
    private ArrayList probeMatches;
    private int currentProbeIndex;
    private boolean firstCleanupPass;
    private int currentPartitionIndex;
    private int partitionFileIndex;
    private boolean processingProbeInput;
    private BufferedInputStream probeFile;
    private boolean processingTimestampProbe;
    private int leftPartitionFlushTS;
    private int rightPartitionFlushTS;
    private int lastRightProbe;
    private int ioCounter;
    private int[] partCleanup;
    private double tableScaleFactor;
    private boolean probeRightTable;

    public EarlyHashJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numpart, boolean MNJoin, boolean useBGProcess) {
        this(in, p, bsize, bfr, numpart, MNJoin, 1, 1, 1, 1, useBGProcess, 1.0, false, false);
    }

    public EarlyHashJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numpart, boolean MNJoin, int numLeftRead1, int numRightRead1, int numLeftRead2, int numRightRead2, boolean useBGProcess, double scale, boolean leftJoin, boolean rightJoin) {
        super(in, bfr, bsize);
        this.numPartitions = numpart;
        this.isMNJoin = MNJoin;
        this.predicate = p;
        this.leftSampleRatePhase1 = numLeftRead1;
        this.rightSampleRatePhase1 = numLeftRead1;
        this.leftSampleRatePhase2 = numLeftRead2;
        this.rightSampleRatePhase2 = numRightRead2;
        this.leftSampleRate = numLeftRead1;
        this.rightSampleRate = numRightRead1;
        this.useBGProcess = useBGProcess;
        this.tableScaleFactor = scale;
        this.isLeftOuterJoin = leftJoin;
        this.isRightOuterJoin = rightJoin;
        this.usingTupleTS = this.isMNJoin || this.isLeftOuterJoin;
        this.schemas = new Relation[2];
        this.schemas[0] = this.input[0].getOutputRelation();
        this.schemas[1] = this.input[1].getOutputRelation();
        Relation out = new Relation(this.schemas[0]);
        out.mergeRelation(this.schemas[1]);
        this.setOutputRelation(out);
    }

    public void setSamplingRate(int left, int right) {
        this.leftSampleRate = left;
        this.rightSampleRate = right;
    }

    public void init() throws IOException {
        Object[] vals;
        this.input[0].init();
        this.input[1].init();
        this.bufferedInput = new boolean[2];
        this.bufferedInput[0] = this.input[0].isBuffered();
        this.bufferedInput[1] = this.input[1].isBuffered();
        boolean bl = this.bothInputsBuffered = this.bufferedInput[0] && this.bufferedInput[1];
        if (this.isLeftOuterJoin) {
            vals = new Object[this.schemas[1].getNumAttributes()];
            Arrays.fill(vals, null);
            this.nullRightTuple = new TupleTS(vals, this.schemas[1], 0);
        }
        if (this.isRightOuterJoin) {
            vals = new Object[this.schemas[0].getNumAttributes()];
            Arrays.fill(vals, null);
            this.nullLeftTuple = new TupleTS(vals, this.schemas[0], 0);
        }
        this.hashTable = new DualHashTable(this.BUFFER_SIZE, this.numPartitions, this.BLOCKING_FACTOR, this.schemas[0], this.schemas[1], this.predicate, !this.isMNJoin, this.tableScaleFactor);
        this.inPhaseOne = true;
        this.endLeft = false;
        this.endRight = false;
        this.timestamp = 0;
        this.processingInput = true;
        this.processingProbe = false;
        this.processingTimestampProbe = false;
        this.BGThreadActive = false;
        this.leftReadCounter = this.leftSampleRate;
        this.rightReadCounter = this.rightSampleRate;
        this.BGPartitionIndex = -1;
        this.BGJoinResults = 0;
        this.BGIOs = 0;
        this.BGresults = null;
        this.probeRightTable = this.leftSampleRate < 10000000;
    }

    public void close() throws IOException {
        this.hashTable.clear();
    }

    /*
     * Unable to fully structure code
     */
    public Tuple next() throws IOException {
        while (true) {
            block43: {
                if (this.BGresults != null && this.BGresults.size() > 0) {
                    t = (Tuple)this.BGresults.get(0);
                    this.BGresults.remove(0);
                    ++this.BGJoinResults;
                    return t;
                }
                if (this.processingProbe) {
                    if (this.currentProbeIndex < this.probeMatches.size()) {
                        match = (Tuple)this.probeMatches.get(this.currentProbeIndex++);
                        if (this.currentInput == 1) {
                            return this.outputJoinTuple(match, this.currentTuple);
                        }
                        return this.outputJoinTuple(this.currentTuple, match);
                    }
                    this.processingProbe = false;
                } else if (this.processingTimestampProbe) {
                    probeTuple = (TupleTS)this.currentTuple;
                    while (this.currentProbeIndex < this.probeMatches.size()) {
                        match = (TupleTS)this.probeMatches.get(this.currentProbeIndex++);
                        leftTS = Math.abs(match.getTimestamp());
                        rightTS = Math.abs(probeTuple.getTimestamp());
                        if ((rightTS <= this.rightPartitionFlushTS || rightTS > this.leftPartitionFlushTS || leftTS <= rightTS || leftTS <= this.lastRightProbe && leftTS <= this.leftPartitionFlushTS) && (rightTS > this.rightPartitionFlushTS || leftTS <= this.rightPartitionFlushTS || leftTS <= this.lastRightProbe && leftTS <= this.leftPartitionFlushTS) && rightTS <= this.leftPartitionFlushTS && leftTS <= this.leftPartitionFlushTS) continue;
                        return this.outputJoinTuple(match, this.currentTuple);
                    }
                    this.processingTimestampProbe = false;
                }
                if (this.processingInput) {
                    if (this.readInputTuple()) {
                        if (this.currentInput == 1 || this.probeRightTable) {
                            this.probeMatches = this.hashTable.probe(this.currentTuple, this.currentInput);
                            this.currentProbeIndex = 0;
                            this.processingProbe = this.probeMatches != null;
                        }
                        numOutput = this.hashTable.insert(this.currentTuple, this.currentInput, this.processingProbe != false && this.isMNJoin == false);
                        this.incrementTupleIOs(numOutput);
                        this.incrementPageIOs(numOutput / this.BLOCKING_FACTOR);
                        if (!this.hashTable.hasOverflow()) continue;
                        if (this.inPhaseOne) {
                            this.inPhaseOne = false;
                            this.leftSampleRate = this.leftSampleRatePhase2;
                            this.rightSampleRate = this.rightSampleRatePhase2;
                        }
                        this.biasedFlush();
                        continue;
                    }
                    this.processingInput = false;
                    numOutput = this.hashTable.close(DualHashTable.IS_FROZEN, this.timestamp);
                    this.incrementTupleIOs(numOutput);
                    this.incrementPageIOs((int)Math.ceil((double)numOutput / (double)this.BLOCKING_FACTOR));
                    this.firstCleanupPass = true;
                    this.partitionFileIndex = 0;
                    this.currentPartitionIndex = 0;
                    this.processingProbeInput = false;
                    this.partCleanup = new int[this.numPartitions];
                    phase1 = 0;
                    phase2 = 0;
                    i = 0;
                    while (i < this.numPartitions) {
                        if (this.hashTable.getPartitionState(0, i) == DualHashTable.IS_EXPANDING && this.hashTable.getPartitionState(1, i) == DualHashTable.IS_EXPANDING) {
                            this.partCleanup[i] = 0;
                        } else if (this.hashTable.getPartitionState(0, i) == DualHashTable.IS_EXPANDING) {
                            this.partCleanup[i] = 1;
                            ++phase1;
                        } else {
                            this.partCleanup[i] = 2;
                            ++phase2;
                        }
                        ++i;
                    }
                    if (!UnityDriver.DEBUG) continue;
                    System.out.println("Number of partitions: " + this.numPartitions + " Total frozen: " + (phase1 + phase2) + " Phase1: " + phase1 + " Phase 2: " + phase2);
                    continue;
                }
                if (this.processingProbeInput) {
                    if (!this.currentTuple.read(this.probeFile)) {
                        this.processingProbeInput = false;
                        this.currentInput = 1;
                        FileManager.closeFile(this.probeFile);
                    } else {
                        this.incrementTupleIOs();
                        if (this.ioCounter-- == 0) {
                            this.ioCounter = this.BLOCKING_FACTOR - 1;
                            this.incrementPageIOs();
                        }
                        this.probeMatches = this.hashTable.probe(this.currentTuple, 1);
                        this.processingProbe = false;
                        this.processingTimestampProbe = false;
                        if (this.probeMatches == null && this.isRightOuterJoin) {
                            this.probeMatches = new ArrayList<E>(1);
                            this.probeMatches.add(this.nullLeftTuple);
                            this.processingProbe = true;
                        } else if (this.probeMatches != null && this.usingTupleTS) {
                            this.processingTimestampProbe = true;
                        } else if (this.probeMatches != null) {
                            this.processingProbe = true;
                        }
                        this.currentProbeIndex = 0;
                        continue;
                    }
                }
                if (this.firstCleanupPass) {
                    if (this.partCleanup[this.currentPartitionIndex] != 1 || this.partitionFileIndex >= this.hashTable.getNumFiles(1, this.currentPartitionIndex)) {
                        ++this.currentPartitionIndex;
                        while (this.currentPartitionIndex < this.numPartitions && this.partCleanup[this.currentPartitionIndex] != 1) {
                            ++this.currentPartitionIndex;
                        }
                        this.partitionFileIndex = 0;
                    }
                    if (this.currentPartitionIndex >= this.numPartitions) {
                        this.firstCleanupPass = false;
                        if (this.isLeftOuterJoin) {
                            tmp = this.hashTable.getNonJoinedLeft();
                            if (this.BGresults == null) {
                                this.BGresults = new ArrayList<E>(tmp.size());
                            }
                            x = 0;
                            while (x < tmp.size()) {
                                this.BGresults.add(this.outputJoinTuple((Tuple)tmp.get(x), this.nullRightTuple));
                                ++x;
                            }
                        }
                        this.hashTable.empty();
                        this.currentPartitionIndex = 0;
                        this.partitionFileIndex = 0;
                        continue;
                    }
                    fileList = this.hashTable.getPartitionFileNames(1, this.currentPartitionIndex);
                    if (fileList.size() == 0) {
                        ++this.currentPartitionIndex;
                        continue;
                    }
                    fileName = (String)fileList.get(this.partitionFileIndex);
                    this.probeFile = FileManager.openInputFile(fileName);
                    this.processingProbeInput = true;
                    this.currentTuple = this.usingTupleTS != false ? new TupleTS(this.schemas[1], 0) : new Tuple(this.schemas[1]);
                    flushTimes = this.hashTable.getPartitionFlushTimes(1, this.currentPartitionIndex);
                    this.rightPartitionFlushTS = (Integer)flushTimes.get(this.partitionFileIndex);
                    this.leftPartitionFlushTS = EarlyHashJoin.MAX_INT;
                    probeTimes = this.hashTable.getPartitionProbeTimes(1, this.currentPartitionIndex);
                    this.lastRightProbe = (Integer)probeTimes.get(this.partitionFileIndex);
                    ++this.partitionFileIndex;
                    this.ioCounter = this.BLOCKING_FACTOR - 1;
                    continue;
                }
                if (this.currentPartitionIndex >= this.numPartitions) {
                    return null;
                }
                v0 = newPartition = this.currentPartitionIndex == 0 && this.partitionFileIndex == 0;
                if (this.partCleanup[this.currentPartitionIndex] != 2 || this.partitionFileIndex >= this.hashTable.getNumFiles(1, this.currentPartitionIndex)) {
                    ++this.currentPartitionIndex;
                    while (this.currentPartitionIndex < this.numPartitions && this.partCleanup[this.currentPartitionIndex] != 2) {
                        ++this.currentPartitionIndex;
                    }
                    this.partitionFileIndex = 0;
                    newPartition = true;
                }
                if (this.currentPartitionIndex >= this.numPartitions) {
                    return null;
                }
                if (!newPartition) break block43;
                fileList = this.hashTable.getPartitionFileNames(0, this.currentPartitionIndex);
                if (this.usingTupleTS) {
                    leftT = new TupleTS(this.schemas[0], 0);
                    this.currentTuple = new TupleTS(this.schemas[1], 0);
                } else {
                    leftT = new Tuple(this.schemas[0]);
                    this.currentTuple = new Tuple(this.schemas[1]);
                }
                i = 0;
                while (i < fileList.size()) {
                    block44: {
                        fileName = (String)fileList.get(i);
                        buildFile = FileManager.openInputFile(fileName);
                        this.hashTable.setPartitionState(0, this.currentPartitionIndex, DualHashTable.IS_EXPANDING);
                        count = 0;
                        if (!this.usingTupleTS) ** GOTO lbl169
                        while (leftT.read(buildFile)) {
                            ++count;
                            this.hashTable.insert(new TupleTS((TupleTS)leftT), 0, false);
                        }
                        break block44;
lbl-1000:
                        // 1 sources

                        {
                            ++count;
                            this.hashTable.insert(new Tuple(leftT), 0, false);
lbl169:
                            // 2 sources

                            ** while (leftT.read((BufferedInputStream)buildFile))
                        }
                    }
                    FileManager.closeFile(buildFile);
                    this.incrementTupleIOs(count);
                    this.incrementPageIOs((int)Math.ceil((double)count / (double)this.BLOCKING_FACTOR));
                    ++i;
                }
                flushTimes = this.hashTable.getPartitionFlushTimes(0, this.currentPartitionIndex);
                this.leftPartitionFlushTS = (Integer)flushTimes.get(0);
            }
            fileList = this.hashTable.getPartitionFileNames(1, this.currentPartitionIndex);
            fileName = (String)fileList.get(this.partitionFileIndex);
            this.probeFile = FileManager.openInputFile(fileName);
            this.processingProbeInput = true;
            flushTimes = this.hashTable.getPartitionFlushTimes(1, this.currentPartitionIndex);
            probeTimes = this.hashTable.getPartitionProbeTimes(1, this.currentPartitionIndex);
            this.rightPartitionFlushTS = (Integer)flushTimes.get(this.partitionFileIndex);
            this.lastRightProbe = (Integer)probeTimes.get(this.partitionFileIndex);
            ++this.partitionFileIndex;
            this.ioCounter = this.BLOCKING_FACTOR - 1;
        }
    }

    private void biasedFlush() throws IOException {
        DualHashTable.PartitionInfo[] partitions = this.hashTable.getPartitionInfo();
        int flushSize = -1;
        int flushIndex = -1;
        int source = 1;
        int i = 0;
        while (i < this.numPartitions) {
            int partIndex = this.numPartitions + i;
            if (partitions[partIndex].getState() != DualHashTable.IS_FROZEN && partitions[partIndex].getNumTuples() > flushSize) {
                flushSize = partitions[partIndex].getNumTuples();
                flushIndex = i;
            }
            ++i;
        }
        if (flushIndex == -1) {
            this.probeRightTable = false;
            flushSize = MAX_INT;
            source = 0;
            i = 0;
            while (i < this.numPartitions) {
                if (i != this.BGPartitionIndex && partitions[i].getState() != DualHashTable.IS_FROZEN && partitions[i].getNumTuples() < flushSize && partitions[i].getNumTuples() > MIN_FLUSH_SIZE) {
                    flushSize = partitions[i].getNumTuples();
                    flushIndex = i;
                }
                ++i;
            }
            if (flushIndex == -1) {
                flushSize = 0;
                i = 0;
                while (i < this.numPartitions) {
                    if (i != this.BGPartitionIndex && partitions[i].getState() != DualHashTable.IS_FROZEN && partitions[i].getNumTuples() > flushSize) {
                        flushSize = partitions[i].getNumTuples();
                        flushIndex = i;
                    }
                    ++i;
                }
            }
        }
        this.hashTable.flush(source, flushIndex, DualHashTable.IS_FROZEN, this.timestamp);
        this.incrementTupleIOs(flushSize);
        this.incrementPageIOs((int)Math.ceil((double)flushSize / (double)this.BLOCKING_FACTOR));
    }

    private void startBGProcess() throws IOException {
        DualHashTable.PartitionInfo[] partitions = this.hashTable.getPartitionInfo();
        int longestTime = MAX_INT;
        int partIndex = -1;
        int fileIndex = -1;
        boolean doDelete = false;
        if (partIndex == -1) {
            int i = 0;
            while (i < this.numPartitions) {
                int pIdx = this.numPartitions + i;
                int lProbeTime = partitions[pIdx].getLongestProbeTime(MIN_BG_PART_SIZE);
                if (partitions[pIdx].getState() == DualHashTable.IS_FROZEN && partitions[i].getState() != DualHashTable.IS_FROZEN && lProbeTime < longestTime && this.timestamp - lProbeTime >= MIN_TIME_DIFF_PROBE) {
                    longestTime = lProbeTime;
                    partIndex = pIdx;
                    fileIndex = partitions[pIdx].getFileIdx();
                }
                ++i;
            }
        }
        if (partIndex != -1) {
            this.BGThreadActive = true;
            this.BGPartitionIndex = partIndex;
            if (fileIndex == partitions[partIndex].fileNames.size() - 1 && partitions[partIndex].createNewOutputFile(1, this.timestamp)) {
                partitions[partIndex].probeTimes.add(new Integer(this.timestamp));
            }
            String fileName = (String)partitions[partIndex].fileNames.get(fileIndex);
            BufferedInputStream BGProbeFile = FileManager.openInputFile(fileName);
            ArrayList flushTimes = this.hashTable.getPartitionFlushTimes(1, partIndex - this.numPartitions);
            this.rightPartitionFlushTS = (Integer)flushTimes.get(fileIndex);
            partitions[partIndex].probeTimes.set(fileIndex, new Integer(this.timestamp));
            if (doDelete) {
                partitions[partIndex].probeTimes.remove(fileIndex);
                partitions[partIndex].flushTimes.remove(fileIndex);
                partitions[partIndex].fileNames.remove(fileIndex);
            }
            String newFname = "";
            if (!this.isMNJoin) {
                newFname = FileManager.createTempFileName(fileName.substring(0, 6));
                partitions[partIndex].fileNames.set(fileIndex, newFname);
            }
            BGThread bgthread = new BGThread(BGProbeFile, this.rightPartitionFlushTS, longestTime, doDelete, fileName, newFname);
            bgthread.run();
        }
    }

    private boolean readInputTuple() throws IOException {
        this.currentInput = 0;
        if (this.endLeft) {
            this.currentInput = 1;
        } else if (this.leftReadCounter <= 0 && this.rightReadCounter > 0 && !this.endRight) {
            this.currentInput = 1;
        }
        if (this.bothInputsBuffered) {
            BufferOperator op = (BufferOperator)this.input[this.currentInput];
            int otherInput = (this.currentInput + 1) % 2;
            BufferOperator op2 = (BufferOperator)this.input[otherInput];
            long startTime = System.currentTimeMillis();
            while (true) {
                if (!(!this.useBGProcess || this.BGThreadActive || !this.endLeft && !this.endRight || this.endLeft && this.endRight)) {
                    this.startBGProcess();
                }
                if (!this.endLeft && otherInput == 1 && op.endInput()) {
                    this.endLeft = true;
                    this.hashTable.setLeftInputFinished(true);
                    this.doRightPurge();
                }
                if (!this.endRight && otherInput == 0 && op.endInput()) {
                    this.hashTable.setRightInputFinished(true);
                    if (this.isLeftOuterJoin) {
                        ArrayList tmp = this.hashTable.getNonJoinedLeft();
                        if (this.BGresults == null) {
                            this.BGresults = new ArrayList(tmp.size());
                        }
                        int x = 0;
                        while (x < tmp.size()) {
                            this.BGresults.add(this.outputJoinTuple((Tuple)tmp.get(x), this.nullRightTuple));
                            ++x;
                        }
                    }
                    int tuplesRemoved = this.hashTable.clearRightFinished();
                    this.endRight = true;
                }
                if (this.endLeft && this.endRight) {
                    return false;
                }
                if (!op.endInput() && op.hasNext()) break;
                if (!op2.endInput() && op2.hasNext()) {
                    this.currentInput = otherInput;
                    break;
                }
                long currentTime = System.currentTimeMillis();
                long elapsedTime = currentTime - startTime;
                if (!(!this.useBGProcess || this.BGThreadActive || this.inPhaseOne || this.endLeft && this.endRight || elapsedTime <= (long)TIME_NO_INPUT && (!this.endLeft || elapsedTime <= (long)END_LEFT_TIME_NO_RIGHT_INPUT) && currentTime - this.lastSRead <= (long)TIME_NO_RIGHT_INPUT)) {
                    this.startBGProcess();
                }
                Thread.yield();
            }
        }
        if (this.currentInput == 0) {
            --this.leftReadCounter;
            if (this.leftReadCounter == 0) {
                this.rightReadCounter = this.rightSampleRate;
            }
        } else {
            --this.rightReadCounter;
            if (this.rightReadCounter == 0) {
                this.leftReadCounter = this.leftSampleRate;
            }
            this.lastSRead = System.currentTimeMillis();
        }
        this.currentTuple = this.input[this.currentInput].next();
        if (this.currentTuple == null) {
            int x;
            ArrayList tmp;
            if (this.currentInput == 0) {
                this.endLeft = true;
                this.hashTable.setLeftInputFinished(true);
                if (this.isRightOuterJoin) {
                    tmp = this.hashTable.getNonJoinedRight();
                    if (this.BGresults == null) {
                        this.BGresults = new ArrayList(tmp.size());
                    }
                    x = 0;
                    while (x < tmp.size()) {
                        this.BGresults.add(this.outputJoinTuple(this.nullLeftTuple, (Tuple)tmp.get(x)));
                        ++x;
                    }
                }
                int tuplesRemoved = this.hashTable.clearLeftFinished();
            } else {
                this.hashTable.setRightInputFinished(true);
                if (this.isLeftOuterJoin) {
                    tmp = this.hashTable.getNonJoinedLeft();
                    if (this.BGresults == null) {
                        this.BGresults = new ArrayList(tmp.size());
                    }
                    x = 0;
                    while (x < tmp.size()) {
                        this.BGresults.add(this.outputJoinTuple((Tuple)tmp.get(x), this.nullRightTuple));
                        ++x;
                    }
                }
                int tuplesRemoved = this.hashTable.clearRightFinished();
                this.endRight = true;
            }
            if (this.endLeft && this.endRight) {
                return false;
            }
            return this.readInputTuple();
        }
        ++this.timestamp;
        if (this.usingTupleTS) {
            this.currentTuple = new TupleTS(this.currentTuple, this.timestamp);
        }
        this.incrementTuplesRead();
        return true;
    }

    private void doRightPurge() {
        DualHashTable.PartitionInfo[] partitions = this.hashTable.getPartitionInfo();
        int outputCount = 0;
        this.BGresults = Collections.synchronizedList(new LinkedList());
        Tuple probeT = this.usingTupleTS ? new TupleTS(this.schemas[1], 0) : new Tuple(this.schemas[1]);
        try {
            int p = 0;
            while (p < this.numPartitions) {
                int probePartIndex = p + this.numPartitions;
                if (partitions[p].getNumFiles() == 0 && partitions[probePartIndex].getNumFiles() != 0) {
                    partitions[probePartIndex].close();
                    ArrayList probeFiles = partitions[probePartIndex].fileNames;
                    int i = probeFiles.size() - 1;
                    while (i >= 0) {
                        String fileName = (String)probeFiles.get(i);
                        BufferedInputStream BGProbeFile = FileManager.openInputFile(fileName);
                        ArrayList flushTimes = partitions[probePartIndex].flushTimes;
                        this.rightPartitionFlushTS = (Integer)flushTimes.get(i);
                        int lastProbe = (Integer)partitions[probePartIndex].probeTimes.get(i);
                        partitions[probePartIndex].probeTimes.set(i, new Integer(this.timestamp));
                        int count = 0;
                        while (probeT.read(BGProbeFile)) {
                            ++count;
                            ArrayList probeMatches = this.hashTable.probe(probeT, 1);
                            if (probeMatches == null) {
                                if (!this.isRightOuterJoin) continue;
                                if (!this.usingTupleTS || ((TupleTS)probeT).getTimestamp() > 0) {
                                    Tuple t = this.outputJoinTuple(this.nullLeftTuple, probeT);
                                    this.BGresults.add(t);
                                    ++outputCount;
                                    continue;
                                }
                            }
                            int j = 0;
                            while (j < probeMatches.size()) {
                                Tuple match;
                                if (this.isMNJoin) {
                                    match = (TupleTS)probeMatches.get(j);
                                    int buildTS = ((TupleTS)match).getTimestamp();
                                    int probeTS = ((TupleTS)probeT).getTimestamp();
                                    if (buildTS > lastProbe) {
                                        boolean notGenerated = false;
                                        boolean bl = notGenerated = probeTS > this.rightPartitionFlushTS && buildTS > probeTS || probeTS <= this.rightPartitionFlushTS;
                                        if (notGenerated) {
                                            Tuple t = this.outputJoinTuple(match, probeT);
                                            this.BGresults.add(t);
                                            ++outputCount;
                                        }
                                    }
                                } else {
                                    match = (Tuple)probeMatches.get(j);
                                    Tuple t = this.outputJoinTuple(match, probeT);
                                    this.BGresults.add(t);
                                    ++outputCount;
                                }
                                ++j;
                            }
                        }
                        FileManager.closeFile(BGProbeFile);
                        this.incrementTupleIOs(count);
                        this.incrementPageIOs((int)Math.ceil((double)count / (double)this.BLOCKING_FACTOR));
                        this.BGIOs += count;
                        --i;
                    }
                    partitions[probePartIndex].clear();
                }
                ++p;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        if (left instanceof TupleTS) {
            ((TupleTS)left).negateTimestamp();
        }
        if (right instanceof TupleTS) {
            ((TupleTS)right).negateTimestamp();
        }
        this.incrementTuplesOutput();
        return t;
    }

    public int getLeftSampleRatePhase1() {
        return this.leftSampleRatePhase1;
    }

    public int getRightSampleRatePhase1() {
        return this.rightSampleRatePhase1;
    }

    public boolean isLeftOuterJoin() {
        return this.isLeftOuterJoin;
    }

    public boolean isRightOuterJoin() {
        return this.isRightOuterJoin;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("EARLY HASH JOIN: ");
        sb.append(this.predicate.toString(this.input[0].getOutputRelation(), this.input[1].getOutputRelation()));
        sb.append("   (BufferSizeInTuples=" + this.BUFFER_SIZE + " ; ISMNJoin=" + this.isMNJoin + " ; IsLeftOuter=" + this.isLeftOuterJoin + " ; IsRightOuter=" + this.isRightOuterJoin + ")");
        return sb.toString();
    }

    private class BGThread
    extends Thread {
        private Tuple probeTuple;
        private BufferedInputStream BGProbeFile;
        private int lastProbeRight;
        private int rightPartitionFlushTS;
        private boolean deleteFile;
        private String fileName;
        private String newFileName;
        private BufferedOutputStream BGOutputFile;

        public BGThread(BufferedInputStream file, int rightFlushTS, int rightProbeTS, boolean delFile, String fname, String newFname) {
            this.probeTuple = EarlyHashJoin.this.usingTupleTS ? new TupleTS(EarlyHashJoin.this.schemas[1], 0) : new Tuple(EarlyHashJoin.this.schemas[1]);
            EarlyHashJoin.this.BGresults = Collections.synchronizedList(new LinkedList());
            this.BGProbeFile = file;
            this.lastProbeRight = rightProbeTS;
            this.rightPartitionFlushTS = rightFlushTS;
            this.fileName = fname;
            this.newFileName = newFname;
        }

        public void run() {
            int count = 0;
            int inNewFile = 0;
            try {
                if (!EarlyHashJoin.this.isMNJoin && !this.deleteFile) {
                    this.BGOutputFile = FileManager.openOutputFile(this.newFileName);
                }
                while (this.probeTuple.read(this.BGProbeFile)) {
                    Tuple match;
                    int i;
                    EarlyHashJoin.this.incrementTupleIOs();
                    EarlyHashJoin earlyHashJoin = EarlyHashJoin.this;
                    earlyHashJoin.BGIOs = earlyHashJoin.BGIOs + 1;
                    ArrayList probeMatches = EarlyHashJoin.this.hashTable.probe(this.probeTuple, 1);
                    if (!EarlyHashJoin.this.isMNJoin) {
                        if (probeMatches == null) {
                            this.probeTuple.write(this.BGOutputFile);
                            EarlyHashJoin earlyHashJoin2 = EarlyHashJoin.this;
                            earlyHashJoin2.BGIOs = earlyHashJoin2.BGIOs + 1;
                            ++inNewFile;
                            continue;
                        }
                        i = 0;
                        while (i < probeMatches.size()) {
                            match = (Tuple)probeMatches.get(i);
                            Tuple t = EarlyHashJoin.this.outputJoinTuple(match, this.probeTuple);
                            EarlyHashJoin.this.BGresults.add(t);
                            ++count;
                            ++i;
                        }
                        continue;
                    }
                    if (probeMatches == null) continue;
                    i = 0;
                    while (i < probeMatches.size()) {
                        match = (TupleTS)probeMatches.get(i);
                        int leftTS = ((TupleTS)match).getTimestamp();
                        int rightTS = ((TupleTS)this.probeTuple).getTimestamp();
                        if (leftTS > this.lastProbeRight && (rightTS > this.rightPartitionFlushTS && leftTS > rightTS || rightTS <= this.rightPartitionFlushTS)) {
                            Tuple t = EarlyHashJoin.this.outputJoinTuple(match, this.probeTuple);
                            EarlyHashJoin.this.BGresults.add(t);
                            ++count;
                        }
                        ++i;
                    }
                }
                FileManager.closeFile(this.BGProbeFile);
                if (!EarlyHashJoin.this.isMNJoin && !this.deleteFile) {
                    FileManager.closeFile(this.BGOutputFile);
                }
                if (this.deleteFile) {
                    FileManager.deleteFile(this.fileName);
                }
            }
            catch (Exception e) {
                System.out.println("BGThread exception: " + e);
            }
            EarlyHashJoin.this.BGThreadActive = false;
        }
    }
}

