/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.functions.ConstantValue;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.predicates.And;
import unity.predicates.Equal;
import unity.predicates.EquiJoinPredicate;
import unity.predicates.Greater;
import unity.predicates.GreaterEqual;
import unity.predicates.Less;
import unity.predicates.LessEqual;
import unity.predicates.Like;
import unity.predicates.Not;
import unity.predicates.Or;
import unity.predicates.Predicate;
import unity.predicates.SelectionExprPredicate;
import unity.predicates.SelectionPredicate;
import unity.predicates.XOr;
import unity.query.GQFieldRef;
import unity.query.LQExprNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.SubQuery;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQCondNode
extends LQNode
implements Cloneable {
    public int getType() {
        return this.type;
    }

    public String generateSQL() {
        String result = "";
        if (this.getChild(0) != null) {
            result = String.valueOf(result) + this.getChild(0).generateSQL() + " ";
        }
        result = String.valueOf(result) + (this.type == 100 ? ((GQFieldRef)this.getContent()).getLocalName() : this.getContent() + " ");
        if (this.getChild(1) != null) {
            result = String.valueOf(result) + this.getChild(1).generateSQL() + " ";
        }
        return result;
    }

    public String toString() {
        return "CONDITION: " + this.generateSQL();
    }

    public Operator buildOperator(Operator[] children) {
        return null;
    }

    public SelectionPredicate buildSelectionPredicate(Relation inputRel) throws SQLException {
        return this.buildSelPredicate(this, inputRel);
    }

    private SelectionPredicate buildSelPredicate(LQCondNode root, Relation inputRel) throws SQLException {
        SelectionPredicate pred = null;
        if (root == null) {
            return null;
        }
        int nodeType = root.getType();
        String nodeContent = (String)root.getContent();
        if (nodeType == 114) {
            Predicate p = null;
            if (nodeContent.equals("=")) {
                p = new Equal();
            } else if (nodeContent.equals("<=")) {
                p = new LessEqual();
            } else if (nodeContent.equals(">=")) {
                p = new GreaterEqual();
            } else if (nodeContent.equals(">")) {
                p = new Greater();
            } else if (nodeContent.equals("<")) {
                p = new Less();
            } else if (nodeContent.equals("!=")) {
                p = null;
            } else if (nodeContent.equalsIgnoreCase("LIKE")) {
                p = new Like();
            }
            Attribute leftAttr = new Attribute();
            Attribute rightAttr = new Attribute();
            Expression leftChild = ((LQExprNode)root.getChild(0)).buildExpression(inputRel, leftAttr);
            Expression rightChild = ((LQExprNode)root.getChild(1)).buildExpression(inputRel, rightAttr);
            if (leftChild instanceof ConstantValue || rightChild instanceof ConstantValue) {
                if (leftChild instanceof ConstantValue) {
                    ((ConstantValue)leftChild).changeType(rightChild.getReturnType());
                }
                if (rightChild instanceof ConstantValue) {
                    ((ConstantValue)rightChild).changeType(leftChild.getReturnType());
                }
            }
            SelectionExprPredicate exprPred = new SelectionExprPredicate(leftChild, rightChild, p);
            return exprPred;
        }
        if (nodeType == 112) {
            return new Not(this.buildSelPredicate((LQCondNode)root.getChild(0), inputRel));
        }
        if (nodeType == 110) {
            return new Or(this.buildSelPredicate((LQCondNode)root.getChild(0), inputRel), this.buildSelPredicate((LQCondNode)root.getChild(1), inputRel));
        }
        if (nodeType == 111) {
            return new And(this.buildSelPredicate((LQCondNode)root.getChild(0), inputRel), this.buildSelPredicate((LQCondNode)root.getChild(1), inputRel));
        }
        if (nodeType == 118) {
            return new XOr(this.buildSelPredicate((LQCondNode)root.getChild(0), inputRel), this.buildSelPredicate((LQCondNode)root.getChild(1), inputRel));
        }
        return pred;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getJoinFields(LQCondNode root, ArrayList leftFields, ArrayList rightFields, Relation leftRelation, Relation rightRelation) throws SQLException {
        int type = root.getType();
        if (type == 114 && ((String)root.content).equals("=")) {
            GQFieldRef fref = (GQFieldRef)root.getChild(0).getContent();
            if (leftRelation.getAttributeIndex(fref) != -1) {
                leftFields.add(fref);
                rightFields.add(root.getChild(1).getContent());
                return;
            } else {
                if (rightRelation.getAttributeIndex(fref) == -1) throw new SQLException("Error building join predicate.  Cannot find field: " + fref.getName());
                leftFields.add(root.getChild(1).getContent());
                rightFields.add(fref);
            }
            return;
        } else {
            if (type != 111) throw new SQLException("Join building error in getJoinFields().");
            LQCondNode.getJoinFields((LQCondNode)root.getChild(0), leftFields, rightFields, leftRelation, rightRelation);
            LQCondNode.getJoinFields((LQCondNode)root.getChild(1), leftFields, rightFields, leftRelation, rightRelation);
        }
    }

    public EquiJoinPredicate buildJoinPredicate(Operator[] children, LQJoinNode opNode) throws SQLException {
        EquiJoinPredicate predicate = null;
        ArrayList leftFields = new ArrayList();
        ArrayList rightFields = new ArrayList();
        Relation leftRelation = opNode.getChild(0).getOutputRelation();
        Relation rightRelation = opNode.getChild(1).getOutputRelation();
        LQCondNode.getJoinFields(this, leftFields, rightFields, leftRelation, rightRelation);
        int[] leftFieldIndex = new int[leftFields.size()];
        int[] rightFieldIndex = new int[leftFields.size()];
        opNode.setLeftFields(leftFields);
        opNode.setRightFields(rightFields);
        int joinType = leftFields.size() > 1 ? EquiJoinPredicate.OBJECT_KEY : (((GQFieldRef)leftFields.get(0)).getField().getDataType() == Attribute.TYPE_INT && ((GQFieldRef)rightFields.get(0)).getField().getDataType() == Attribute.TYPE_INT ? EquiJoinPredicate.INT_KEY : EquiJoinPredicate.STRING_KEY);
        int i = 0;
        while (i < leftFields.size()) {
            leftFieldIndex[i] = leftRelation.getAttributeIndex(leftFields.get(i));
            rightFieldIndex[i] = rightRelation.getAttributeIndex(rightFields.get(i));
            ++i;
        }
        predicate = new EquiJoinPredicate(leftFieldIndex, rightFieldIndex, joinType);
        return predicate;
    }

    public double getSelectivity() {
        double selectivity;
        block11: {
            selectivity = 1.0;
            if (this.type == 114) {
                LQNode leftChildNode = (LQNode)this.children.get(0);
                if (leftChildNode.getType() != 100) {
                    return selectivity;
                }
                GQFieldRef fref = (GQFieldRef)((LQNode)this.children.get(0)).getContent();
                int numDistinct = fref.getField().getNumDistinctValues();
                if (this.content.equals("=")) {
                    selectivity = 1.0 / (double)numDistinct;
                } else if (this.content.equals("!=")) {
                    selectivity = 1.0 - 1.0 / (double)numDistinct;
                } else if (this.content.equals("<") || this.content.equals("<=") || this.content.equals(">") || this.content.equals(">=")) {
                    try {
                        int constVal = Integer.parseInt((String)((LQNode)this.children.get(1)).getContent());
                        if (this.content.equals("<") || this.content.equals("<=")) {
                            selectivity = 1.0 * (double)constVal / (double)numDistinct;
                            break block11;
                        }
                        selectivity = 1 - constVal / numDistinct;
                    }
                    catch (Exception e) {
                        selectivity = 0.33;
                    }
                } else {
                    selectivity = 0.33;
                }
            }
        }
        return selectivity;
    }

    public Object clone() {
        try {
            LQCondNode lqcond = (LQCondNode)super.clone();
            if (this.children != null) {
                lqcond.children = new ArrayList(this.children.size());
                int i = 0;
                while (i < this.children.size()) {
                    lqcond.children.add(((LQNode)this.children.get(i)).clone());
                    ++i;
                }
            } else {
                lqcond.children = null;
            }
            lqcond.type = this.type;
            lqcond.content = this.content;
            lqcond.reference = this.reference;
            return lqcond;
        }
        catch (Exception e) {
            System.out.println(" exception while cloning " + e);
            return null;
        }
    }

    public void validateMerge(SubQuery leftSQ, SubQuery rightSQ) throws SQLException {
        int query2Offset = leftSQ.getLogicalQueryTree().getRoot().getOutputRelation().getNumAttributes();
        ArrayList exprNodes = LQCondNode.getAllExprNodes(this);
        Relation leftRelation = leftSQ.getLogicalQueryTree().getRoot().getOutputRelation();
        Relation rightRelation = rightSQ.getLogicalQueryTree().getRoot().getOutputRelation();
        int i = 0;
        while (i < exprNodes.size()) {
            LQCondNode.validateExpression((LQExprNode)exprNodes.get(i), leftRelation, rightRelation, query2Offset, null);
            ++i;
        }
    }

    public static void validateExpression(LQExprNode exprNode, Relation leftRelation, Relation rightRelation, int query2Offset, Relation filterRelation) throws SQLException {
        String exprText = exprNode.getContent() instanceof String ? (String)exprNode.getContent() : exprNode.getContent().toString();
        int index = LQCondNode.getAttributeIndex(exprText, leftRelation, rightRelation, query2Offset, filterRelation);
        if (index == -1) {
            throw new SQLException("Invalid attribute specified: " + exprText);
        }
        if (index < query2Offset) {
            exprNode.setContent(leftRelation.getAttribute(index).getReference());
        } else if (index < 10000) {
            exprNode.setContent(rightRelation.getAttribute(index - query2Offset).getReference());
        } else {
            exprNode.setContent(filterRelation.getAttribute(index - 10000).getReference());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getAttributeIndex(String attrName, Relation leftRelation, Relation rightRelation, int query2Offset, Relation filterRelation) throws SQLException {
        int index = -1;
        if ((attrName = attrName.toLowerCase()).matches("q\\d.c\\d*")) {
            try {
                index = Integer.parseInt(attrName.substring(4)) - 1;
                if (attrName.charAt(1) != '2') return index;
                index += query2Offset;
                return index;
            }
            catch (Exception e) {
                throw new SQLException("Invalid column number given for merge: " + attrName);
            }
        } else {
            int idx = leftRelation.getAttributeIndexByName(attrName);
            if (idx >= 0) {
                return idx;
            }
            idx = rightRelation.getAttributeIndexByName(attrName);
            if (idx >= 0) {
                return idx + query2Offset;
            }
            if (filterRelation == null || (idx = filterRelation.getAttributeIndexByName(attrName)) < 0) return index;
            return idx + 10000;
        }
    }

    public void validateFilter(SubQuery leftSubquery, SubQuery rightSubquery, Relation outputRelation) throws SQLException {
        ArrayList exprNodes = LQCondNode.getAllExprNodes(this);
        Relation leftRelation = leftSubquery.getLogicalQueryTree().getRoot().getOutputRelation();
        Relation rightRelation = rightSubquery.getLogicalQueryTree().getRoot().getOutputRelation();
        int query2Offset = leftSubquery.getLogicalQueryTree().getRoot().getOutputRelation().getNumAttributes();
        int i = 0;
        while (i < exprNodes.size()) {
            LQCondNode.validateExpression((LQExprNode)exprNodes.get(i), leftRelation, rightRelation, query2Offset, outputRelation);
            ++i;
        }
    }
}

