#!/usr/bin/perl

require Image::ExifTool;

my $file = shift(@ARGV);
$file = \*STDIN unless $file;

my $tool = new Image::ExifTool;

$tool->Options(Sort => 'File');

my $tag_hash = $tool->ImageInfo($file);

my @tag_list = $tool->GetTagList();

foreach my $tag (@tag_list) {
    my $value = convert_value($tag_hash->{$tag});
    print Image::ExifTool::GetTagName($tag) . ':' . $tool->GetDescription($tag) . ':' . $value . "\n";
}

sub convert_value {
    (my $str) = @_;

    $str =~ tr/\x00-\x1f\x7f-\xff/_/; # remove unreadable characters
    $str =~ s/\s+$//;                 # remove trailing blank
    $str =~ s/^(.{100}).+$/$1.../;    # cut too long lines

    return $str;
}
