/*  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.

 This file is part of GSview.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GSVIEW General Public License for more details.

 Everyone is granted permission to copy, modify and redistribute
 this program, but only under the conditions described in the GSVIEW
 General Public License.  A copy of this license is supposed to have been
 given to you along with this program so you can know your rights and
 responsibilities.  It should be in a file named COPYING.  Among other
 things, the copyright notice and this notice must be preserved on all
 copies. */

/* gvpeps.c */
/* EPS file manipulation module for PM GSview */

#include "gvpm.h"
#include "gvceps.h"

LPBITMAP2
get_bitmap()
{
	return (LPBITMAP2)bitmap.pbmi;
}

void
release_bitmap()
{
	/* no action for PM */
}

void 
make_eps_metafile(void)
{
	not_implemented();
}

/* Write out a BMP file */
void
paste_to_file(void)
{
	LPBITMAP1 pbm1 = (LPBITMAP1)bitmap.pbmi;
	BITMAPFILEHEADER2 bmfh;
	UINT bmfh_length = sizeof(BITMAPFILEHEADER2) - sizeof(BITMAPINFOHEADER2);
	UINT offset;
	UINT length;	/* bitmap length */
	ULONG fh;	/* file handle */
	ULONG action;
	ULONG count;
	char output[MAXSTR];
	strcpy(output, "*.bmp");
	if (!get_filename(output, TRUE, FILTER_BMP, 0, IDS_TOPICEDIT))
		return;

	bmfh.usType = 0x4d42;	/* "BM" */
        if (bitmap.pbmi->cbFix == sizeof(BITMAP1)) {
	    offset = pbm1->bcSize + sizeof(RGB3) * dib_pal_colors((LPBITMAP2)bitmap.pbmi);
	    length = offset + ( dib_bytewidth((LPBITMAP2)bitmap.pbmi) * pbm1->bcHeight );
	}
	else {
	    offset = bitmap.pbmi->cbFix + sizeof(RGB2) * dib_pal_colors((LPBITMAP2)bitmap.pbmi);
	    length = offset + ( dib_bytewidth((LPBITMAP2)bitmap.pbmi) * bitmap.pbmi->cy );
	}
	bmfh.cbSize = bmfh_length + length;
	bmfh.xHotspot = bmfh.yHotspot = 0;
	bmfh.offBits = bmfh_length + offset;
	if (DosOpen(output,	/* filename */
		&fh,		/* pointer to handle */
		&action,	/* pointer to result */
		0,		/* initial length */
		FILE_NORMAL,	/* normal file */
		OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS,
		OPEN_ACCESS_WRITEONLY | OPEN_SHARE_DENYREADWRITE,
		0)) {
		gserror(0, "Error opening BMP file", MB_ICONEXCLAMATION, SOUND_ERROR);
		return;
	}
	if (DosWrite(fh, (PBYTE)&bmfh, bmfh_length, &count))
		gserror(0, "Error writing BMP header", MB_ICONEXCLAMATION, SOUND_ERROR);
	if (DosWrite(fh, (PBYTE)bitmap.pbmi, length, &count))
		gserror(0, "Error writing BMP body", MB_ICONEXCLAMATION, SOUND_ERROR);
	if (DosClose(fh))
		gserror(0, "Error closing BMP file", MB_ICONEXCLAMATION, SOUND_ERROR);
}

void
clip_convert()
{
	not_implemented();
}
