/*  -*-c++-*-     tell emacs to use c++ mode
 *  --------------------------------------------------------------------
 *        $Id$
 *
 *   $RCSfile$
 *    $Source$
 *    $Author$
 *  $Revision$
 *      $Date$
 *      $Name$
 *    $Locker$
 *     $State$
 *
 *  --------------------------------------------------------------------
 *       $Log$
 *
 */

/*  --------------------------------------------------------------------
 *    IPv6CP.H
 *
 *    PPP IP v6 control protocol header
 *
 *    Reference:  RFC 1548  --  The Point-to-Point Protocol (PPP)
 *                RFC 1570  --  PPP LCP Extensions
 *
 *                draft-ietf-ipngwg-pppext-ipv6cp-03.txt, 
 *                Haskin + Allen, Bay Networks, Inc., May 1996
 *
 *
 *    Thomas Nagel <T.Nagel@ping.de>
 *    06-Oct-1996 KTN
 *  --------------------------------------------------------------------
 */
 
#ifndef IPV6CP_H_INCLUDED       /* prevent from multiple including */
#define IPV6CP_H_INCLUDED

#include <in6.h>

/* 
 * the following struct defines an IPv6 address.
 * it should be placed in "linux/include/linux/in.h" later 
 *
 *struct in_addr6
 *{
 *  unsigned char s6_addr[16];
 *};
 */

/*
 * Options.
 */
#define CI_INTERFACE_TOKEN      1       /* interface token */
#define CI_COMPRESSION          2       /* IPv6 compression protocol */

#define CI_IPv6_HDRCOMPRESSION  0x004f  /* IPv6 header compression */


/*
 * Option structure.
 *
 * We have four(!) of these structs for each interface:
 * - 'want options': which options we want to request.
 * - 'got options':  which options the peer ack'ed.
 * - 'allow options': the options we are prepared to ack, if requested.
 * - 'peer options': those options the peer actually requested, and we ack'ed.
 */
typedef struct  ipv6cp_options
{
  short         fToken;           /* negotiate interface token ? */
  u_long        Token;            /* interface token (in host byte order) */
  struct in6_addr  ipv6addr;      /* resulting ip v6 address from the token */

  short         fComprProt;       /* negotiate IPv6 compression protocol ? */
  u_short       CompressionProtocol;    /* compression protocol id */

#ifdef USE_IPV6_DEFAULTREOUTES
  short         default_route;    /* needed ? */
#endif

} ipv6cp_options;

extern fsm ipv6cp_fsm[];
extern ipv6cp_options ipv6cp_wantoptions[];
extern ipv6cp_options ipv6cp_gotoptions[];
extern ipv6cp_options ipv6cp_allowoptions[];
extern ipv6cp_options ipv6cp_hisoptions[];

void  ipv6cp_init         __P((int));
void  ipv6cp_open         __P((int));
void  ipv6cp_close        __P((int));
void  ipv6cp_lowerup      __P((int));
void  ipv6cp_lowerdown    __P((int));
void  ipv6cp_input        __P((int, u_char *, int));
void  ipv6cp_protrej      __P((int));
int   ipv6cp_printpkt     __P((u_char *, int, void (*)(), void *));


#endif  /* IPV6CP_H_INCLUDED */

/*  -------------------------------------------------------------------- *
 *  end of file
 *  -------------------------------------------------------------------- */

