/* File attlist.ch created by Ward Nelson
   (c) Copyright IBM Corp.  (This work is unpublished).  All rights reserved.  */

#include <list.ih> /* required because of superclass' nasty macromethods */

struct htmlatts {
    char * name;
    char * value;
    boolean quoted;
};

class attlist : list  {
    methods:
      DebugPrint();
    
      AddAttribute(char *name, char *value, boolean quoted);
      GetAttribute(char *name) returns struct htmlatts *;
      ClearAttributes();
      MakeFromString(char *str);
      MakeIntoString() returns char *;

      CopyAttributes() returns struct attlist *;
    
    classprocedures:
      InitializeObject(struct attlist *self) returns boolean;
      FinalizeObject(struct attlist *self);
      InitializeClass() returns boolean;

      ParseAttributes(char *str) returns struct attlist *;
      Copy(struct attlist *dst, struct attlist *src);
};


/* cistrcmp is a case-insensitive strcmp, used mainly to match up attribute names (which are not case-sensitive) */
int cistrcmp(a, b)
char *a, *b;
{
    int delta;
    do  {
	delta= tolower(*a) - tolower(*b);
    } while (!delta && *a++ && *b++);
    return delta;
}
