/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: grafik.h
**
** benoetigt:
**  global.h
**
** Kommentar:
**  Definition der Datentypen und Prototypen fuer den Grafikteil
*/


static char sccsid_grafik[] = "@(#)grafik.h	1.18 26 Oct 1994";


#ifndef SICHTW
#define SICHTW 16    /* Sichtweite des Spielers in Bloecken, maximal 64 */
#endif

#define WANDH RASPT  /* Hoehe der Waende (relativ zur Gangbreite) */

#define FENSTER_BREITE 65536  /* virtuelle Fensterbreite in Bildpunkten*/
#define FENSTER_HOEHE 65536   /* virtuelle Fensterhoehe in Bildpunkten*/

#define KEINELINIE 0 /* Flags fuer struct kartenlinie */
#define WANDLINIE  1
#define TUERLINIE  2


struct punkt
{
	int x, y;
};

/* enthaelt Koordinaten in Bildpunkten zum Zeichnen der Waende
   auf der Karte; wird in rechne_karte berechnet */
struct kartenlinie
{
	struct punkt ecke; /* linkes/oberes Ende der Wand */
	int laenge;        /* Laenge der Wand */
	u_char senkrecht;  /* falls Wand von oben nach unten */
	u_char typ1;       /* Typ der Wand von links/oben */
	u_char typ2;       /* Typ der Wand von rechts/unten */
};

/* enthaelt Koordinaten in Bildpunkten zum Zeichen der Spieler
   auf der Karte; wird in rechne_karte berechnet */
struct kartenkreis
{
	struct punkt mittelpunkt;
	int radiusx, radiusy;
	u_char farbe;
};

/* enthaelt Koordinaten in Bildpunkten zum Zeichnen der Waende;
   wird in rechne3d berechnet */
struct flaeche
{
	/* ecke[0] links oben, ecke[1] links unten,
	   ecke[2] rechts unten, ecke[3] rechts oben */
	struct punkt ecke[4];
	u_char farbe; /* kann TRANSPARENT sein */
	u_char tuer;  /* falls Wand eine Tuer ist */
};

struct ausschnitt
{
	int x, breite;
};

/* enthaelt Koordinaten in Bildpunkten und Grafikinformationen zum Zeichnen
   von Spielern und Schuessen; wird in rechne3d berechnet */
struct kugel
{
	struct punkt mittelpunkt;
	struct ausschnitt *sichtbar; /* Clipping-Bereiche */
	int sichtanz;                /* Anzahl der Clipping-Bereiche */
	int radiusx, radiusy;
	/* schattenx wie mittelpunkt.x/radiusx */
	int schatteny, schattenry;   /* schattenry 0, falls kein Schatten */
	int blick;                   /* ist -1 falls kein Gesicht */
	u_char farbe;                /* kann TRANSPARENT sein */
};

/* enthaelt gesammelte Daten fuer 3D-Zeichnung und Spruch des Gegners */
struct objektdaten
{
	int hintergrund_zeichnen; /* Himmel, Boden, Horizont zeichnen */
	int anzwaende;
	struct flaeche *waende;
	int anzkugeln;
	struct kugel *kugeln;
	char *text; /* Spruch des Gegners oder NULL */
};

/* enthaelt Punkte und Farbe eines Spielers */
struct punktestand
{
	int punkte;
	u_char farbe;
};

/* enthaelt gesamte Punktestanddaten fuer alle Spieler */
struct punktedaten
{
	int anzpunkte;
	struct punktestand *punkte;
};


/* Prototypen fuer globale Grafik-Funktionen */

#ifdef __STDC__

void zeichne_blickfeld(struct objektdaten *objekte_neu);
void zeichne_rueckspiegel(struct objektdaten *objekte_rueck_neu);
void zeichne_karte(int spieler_index, int anzkreise_neu,
	struct kartenkreis *kreise_neu);
void zeichne_grundriss(int anzlinien_neu, struct kartenlinie *linien_neu);
void zeichne_kompass(int blickrichtung_neu);
void zeichne_punkte(struct punktedaten *punkte_neu);
void zeichne_sync_anfang(void);
void zeichne_sync_ende(void);
void grafik_schleife(void);
int grafik_init(int *argc, char **argv);
void grafik_ende(void);
void disconnect_abfrage(void);
void ueblen_fehler_anzeigen(char **meldung, char *knopf);
int rueckfrage(char **meldung, char *weiter_knopf, char *abbruch_knopf);

#else

void zeichne_blickfeld();
void zeichne_rueckspiegel();
void zeichne_karte();
void zeichne_grundriss();
void zeichne_kompass();
void zeichne_punkte();
void zeichne_sync_anfang();
void zeichne_sync_ende();
void grafik_schleife();
int grafik_init();
void grafik_ende();
void disconnect_abfrage();
void ueblen_fehler_anzeigen();
int rueckfrage();

#endif
