#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/lib/common/RCS/fmt.c,v 1.2 89/09/02 18:04:20 mr-frog Exp $";
#endif

/*
 * fmt.c
 *
 * I assume here that everyone has a vsprintf call.  If you don't
 * have one, you'd better find one.
 *
 * Dave Pare, 1989
 */

#include <stdio.h>
#include <ctype.h>
#include <varargs.h>
#include "proto.h"
#include "misc.h"
#include "nat.h"

/*
 * Here's where we want vsprintf.
 * Fmt dumps it's arg list into a static space, and
 * returns a pointer to that static space.  This
 * means that you can only call fmt once, and then
 * you must either copy the value out, or use it
 * right away.
 *
 * NOTE: varargs fans!  Any vararg-using function must not
 * have anything other than va_alist in the parameter list.
 * Read your manuals carefully!
 */
/*VARARGS*/
char *
fmt(va_alist)
	va_dcl
{
	static	char buf[1024];
	char	*format;
	va_list	ap;

	va_start(ap);
	format = va_arg(ap, char *);
	(void) vsprintf(buf, format, ap);
	va_end(ap);
	return buf;
}
