#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/flee.c,v 1.6 89/07/16 01:07:29 jeffw Exp $";
#endif /* not lint */

/*
 * flee.c
 *
 * add ships to fleet
 *
 * from PSL Empire, 1985
 * XXX should merge with wing.c.
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

flee()
{
	extern	char *argp[];
	struct shpstr ship;
	register int count;
	char	*cp;
	char	c;
	struct	nstr_item nstr;
#ifdef RETREAT
	struct  nstr_item ni;
	struct	shpstr ship2;
	int	r;
#endif /* RETREAT */

	cp = getstarg(argp[1], "fleet? ");
	if (cp == 0)
		return RET_SYN;
	c = *cp;
	if (!isalpha(c) && c != '~') {
		pr("Specify fleet, (1 alpha char or '~')\n");
		return RET_SYN;
	}
	if (c == '~')
		c = ' ';
	if (!snxtitem(&nstr, EF_SHIP, argp[2]))
		return RET_SYN;
	count = 0;
	while (nxtitem(&nstr, (char *)&ship)) {
		if (!owner)
			continue;
		ship.shp_fleet = c;
#ifdef RETREAT
		snxtitem(&ni, EF_SHIP, cp);
		while((r=nxtitem(&ni, &ship2))
			&& (ship2.shp_fleet != c));
		if (r){
			bcopy(ship2.shp_rpath, ship.shp_rpath,10);
			ship.shp_rflags = ship2.shp_rflags;
		}
#endif /* RETREAT */
		putship(nstr.cur, &ship);
		count++;
	}
	pr(fmt("%d ship%s added to fleet `%c'\n", count, splur(count), c));
	return RET_OK;
}
