#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "sect.h"

struct sctstr world[WORLD_Y*(WORLD_X/2)];

main()
{
    FILE    *fp, *fopen();
    int     sectf, x;
    char    *sectfil;
    struct sctstr *sp;
    char    buf[80], *sprintf();

    if ((fp=fopen("sector.ascii", "w")) == (FILE *)0){
        fprintf(stderr,"Cannot write sector.ascii!\n");
        exit(-1);
    }

    sectf = open(sprintf(buf,"%s/sector",DATADIR), O_RDONLY, 0);

    if (sectf == -1){
        fprintf(stderr,"Cannot read %s/sector\n",DATADIR);
        exit(-1);
    }

    read(sectf, world, sizeof(world));
    close(sectf);

    sp = world;
    for(x=0;x<((WORLD_X/2)*WORLD_Y);x++,sp++)
        write_sector(sp, fp);

    fclose(fp);
}

write_sector(sp, fp)
struct sctstr *sp;
FILE *fp;
{
    int x;
    fprintf(fp,"%d ",sp->sct_x);
    fprintf(fp,"%d ",sp->sct_y);
    fprintf(fp,"%d ",sp->sct_own);
    fprintf(fp,"%d ",sp->sct_type);
    fprintf(fp,"%d ",sp->sct_effic);
    fprintf(fp,"%d ",sp->sct_mobil);
    fprintf(fp,"%d ",sp->sct_loyal);
    fprintf(fp,"%d ",sp->sct_terr);
    fprintf(fp,"%D ",sp->sct_distpath);
    fprintf(fp,"%d ",sp->sct_elev);
    fprintf(fp,"%d ",sp->sct_avail);
    fprintf(fp,"%d ",sp->sct_fill);
    fprintf(fp,"%d ",sp->sct_work);
    fprintf(fp,"%d ",sp->sct_flags);
    fprintf(fp,"%d ",sp->sct_newtype);
    fprintf(fp,"%d ",sp->sct_min);
    fprintf(fp,"%d ",sp->sct_gmin);
    fprintf(fp,"%d ",sp->sct_fertil);
    fprintf(fp,"%d ",sp->sct_oil);
    fprintf(fp,"%d ",sp->sct_uran);
    fprintf(fp,"%d ",sp->sct_oldown);
    fprintf(fp,"%d ",sp->sct_nv);
    for (x=0;x<MAXSCTV;x++)
        fprintf(fp,"%d ",sp->sct_vtype[x]);
    for (x=0;x<MAXSCTV;x++)
        fprintf(fp,"%d ",sp->sct_vamt[x]);

    fprintf(fp,"\n");
};
