from pip._vendor.chardet.sbcharsetprober import SingleByteCharSetModel

# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

TURKISH_LANG_MODEL = {
    23: {  # 'A'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 1,  # 'i'
        24: 0,  # 'j'
        10: 2,  # 'k'
        5: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 1,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    37: {  # 'B'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 2,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
    47: {  # 'C'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 1,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 2,  # 'l'
        13: 2,  # 'm'
        4: 2,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 2,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 1,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    39: {  # 'D'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 1,  # 'l'
        13: 3,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 1,  # 'Ş'
        19: 0,  # 'ş'
    },
    29: {  # 'E'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 1,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 0,  # 'h'
        3: 1,  # 'i'
        24: 1,  # 'j'
        10: 0,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 1,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    52: {  # 'F'
        23: 0,  # 'A'
        37: 1,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 1,  # 'E'
        52: 2,  # 'F'
        36: 0,  # 'G'
        45: 2,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 1,  # 'b'
        28: 1,  # 'c'
        12: 1,  # 'd'
        2: 0,  # 'e'
        18: 1,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 2,  # 'i'
        24: 1,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 2,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 2,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 1,  # 'Ö'
        55: 2,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 2,  # 'ş'
    },
    36: {  # 'G'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 2,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 2,  # 'N'
        42: 1,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 1,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 1,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 0,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 1,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 2,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    45: {  # 'H'
        23: 0,  # 'A'
        37: 1,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 2,  # 'G'
        45: 1,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 1,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 2,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 2,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 1,  # 'p'
        7: 1,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 2,  # 'ğ'
        41: 1,  # 'İ'
        6: 0,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    53: {  # 'I'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 2,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
    60: {  # 'J'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 0,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 1,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 1,  # 's'
        9: 0,  # 't'
        14: 0,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    16: {  # 'K'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 1,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 0,  # 'u'
        32: 3,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 1,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    49: {  # 'L'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 2,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 2,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 0,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 2,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 2,  # 'n'
        15: 1,  # 'o'
        26: 1,  # 'p'
        7: 1,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 0,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 2,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 1,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    20: {  # 'M'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 2,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 0,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    46: {  # 'N'
        23: 0,  # 'A'
        37: 1,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 1,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 1,  # 'o'
        26: 1,  # 'p'
        7: 1,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 1,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 1,  # 'İ'
        6: 2,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
    42: {  # 'O'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 1,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 2,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 2,  # 'İ'
        6: 1,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
    48: {  # 'P'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 2,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 2,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 0,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    44: {  # 'R'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 1,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 2,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 1,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
    35: {  # 'S'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 1,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 1,  # 'l'
        13: 2,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 1,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 2,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    31: {  # 'T'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 3,  # 'e'
        18: 2,  # 'f'
        27: 2,  # 'g'
        25: 0,  # 'h'
        3: 1,  # 'i'
        24: 1,  # 'j'
        10: 2,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 2,  # 'r'
        8: 0,  # 's'
        9: 2,  # 't'
        14: 2,  # 'u'
        32: 1,  # 'v'
        57: 1,  # 'w'
        58: 1,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    51: {  # 'U'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 1,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 1,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    38: {  # 'V'
        23: 1,  # 'A'
        37: 1,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 2,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 1,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 1,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 3,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    62: {  # 'W'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 0,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 0,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 0,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    43: {  # 'Y'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 0,  # 'G'
        45: 1,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 2,  # 'N'
        42: 0,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 1,  # 'j'
        10: 1,  # 'k'
        5: 1,  # 'l'
        13: 3,  # 'm'
        4: 0,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 1,  # 'Ü'
        59: 1,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 0,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    56: {  # 'Z'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 2,  # 'Z'
        1: 2,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 2,  # 'i'
        24: 1,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 1,  # 'r'
        8: 1,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    1: {  # 'a'
        23: 3,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 3,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 2,  # 'Z'
        1: 2,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 2,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 3,  # 'v'
        57: 2,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 1,  # 'î'
        34: 1,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    21: {  # 'b'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 3,  # 'g'
        25: 1,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 3,  # 'p'
        7: 1,  # 'r'
        8: 2,  # 's'
        9: 2,  # 't'
        14: 2,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    28: {  # 'c'
        23: 0,  # 'A'
        37: 1,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 2,  # 'E'
        52: 0,  # 'F'
        36: 2,  # 'G'
        45: 2,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 2,  # 'T'
        51: 2,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 3,  # 'Y'
        56: 0,  # 'Z'
        1: 1,  # 'a'
        21: 1,  # 'b'
        28: 2,  # 'c'
        12: 2,  # 'd'
        2: 1,  # 'e'
        18: 1,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 1,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 2,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 1,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 1,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 1,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 1,  # 'î'
        34: 2,  # 'ö'
        17: 2,  # 'ü'
        30: 2,  # 'ğ'
        41: 1,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 2,  # 'ş'
    },
    12: {  # 'd'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 2,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 1,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 2,  # 'i'
        24: 3,  # 'j'
        10: 2,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 2,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 1,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    2: {  # 'e'
        23: 2,  # 'A'
        37: 0,  # 'B'
        47: 2,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 3,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 2,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 3,  # 'v'
        57: 2,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 1,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    18: {  # 'f'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 2,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 1,  # 'i'
        24: 1,  # 'j'
        10: 1,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 1,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 1,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    27: {  # 'g'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 1,  # 'h'
        3: 2,  # 'i'
        24: 3,  # 'j'
        10: 2,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 2,  # 'r'
        8: 2,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    25: {  # 'h'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 2,  # 'h'
        3: 2,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 1,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    3: {  # 'i'
        23: 2,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 1,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 2,  # 'f'
        27: 3,  # 'g'
        25: 1,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 1,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 1,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 1,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 1,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    24: {  # 'j'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 2,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 1,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 2,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 2,  # 'i'
        24: 1,  # 'j'
        10: 2,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 2,  # 'r'
        8: 3,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 2,  # 'x'
        11: 1,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    10: {  # 'k'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 3,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 3,  # 'e'
        18: 1,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 2,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 3,  # 'p'
        7: 2,  # 'r'
        8: 2,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 3,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    5: {  # 'l'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 1,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 1,  # 'l'
        13: 1,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 2,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    13: {  # 'm'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 3,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 2,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 2,  # 'u'
        32: 2,  # 'v'
        57: 1,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    4: {  # 'n'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 2,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 1,  # 'f'
        27: 2,  # 'g'
        25: 3,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 3,  # 'p'
        7: 2,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 2,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    15: {  # 'o'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 2,  # 'L'
        20: 0,  # 'M'
        46: 2,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 1,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 1,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 2,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 2,  # 'ğ'
        41: 2,  # 'İ'
        6: 3,  # 'ı'
        40: 2,  # 'Ş'
        19: 2,  # 'ş'
    },
    26: {  # 'p'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 2,  # 'i'
        24: 3,  # 'j'
        10: 1,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 2,  # 'r'
        8: 1,  # 's'
        9: 1,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 1,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    7: {  # 'r'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 1,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 2,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 1,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 3,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    8: {  # 's'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 2,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 2,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    9: {  # 't'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 2,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 3,  # 'v'
        57: 0,  # 'w'
        58: 2,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    14: {  # 'u'
        23: 3,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 2,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 3,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 2,  # 'Z'
        1: 2,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 2,  # 'e'
        18: 2,  # 'f'
        27: 3,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 2,  # 'v'
        57: 2,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 3,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    32: {  # 'v'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 1,  # 'j'
        10: 1,  # 'k'
        5: 3,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 1,  # 'r'
        8: 2,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    57: {  # 'w'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 1,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 1,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 1,  # 's'
        9: 0,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 2,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    58: {  # 'x'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 1,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 1,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 2,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 1,  # 'r'
        8: 2,  # 's'
        9: 1,  # 't'
        14: 0,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    11: {  # 'y'
        23: 1,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 2,  # 'i'
        24: 1,  # 'j'
        10: 2,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 2,  # 'r'
        8: 1,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 3,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    22: {  # 'z'
        23: 2,  # 'A'
        37: 2,  # 'B'
        47: 1,  # 'C'
        39: 2,  # 'D'
        29: 3,  # 'E'
        52: 1,  # 'F'
        36: 2,  # 'G'
        45: 2,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 2,  # 'N'
        42: 2,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 3,  # 'T'
        51: 2,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 1,  # 'Z'
        1: 1,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 2,  # 'd'
        2: 2,  # 'e'
        18: 3,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 2,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 0,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 3,  # 'y'
        22: 2,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 2,  # 'Ü'
        59: 1,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 2,  # 'ü'
        30: 2,  # 'ğ'
        41: 1,  # 'İ'
        6: 3,  # 'ı'
        40: 1,  # 'Ş'
        19: 2,  # 'ş'
    },
    63: {  # '·'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 1,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    54: {  # 'Ç'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 1,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 1,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 0,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 0,  # 'h'
        3: 3,  # 'i'
        24: 0,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 2,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 2,  # 'r'
        8: 0,  # 's'
        9: 1,  # 't'
        14: 0,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 2,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    50: {  # 'Ö'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 2,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 2,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 1,  # 'N'
        42: 2,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 2,  # 'd'
        2: 0,  # 'e'
        18: 1,  # 'f'
        27: 1,  # 'g'
        25: 1,  # 'h'
        3: 2,  # 'i'
        24: 0,  # 'j'
        10: 2,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 3,  # 'n'
        15: 2,  # 'o'
        26: 2,  # 'p'
        7: 3,  # 'r'
        8: 1,  # 's'
        9: 2,  # 't'
        14: 0,  # 'u'
        32: 1,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 2,  # 'ü'
        30: 1,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    55: {  # 'Ü'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 1,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 1,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 1,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 1,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 1,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 0,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    59: {  # 'â'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 0,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 2,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 2,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 1,  # 'Ş'
        19: 0,  # 'ş'
    },
    33: {  # 'ç'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 3,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 0,  # 'Z'
        1: 0,  # 'a'
        21: 3,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 0,  # 'e'
        18: 2,  # 'f'
        27: 1,  # 'g'
        25: 3,  # 'h'
        3: 3,  # 'i'
        24: 0,  # 'j'
        10: 3,  # 'k'
        5: 0,  # 'l'
        13: 0,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 2,  # 's'
        9: 3,  # 't'
        14: 0,  # 'u'
        32: 2,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 1,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    61: {  # 'î'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 0,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 0,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 2,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 1,  # 'j'
        10: 0,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 1,  # 'n'
        15: 0,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 1,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 1,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 1,  # 'î'
        34: 0,  # 'ö'
        17: 0,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 1,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    34: {  # 'ö'
        23: 0,  # 'A'
        37: 1,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 1,  # 'G'
        45: 1,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 1,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 2,  # 'c'
        12: 1,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 2,  # 'h'
        3: 1,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 2,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 0,  # 'r'
        8: 3,  # 's'
        9: 1,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 1,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 0,  # 'ü'
        30: 2,  # 'ğ'
        41: 1,  # 'İ'
        6: 1,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    17: {  # 'ü'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 0,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 1,  # 'J'
        16: 1,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 0,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 0,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 0,  # 'c'
        12: 1,  # 'd'
        2: 3,  # 'e'
        18: 1,  # 'f'
        27: 2,  # 'g'
        25: 0,  # 'h'
        3: 1,  # 'i'
        24: 1,  # 'j'
        10: 2,  # 'k'
        5: 3,  # 'l'
        13: 2,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 2,  # 'p'
        7: 2,  # 'r'
        8: 3,  # 's'
        9: 2,  # 't'
        14: 3,  # 'u'
        32: 1,  # 'v'
        57: 1,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 2,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    30: {  # 'ğ'
        23: 0,  # 'A'
        37: 2,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 1,  # 'M'
        46: 2,  # 'N'
        42: 2,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 0,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 2,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 0,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 2,  # 'e'
        18: 0,  # 'f'
        27: 0,  # 'g'
        25: 0,  # 'h'
        3: 0,  # 'i'
        24: 3,  # 'j'
        10: 1,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 0,  # 'n'
        15: 1,  # 'o'
        26: 0,  # 'p'
        7: 1,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 2,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 2,  # 'İ'
        6: 2,  # 'ı'
        40: 2,  # 'Ş'
        19: 1,  # 'ş'
    },
    41: {  # 'İ'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 1,  # 'E'
        52: 0,  # 'F'
        36: 2,  # 'G'
        45: 2,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 0,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 0,  # 'Z'
        1: 1,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 2,  # 'd'
        2: 1,  # 'e'
        18: 0,  # 'f'
        27: 3,  # 'g'
        25: 2,  # 'h'
        3: 2,  # 'i'
        24: 2,  # 'j'
        10: 2,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 3,  # 'n'
        15: 1,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 2,  # 't'
        14: 0,  # 'u'
        32: 0,  # 'v'
        57: 1,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 1,  # 'Ü'
        59: 1,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 1,  # 'ö'
        17: 1,  # 'ü'
        30: 2,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 1,  # 'ş'
    },
    6: {  # 'ı'
        23: 2,  # 'A'
        37: 0,  # 'B'
        47: 0,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 2,  # 'J'
        16: 3,  # 'K'
        49: 0,  # 'L'
        20: 3,  # 'M'
        46: 1,  # 'N'
        42: 0,  # 'O'
        48: 0,  # 'P'
        44: 0,  # 'R'
        35: 0,  # 'S'
        31: 2,  # 'T'
        51: 0,  # 'U'
        38: 0,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 1,  # 'Z'
        1: 3,  # 'a'
        21: 2,  # 'b'
        28: 1,  # 'c'
        12: 3,  # 'd'
        2: 3,  # 'e'
        18: 3,  # 'f'
        27: 3,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 3,  # 'j'
        10: 3,  # 'k'
        5: 3,  # 'l'
        13: 3,  # 'm'
        4: 3,  # 'n'
        15: 0,  # 'o'
        26: 3,  # 'p'
        7: 3,  # 'r'
        8: 3,  # 's'
        9: 3,  # 't'
        14: 3,  # 'u'
        32: 3,  # 'v'
        57: 1,  # 'w'
        58: 1,  # 'x'
        11: 3,  # 'y'
        22: 0,  # 'z'
        63: 1,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 2,  # 'ç'
        61: 0,  # 'î'
        34: 0,  # 'ö'
        17: 3,  # 'ü'
        30: 0,  # 'ğ'
        41: 0,  # 'İ'
        6: 3,  # 'ı'
        40: 0,  # 'Ş'
        19: 0,  # 'ş'
    },
    40: {  # 'Ş'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 1,  # 'D'
        29: 1,  # 'E'
        52: 0,  # 'F'
        36: 1,  # 'G'
        45: 2,  # 'H'
        53: 1,  # 'I'
        60: 0,  # 'J'
        16: 0,  # 'K'
        49: 0,  # 'L'
        20: 2,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 2,  # 'P'
        44: 2,  # 'R'
        35: 1,  # 'S'
        31: 1,  # 'T'
        51: 0,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 2,  # 'Y'
        56: 1,  # 'Z'
        1: 0,  # 'a'
        21: 2,  # 'b'
        28: 0,  # 'c'
        12: 2,  # 'd'
        2: 0,  # 'e'
        18: 3,  # 'f'
        27: 0,  # 'g'
        25: 2,  # 'h'
        3: 3,  # 'i'
        24: 2,  # 'j'
        10: 1,  # 'k'
        5: 0,  # 'l'
        13: 1,  # 'm'
        4: 3,  # 'n'
        15: 2,  # 'o'
        26: 0,  # 'p'
        7: 3,  # 'r'
        8: 2,  # 's'
        9: 2,  # 't'
        14: 1,  # 'u'
        32: 3,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 2,  # 'y'
        22: 0,  # 'z'
        63: 0,  # '·'
        54: 0,  # 'Ç'
        50: 0,  # 'Ö'
        55: 1,  # 'Ü'
        59: 0,  # 'â'
        33: 0,  # 'ç'
        61: 0,  # 'î'
        34: 2,  # 'ö'
        17: 1,  # 'ü'
        30: 2,  # 'ğ'
        41: 0,  # 'İ'
        6: 2,  # 'ı'
        40: 1,  # 'Ş'
        19: 2,  # 'ş'
    },
    19: {  # 'ş'
        23: 0,  # 'A'
        37: 0,  # 'B'
        47: 1,  # 'C'
        39: 0,  # 'D'
        29: 0,  # 'E'
        52: 2,  # 'F'
        36: 1,  # 'G'
        45: 0,  # 'H'
        53: 0,  # 'I'
        60: 0,  # 'J'
        16: 3,  # 'K'
        49: 2,  # 'L'
        20: 0,  # 'M'
        46: 1,  # 'N'
        42: 1,  # 'O'
        48: 1,  # 'P'
        44: 1,  # 'R'
        35: 1,  # 'S'
        31: 0,  # 'T'
        51: 1,  # 'U'
        38: 1,  # 'V'
        62: 0,  # 'W'
        43: 1,  # 'Y'
        56: 0,  # 'Z'
        1: 3,  # 'a'
        21: 1,  # 'b'
        28: 2,  # 'c'
        12: 0,  # 'd'
        2: 3,  # 'e'
        18: 0,  # 'f'
        27: 2,  # 'g'
        25: 1,  # 'h'
        3: 1,  # 'i'
        24: 0,  # 'j'
        10: 2,  # 'k'
        5: 2,  # 'l'
        13: 3,  # 'm'
        4: 0,  # 'n'
        15: 0,  # 'o'
        26: 1,  # 'p'
        7: 3,  # 'r'
        8: 0,  # 's'
        9: 0,  # 't'
        14: 3,  # 'u'
        32: 0,  # 'v'
        57: 0,  # 'w'
        58: 0,  # 'x'
        11: 0,  # 'y'
        22: 2,  # 'z'
        63: 0,  # '·'
        54: 1,  # 'Ç'
        50: 2,  # 'Ö'
        55: 0,  # 'Ü'
        59: 0,  # 'â'
        33: 1,  # 'ç'
        61: 1,  # 'î'
        34: 2,  # 'ö'
        17: 0,  # 'ü'
        30: 1,  # 'ğ'
        41: 1,  # 'İ'
        6: 1,  # 'ı'
        40: 1,  # 'Ş'
        19: 1,  # 'ş'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
ISO_8859_9_TURKISH_CHAR_TO_ORDER = {
    0: 255,  # '\x00'
    1: 255,  # '\x01'
    2: 255,  # '\x02'
    3: 255,  # '\x03'
    4: 255,  # '\x04'
    5: 255,  # '\x05'
    6: 255,  # '\x06'
    7: 255,  # '\x07'
    8: 255,  # '\x08'
    9: 255,  # '\t'
    10: 255,  # '\n'
    11: 255,  # '\x0b'
    12: 255,  # '\x0c'
    13: 255,  # '\r'
    14: 255,  # '\x0e'
    15: 255,  # '\x0f'
    16: 255,  # '\x10'
    17: 255,  # '\x11'
    18: 255,  # '\x12'
    19: 255,  # '\x13'
    20: 255,  # '\x14'
    21: 255,  # '\x15'
    22: 255,  # '\x16'
    23: 255,  # '\x17'
    24: 255,  # '\x18'
    25: 255,  # '\x19'
    26: 255,  # '\x1a'
    27: 255,  # '\x1b'
    28: 255,  # '\x1c'
    29: 255,  # '\x1d'
    30: 255,  # '\x1e'
    31: 255,  # '\x1f'
    32: 255,  # ' '
    33: 255,  # '!'
    34: 255,  # '"'
    35: 255,  # '#'
    36: 255,  # '$'
    37: 255,  # '%'
    38: 255,  # '&'
    39: 255,  # "'"
    40: 255,  # '('
    41: 255,  # ')'
    42: 255,  # '*'
    43: 255,  # '+'
    44: 255,  # ','
    45: 255,  # '-'
    46: 255,  # '.'
    47: 255,  # '/'
    48: 255,  # '0'
    49: 255,  # '1'
    50: 255,  # '2'
    51: 255,  # '3'
    52: 255,  # '4'
    53: 255,  # '5'
    54: 255,  # '6'
    55: 255,  # '7'
    56: 255,  # '8'
    57: 255,  # '9'
    58: 255,  # ':'
    59: 255,  # ';'
    60: 255,  # '<'
    61: 255,  # '='
    62: 255,  # '>'
    63: 255,  # '?'
    64: 255,  # '@'
    65: 23,  # 'A'
    66: 37,  # 'B'
    67: 47,  # 'C'
    68: 39,  # 'D'
    69: 29,  # 'E'
    70: 52,  # 'F'
    71: 36,  # 'G'
    72: 45,  # 'H'
    73: 53,  # 'I'
    74: 60,  # 'J'
    75: 16,  # 'K'
    76: 49,  # 'L'
    77: 20,  # 'M'
    78: 46,  # 'N'
    79: 42,  # 'O'
    80: 48,  # 'P'
    81: 69,  # 'Q'
    82: 44,  # 'R'
    83: 35,  # 'S'
    84: 31,  # 'T'
    85: 51,  # 'U'
    86: 38,  # 'V'
    87: 62,  # 'W'
    88: 65,  # 'X'
    89: 43,  # 'Y'
    90: 56,  # 'Z'
    91: 255,  # '['
    92: 255,  # '\\'
    93: 255,  # ']'
    94: 255,  # '^'
    95: 255,  # '_'
    96: 255,  # '`'
    97: 1,  # 'a'
    98: 21,  # 'b'
    99: 28,  # 'c'
    100: 12,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 27,  # 'g'
    104: 25,  # 'h'
    105: 3,  # 'i'
    106: 24,  # 'j'
    107: 10,  # 'k'
    108: 5,  # 'l'
    109: 13,  # 'm'
    110: 4,  # 'n'
    111: 15,  # 'o'
    112: 26,  # 'p'
    113: 64,  # 'q'
    114: 7,  # 'r'
    115: 8,  # 's'
    116: 9,  # 't'
    117: 14,  # 'u'
    118: 32,  # 'v'
    119: 57,  # 'w'
    120: 58,  # 'x'
    121: 11,  # 'y'
    122: 22,  # 'z'
    123: 255,  # '{'
    124: 255,  # '|'
    125: 255,  # '}'
    126: 255,  # '~'
    127: 255,  # '\x7f'
    128: 180,  # '\x80'
    129: 179,  # '\x81'
    130: 178,  # '\x82'
    131: 177,  # '\x83'
    132: 176,  # '\x84'
    133: 175,  # '\x85'
    134: 174,  # '\x86'
    135: 173,  # '\x87'
    136: 172,  # '\x88'
    137: 171,  # '\x89'
    138: 170,  # '\x8a'
    139: 169,  # '\x8b'
    140: 168,  # '\x8c'
    141: 167,  # '\x8d'
    142: 166,  # '\x8e'
    143: 165,  # '\x8f'
    144: 164,  # '\x90'
    145: 163,  # '\x91'
    146: 162,  # '\x92'
    147: 161,  # '\x93'
    148: 160,  # '\x94'
    149: 159,  # '\x95'
    150: 101,  # '\x96'
    151: 158,  # '\x97'
    152: 157,  # '\x98'
    153: 156,  # '\x99'
    154: 155,  # '\x9a'
    155: 154,  # '\x9b'
    156: 153,  # '\x9c'
    157: 152,  # '\x9d'
    158: 151,  # '\x9e'
    159: 106,  # '\x9f'
    160: 150,  # '\xa0'
    161: 149,  # '¡'
    162: 148,  # '¢'
    163: 147,  # '£'
    164: 146,  # '¤'
    165: 145,  # '¥'
    166: 144,  # '¦'
    167: 100,  # '§'
    168: 143,  # '¨'
    169: 142,  # '©'
    170: 141,  # 'ª'
    171: 140,  # '«'
    172: 139,  # '¬'
    173: 138,  # '\xad'
    174: 137,  # '®'
    175: 136,  # '¯'
    176: 94,  # '°'
    177: 80,  # '±'
    178: 93,  # '²'
    179: 135,  # '³'
    180: 105,  # '´'
    181: 134,  # 'µ'
    182: 133,  # '¶'
    183: 63,  # '·'
    184: 132,  # '¸'
    185: 131,  # '¹'
    186: 130,  # 'º'
    187: 129,  # '»'
    188: 128,  # '¼'
    189: 127,  # '½'
    190: 126,  # '¾'
    191: 125,  # '¿'
    192: 124,  # 'À'
    193: 104,  # 'Á'
    194: 73,  # 'Â'
    195: 99,  # 'Ã'
    196: 79,  # 'Ä'
    197: 85,  # 'Å'
    198: 123,  # 'Æ'
    199: 54,  # 'Ç'
    200: 122,  # 'È'
    201: 98,  # 'É'
    202: 92,  # 'Ê'
    203: 121,  # 'Ë'
    204: 120,  # 'Ì'
    205: 91,  # 'Í'
    206: 103,  # 'Î'
    207: 119,  # 'Ï'
    208: 68,  # 'Ğ'
    209: 118,  # 'Ñ'
    210: 117,  # 'Ò'
    211: 97,  # 'Ó'
    212: 116,  # 'Ô'
    213: 115,  # 'Õ'
    214: 50,  # 'Ö'
    215: 90,  # '×'
    216: 114,  # 'Ø'
    217: 113,  # 'Ù'
    218: 112,  # 'Ú'
    219: 111,  # 'Û'
    220: 55,  # 'Ü'
    221: 41,  # 'İ'
    222: 40,  # 'Ş'
    223: 86,  # 'ß'
    224: 89,  # 'à'
    225: 70,  # 'á'
    226: 59,  # 'â'
    227: 78,  # 'ã'
    228: 71,  # 'ä'
    229: 82,  # 'å'
    230: 88,  # 'æ'
    231: 33,  # 'ç'
    232: 77,  # 'è'
    233: 66,  # 'é'
    234: 84,  # 'ê'
    235: 83,  # 'ë'
    236: 110,  # 'ì'
    237: 75,  # 'í'
    238: 61,  # 'î'
    239: 96,  # 'ï'
    240: 30,  # 'ğ'
    241: 67,  # 'ñ'
    242: 109,  # 'ò'
    243: 74,  # 'ó'
    244: 87,  # 'ô'
    245: 102,  # 'õ'
    246: 34,  # 'ö'
    247: 95,  # '÷'
    248: 81,  # 'ø'
    249: 108,  # 'ù'
    250: 76,  # 'ú'
    251: 72,  # 'û'
    252: 17,  # 'ü'
    253: 6,  # 'ı'
    254: 19,  # 'ş'
    255: 107,  # 'ÿ'
}

ISO_8859_9_TURKISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-9",
    language="Turkish",
    char_to_order_map=ISO_8859_9_TURKISH_CHAR_TO_ORDER,
    language_model=TURKISH_LANG_MODEL,
    typical_positive_ratio=0.97029,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPRSTUVYZabcdefghijklmnoprstuvyzÂÇÎÖÛÜâçîöûüĞğİıŞş",
)
