/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.EllipticCurveType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.PskEcDheServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PskEcDheServerKeyExchangeMessage
extends ECDHEServerKeyExchangeMessage {
    private ModifiableByteArray identityHint;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger identityHintLength;

    public PskEcDheServerKeyExchangeMessage() {
    }

    public PskEcDheServerKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig);
    }

    public ModifiableByteArray getIdentityHint() {
        return this.identityHint;
    }

    public void setIdentityHint(ModifiableByteArray identityHint) {
        this.identityHint = identityHint;
    }

    public void setIdentityHint(byte[] identity) {
        this.identityHint = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identityHint, (byte[])identity);
    }

    public ModifiableInteger getIdentityHintLength() {
        return this.identityHintLength;
    }

    public void setIdentityHintLength(ModifiableInteger identityHintLength) {
        this.identityHintLength = identityHintLength;
    }

    public void setIdentityHintLength(int identityHintLength) {
        this.identityHintLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityHintLength, (Integer)identityHintLength);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskEcDheServerKeyExchangeMessage:");
        sb.append("\n  Curve Type: ");
        if (this.curveType != null && this.curveType.getValue() != null) {
            sb.append((Object)EllipticCurveType.getCurveType((Byte)this.curveType.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Named Group: ");
        if (this.namedGroup != null && this.namedGroup.getValue() != null) {
            sb.append((Object)NamedGroup.getNamedGroup((byte[])this.namedGroup.getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Public Key: ");
        if (this.getPublicKey() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getPublicKey().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new PskEcDheServerKeyExchangeHandler(context);
    }

    @Override
    public String toCompactString() {
        return "ECDHE_PSK_SERVER_KEY_EXCHANGE";
    }
}

