/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.composite.internal.plugins.LocalPluginResolution;
import org.gradle.internal.build.BuildIncluder;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolverContributor;

public class CompositeBuildPluginResolverContributor
implements PluginResolverContributor,
HoldsProjectState {
    private static final String SOURCE_DESCRIPTION = "Included Builds";
    private final CompositeBuildPluginResolver resolver;

    public CompositeBuildPluginResolverContributor(BuildIncluder buildIncluder) {
        this.resolver = new CompositeBuildPluginResolver(buildIncluder);
    }

    public void discardAll() {
        this.resolver.discardAll();
    }

    public void collectResolversInto(Collection<PluginResolver> resolvers) {
        resolvers.add(this.resolver);
    }

    private static class CompositeBuildPluginResolver
    implements PluginResolver {
        private final BuildIncluder buildIncluder;
        private final Map<PluginId, PluginResult> results = new ConcurrentHashMap<PluginId, PluginResult>();

        private CompositeBuildPluginResolver(BuildIncluder buildIncluder) {
            this.buildIncluder = buildIncluder;
        }

        public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result) throws InvalidPluginRequestException {
            PluginResult resolutionResult = this.results.computeIfAbsent(pluginRequest.getId(), this::doResolve);
            if (resolutionResult == PluginResult.NOT_FOUND_IN_ANY_BUILD) {
                result.notFound(CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, "None of the included builds contain this plugin");
            } else if (resolutionResult instanceof ResolvedPlugin) {
                result.found(CompositeBuildPluginResolverContributor.SOURCE_DESCRIPTION, ((ResolvedPlugin)resolutionResult).resolution);
            }
        }

        private PluginResult doResolve(PluginId pluginId) {
            PluginResolution earlyResolution = this.resolveFromIncludedPluginBuilds(pluginId);
            if (earlyResolution != null) {
                return new ResolvedPlugin(earlyResolution);
            }
            return this.resolvePluginFromIncludedBuilds(pluginId);
        }

        private PluginResult resolvePluginFromIncludedBuilds(PluginId requestedPluginId) {
            Collection includedBuilds = this.buildIncluder.getIncludedBuildsForPluginResolution();
            if (includedBuilds.isEmpty()) {
                return PluginResult.NO_INCLUDED_BUILDS;
            }
            for (IncludedBuildState build : includedBuilds) {
                Optional pluginResolution = (Optional)build.withState(gradleInternal -> LocalPluginResolution.resolvePlugin(gradleInternal, requestedPluginId));
                if (!pluginResolution.isPresent()) continue;
                return new ResolvedPlugin((PluginResolution)pluginResolution.get());
            }
            return PluginResult.NOT_FOUND_IN_ANY_BUILD;
        }

        private PluginResolution resolveFromIncludedPluginBuilds(PluginId requestedPluginId) {
            for (IncludedBuildState build : this.buildIncluder.getRegisteredPluginBuilds()) {
                this.buildIncluder.prepareForPluginResolution(build);
                Optional pluginResolution = (Optional)build.withState(gradleInternal -> LocalPluginResolution.resolvePlugin(gradleInternal, requestedPluginId));
                if (!pluginResolution.isPresent()) continue;
                return (PluginResolution)pluginResolution.get();
            }
            return null;
        }

        public void discardAll() {
            this.results.clear();
        }
    }

    private static class ResolvedPlugin
    extends PluginResult {
        final PluginResolution resolution;

        public ResolvedPlugin(PluginResolution resolution) {
            this.resolution = resolution;
        }
    }

    private static abstract class PluginResult {
        static final PluginResult NOT_FOUND_IN_ANY_BUILD = new PluginResult(){};
        static final PluginResult NO_INCLUDED_BUILDS = new PluginResult(){};

        private PluginResult() {
        }
    }
}

