/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.util.ReversedList;

public class HandleMulticaster {
    LinkedList<Handle> handles;

    public HandleMulticaster(Handle handle) {
        this.handles = new LinkedList();
        this.handles.add(handle);
    }

    public HandleMulticaster(Collection<Handle> collection) {
        this.handles = new LinkedList<Handle>(collection);
    }

    public void draw(Graphics2D graphics2D) {
        for (Handle handle : this.handles) {
            handle.draw(graphics2D);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        for (Handle handle : this.handles) {
            handle.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        for (Handle handle : this.handles) {
            handle.keyReleased(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        for (Handle handle : this.handles) {
            handle.keyTyped(keyEvent);
        }
    }

    public void trackEnd(Point point, Point point2, int n, DrawingView drawingView) {
        for (Handle handle : new ReversedList<Handle>(this.handles)) {
            handle.trackEnd(point, point2, n);
        }
    }

    public void trackStart(Point point, int n, DrawingView drawingView) {
        for (Handle handle : this.handles) {
            handle.trackStart(point, n);
        }
    }

    public void trackDoubleClick(Point point, int n, DrawingView drawingView) {
        for (Handle handle : this.handles) {
            handle.trackDoubleClick(point, n);
        }
    }

    public void trackStep(Point point, Point point2, int n, DrawingView drawingView) {
        for (Handle handle : this.handles) {
            handle.trackStep(point, point2, n);
        }
    }
}

